/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.transaction.commit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.alf.text.merge.manual.AlfCompareEditor;
import org.eclipse.papyrus.uml.alf.text.merge.manual.MergeActionDialog;
import org.eclipse.papyrus.uml.alf.text.representation.AlfTextualRepresentation;
import org.eclipse.papyrus.uml.alf.transaction.ActivatorTransaction;
import org.eclipse.papyrus.uml.alf.transaction.commands.AlfCommandFactory;
import org.eclipse.papyrus.uml.alf.transaction.commit.ISyncScenario;
import org.eclipse.papyrus.uml.alf.transaction.commit.Scenario;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.UMLPackage;

public class SyncScenario
extends Scenario
implements ISyncScenario {
    protected AlfTextualRepresentation modelStateToBeCommitted = null;

    @Override
    public void before() {
        if (this.userModelState.isSaved()) {
            if (this.userModelState.isDifferent(this.currentModelState)) {
                MergeActionDialog mergeActionDialog = new MergeActionDialog(Display.getCurrent().getActiveShell(), this.currentModelState.getOwner());
                if (mergeActionDialog.open() == 0) {
                    if (mergeActionDialog.getReturnCode() == 0) {
                        this.userModelState.rebase(this.currentModelState);
                        this.modelStateToBeCommitted = this.userModelState;
                    } else if (mergeActionDialog.getReturnCode() == 1) {
                        CompareUI.openCompareDialog((CompareEditorInput)new AlfCompareEditor(this.userModelState, this.currentModelState));
                    } else {
                        this.currentModelState.reconcile(this.userModelState);
                        this.currentModelState.setSource(this.userModelState.getSource());
                        this.modelStateToBeCommitted = this.currentModelState;
                    }
                }
            } else {
                this.modelStateToBeCommitted = this.userModelState.rebase(this.currentModelState);
            }
        } else {
            this.modelStateToBeCommitted = this.userModelState.rebase(this.currentModelState);
        }
    }

    @Override
    public Command synchronize(HashMap<Element, List<Notification>> changes) {
        CompoundCommand compoundCommand = new CompoundCommand("synchronize");
        for (NamedElement affectedElement : this.getSynchronizationPoints(changes)) {
            compoundCommand.append(this._synchronize(affectedElement));
        }
        return compoundCommand;
    }

    protected Set<NamedElement> getSynchronizationPoints(HashMap<Element, List<Notification>> changes) {
        HashSet<NamedElement> syncPoints = new HashSet<NamedElement>();
        this.preFilter(changes);
        for (Element target : changes.keySet()) {
            if (target instanceof PackageImport || target instanceof ElementImport) {
                syncPoints.addAll(this.getUpdateTargets(target, changes.get(target)));
                continue;
            }
            if (target instanceof Association) {
                syncPoints.addAll(this.getUpdateTargets((Classifier)((Association)target), changes.get(target)));
                continue;
            }
            if (target instanceof Generalization) {
                syncPoints.addAll(this.getUpdateTargets((Generalization)target, changes.get(target)));
                continue;
            }
            if (target instanceof Package) {
                syncPoints.addAll(this.getUpdateTargets((Package)target, changes.get(target)));
                continue;
            }
            if (target instanceof Classifier) {
                syncPoints.addAll(this.getUpdateTargets((Classifier)target, changes.get(target)));
                continue;
            }
            if (target instanceof Feature) {
                syncPoints.addAll(this.getUpdateTargets((Feature)target, changes.get(target)));
                continue;
            }
            if (!(target instanceof EnumerationLiteral)) continue;
            syncPoints.addAll(this.getUpdateTargets((EnumerationLiteral)target, changes.get(target)));
        }
        return syncPoints;
    }

    private void preFilter(HashMap<Element, List<Notification>> changes) {
        for (Element element : changes.keySet()) {
            Iterator<Notification> iterator = changes.get(element).iterator();
            while (iterator.hasNext()) {
                Notification notification = iterator.next();
                if (this.isWorkable(notification)) continue;
                iterator.remove();
            }
        }
    }

    private boolean isWorkable(Notification notification) {
        boolean isWorkable = true;
        if (notification.getNewValue() != null && notification.getEventType() == 3 && notification.getNewValue() instanceof NamedElement) {
            isWorkable = ((NamedElement)notification.getNewValue()).getName() != null;
        }
        return isWorkable;
    }

    protected Set<NamedElement> getUpdateTargets(Element element, List<Notification> changes) {
        assert (element instanceof ElementImport || element instanceof PackageImport) : "element can only be an element import or a package import";
        HashSet<NamedElement> targets = new HashSet<NamedElement>();
        for (Notification notification : changes) {
            switch (notification.getEventType()) {
                case 1: {
                    EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
                    if (feature == UMLPackage.eINSTANCE.getElementImport_ImportingNamespace() || feature == UMLPackage.eINSTANCE.getElementImport_ImportingNamespace()) {
                        if (notification.getNewValue() == null) {
                            targets.addAll(this.getParentPath((Element)notification.getOldValue()));
                            break;
                        }
                        targets.addAll(this.getParentPath((Element)notification.getNewValue()));
                        break;
                    }
                    if (feature == UMLPackage.eINSTANCE.getPackageImport_ImportedPackage()) {
                        if (element.getModel() == ((PackageImport)element).getImportingNamespace()) break;
                        targets.addAll(this.getParentPath(element.getOwner()));
                        break;
                    }
                    targets.addAll(this.getParentPath(element.getOwner()));
                }
            }
        }
        return targets;
    }

    protected Set<NamedElement> getUpdateTargets(Generalization generalization, List<Notification> changes) {
        HashSet<NamedElement> targets = new HashSet<NamedElement>();
        for (Notification notification : changes) {
            switch (notification.getEventType()) {
                case 1: {
                    if (notification.getFeature() == UMLPackage.eINSTANCE.getGeneralization_General()) {
                        targets.addAll(this.getParentPath((Element)generalization.getSpecific()));
                        break;
                    }
                    if (notification.getFeature() != UMLPackage.eINSTANCE.getGeneralization_Specific()) break;
                    targets.addAll(this.getParentPath((Element)notification.getOldValue()));
                    targets.addAll(this.getParentPath((Element)notification.getNewValue()));
                }
            }
        }
        return targets;
    }

    protected Set<NamedElement> getUpdateTargets(Package element, List<Notification> changes) {
        HashSet<NamedElement> targets = new HashSet<NamedElement>();
        block4: for (Notification notification : changes) {
            switch (notification.getEventType()) {
                case 3: {
                    if (notification.getFeature() != UMLPackage.eINSTANCE.getPackage_PackagedElement()) break;
                    targets.addAll(this.getUpdateTarget((Element)((NamedElement)notification.getNewValue())));
                    break;
                }
                case 4: {
                    EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
                    if (feature == UMLPackage.eINSTANCE.getPackage_PackagedElement()) {
                        NamedElement oldValue = (NamedElement)notification.getOldValue();
                        if (oldValue.getModel() == null) break;
                        targets.addAll(this.getUpdateTarget((Element)((NamedElement)notification.getOldValue())));
                        break;
                    }
                    if (feature != UMLPackage.eINSTANCE.getNamespace_PackageImport() && feature != UMLPackage.eINSTANCE.getNamespace_ElementImport()) continue block4;
                    targets.addAll(this.getParentPath((Element)element));
                }
            }
        }
        targets.addAll(this.getUpdateTarget((Element)element));
        return targets;
    }

    protected Set<NamedElement> getUpdateTarget(Element target) {
        HashSet<NamedElement> targets = new HashSet<NamedElement>();
        targets.addAll(this.getParentPath(target));
        targets.addAll(this.getChildren(target));
        return targets;
    }

    private Set<NamedElement> getChildren(Element root) {
        HashSet<NamedElement> children = new HashSet<NamedElement>();
        for (Element element : root.getOwnedElements()) {
            if (element instanceof Package || element instanceof Class) {
                children.add((NamedElement)element);
                children.addAll(this.getChildren(element));
                continue;
            }
            if (element instanceof Enumeration) {
                children.add((NamedElement)element);
                continue;
            }
            if (element instanceof DataType) {
                children.add((NamedElement)element);
                continue;
            }
            if (element instanceof Signal) {
                children.add((NamedElement)element);
                continue;
            }
            if (!(element instanceof Association)) continue;
            children.add((NamedElement)element);
        }
        return children;
    }

    private Set<NamedElement> getParentPath(Element target) {
        HashSet<NamedElement> targets = new HashSet<NamedElement>();
        Element owner = target.getOwner();
        if (owner == null || owner instanceof Model) {
            targets.add((NamedElement)target);
            return targets;
        }
        if (owner instanceof Class || owner instanceof Package || owner instanceof Enumeration) {
            targets.addAll(this.getParentPath(owner));
            if (!(target instanceof Property)) {
                targets.add((NamedElement)target);
            }
            return targets;
        }
        return targets;
    }

    protected Set<NamedElement> getUpdateTargets(Classifier classifier, List<Notification> changes) {
        HashSet<NamedElement> targets = new HashSet<NamedElement>();
        for (Notification notification : changes) {
            switch (notification.getEventType()) {
                case 3: {
                    if (notification.getFeature() == UMLPackage.eINSTANCE.getClass_NestedClassifier()) {
                        targets.addAll(this.getUpdateTarget((Element)notification.getNewValue()));
                        break;
                    }
                    if (notification.getNewValue() instanceof EnumerationLiteral) {
                        Enumeration owner = ((EnumerationLiteral)notification.getNewValue()).getClassifier();
                        if (owner == null) break;
                        targets.addAll(this.getParentPath((Element)owner));
                        break;
                    }
                    if (notification.getNewValue() instanceof Generalization || notification.getNewValue() instanceof ElementImport) {
                        targets.addAll(this.getParentPath((Element)classifier));
                        break;
                    }
                    targets.addAll(this.getParentPath((Element)notification.getNewValue()));
                    break;
                }
                case 4: {
                    EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
                    if (feature == UMLPackage.eINSTANCE.getClassifier_Generalization() || feature == UMLPackage.eINSTANCE.getNamespace_ElementImport()) {
                        targets.addAll(this.getParentPath((Element)classifier));
                        break;
                    }
                    NamedElement oldValue = (NamedElement)notification.getOldValue();
                    if (oldValue == null) break;
                    targets.addAll(this.getParentPath((Element)classifier));
                    break;
                }
                case 1: {
                    targets.addAll(this.getUpdateTarget((Element)classifier));
                }
            }
        }
        return targets;
    }

    protected Set<NamedElement> getUpdateTargets(Feature feature, List<Notification> changes) {
        HashSet<NamedElement> targets = new HashSet<NamedElement>();
        for (Notification notification : changes) {
            switch (notification.getEventType()) {
                case 1: {
                    targets.addAll(this.getParentPath(feature.getOwner()));
                    break;
                }
                case 4: {
                    if (notification.getFeature() != UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter()) break;
                    targets.addAll(this.getParentPath(feature.getOwner()));
                    break;
                }
                case 5: {
                    if (notification.getFeature() != UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter()) break;
                    targets.addAll(this.getParentPath(feature.getOwner()));
                }
            }
        }
        return targets;
    }

    protected Set<NamedElement> getUpdateTargets(EnumerationLiteral enumerationLiteral, List<Notification> changes) {
        HashSet<NamedElement> targets = new HashSet<NamedElement>();
        for (Notification notification : changes) {
            switch (notification.getEventType()) {
                case 1: {
                    targets.addAll(this.getParentPath(enumerationLiteral.getOwner()));
                }
            }
        }
        return targets;
    }

    protected Command _synchronize(NamedElement target) {
        this.init(target);
        this.before();
        return AlfCommandFactory.getInstance().creatSaveCommand(this.modelStateToBeCommitted);
    }

    @Override
    public void after() {
        ActivatorTransaction.logger.info("Synchronization Done");
    }
}

