/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.custom.advice;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.umlrt.custom.utils.MessageSetUtils;
import org.eclipse.papyrus.umlrt.custom.utils.ProtocolContainerUtils;
import org.eclipse.papyrus.umlrt.internals.Activator;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class ProtocolContainerEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.umlrt.ProtocolMessage");
            if (umlRTMessageType == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.approveRequest(request);
            }
            List<IElementType> types = Arrays.asList(type.getAllSuperTypes());
            if (types.contains(umlRTMessageType)) {
                return true;
            }
            return super.approveRequest((IEditCommandRequest)createElementRequest);
        }
        return super.approveRequest(request);
    }

    protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
        IEditCommandRequest editCommandRequest = request.getEditCommandRequest();
        if (editCommandRequest instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)editCommandRequest;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.umlrt.ProtocolMessage");
            if (umlRTMessageType == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.getBeforeEditContextCommand(request);
            }
            List<IElementType> types = Arrays.asList(type.getAllSuperTypes());
            if (types.contains(umlRTMessageType)) {
                GetEditContextCommand command = new GetEditContextCommand(request);
                if (request.getEditContext() instanceof Package) {
                    command.setEditContext((Object)ProtocolContainerUtils.getMessageSetIn((Package)request.getEditContext()));
                }
                return command;
            }
        }
        return super.getBeforeEditContextCommand(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(request.getFeature())) {
            EObject elementToEdit = request.getElementToEdit();
            if (!(elementToEdit instanceof Package)) {
                return super.getBeforeSetCommand(request);
            }
            final String newName = request.getValue() != null ? request.getValue().toString() : "Protocol";
            final Package protocolContainer = (Package)elementToEdit;
            RecordingCommand command = new RecordingCommand(request.getEditingDomain(), "Change Dependents", "Change the names of the dependents of the ProtocolContainer"){

                protected void doExecute() {
                    Collaboration collaboration;
                    Interface interfaceInOut;
                    Interface interfaceOut;
                    Interface interfaceIn = ProtocolContainerUtils.getMessageSetIn(protocolContainer);
                    if (interfaceIn != null) {
                        interfaceIn.setName(MessageSetUtils.computeInterfaceInName(newName));
                    }
                    if ((interfaceOut = ProtocolContainerUtils.getMessageSetOut(protocolContainer)) != null) {
                        interfaceOut.setName(MessageSetUtils.computeInterfaceOutName(newName));
                    }
                    if ((interfaceInOut = ProtocolContainerUtils.getMessageSetInOut(protocolContainer)) != null) {
                        interfaceInOut.setName(MessageSetUtils.computeInterfaceInOutName(newName));
                    }
                    if ((collaboration = ProtocolContainerUtils.getCollaboration(protocolContainer)) != null) {
                        collaboration.setName(newName);
                    }
                }
            };
            ICommand superCommand = super.getAfterSetCommand(request);
            if (superCommand != null) {
                return superCommand.compose((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)command));
            }
            return new EMFtoGMFCommandWrapper((Command)command);
        }
        return super.getAfterSetCommand(request);
    }
}

