/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlrt.custom.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.umlrt.UMLRealTime.RTMessageKind;
import org.eclipse.papyrus.umlrt.UMLRealTime.RTMessageSet;
import org.eclipse.papyrus.umlrt.custom.UMLRTElementTypesEnumerator;
import org.eclipse.papyrus.umlrt.custom.utils.MessageSetUtils;
import org.eclipse.papyrus.umlrt.custom.utils.ProtocolContainerUtils;
import org.eclipse.papyrus.umlrt.custom.utils.ProtocolUtils;
import org.eclipse.papyrus.umlrt.internals.Activator;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProtocolEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)request;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.umlrt.ProtocolMessage");
            if (umlRTMessageType == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.approveRequest(request);
            }
            ArrayList<IElementType> types = new ArrayList<IElementType>(Arrays.asList(type.getAllSuperTypes()));
            types.add(type);
            if (types.contains(umlRTMessageType)) {
                return true;
            }
            return types.contains(ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.uml.Generalization"));
        }
        return super.approveRequest(request);
    }

    protected ICommand getBeforeEditContextCommand(GetEditContextRequest request) {
        IEditCommandRequest editCommandRequest = request.getEditCommandRequest();
        if (editCommandRequest instanceof CreateElementRequest) {
            CreateElementRequest createElementRequest = (CreateElementRequest)editCommandRequest;
            IElementType type = createElementRequest.getElementType();
            IElementType umlRTMessageType = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.umlrt.ProtocolMessage");
            if (umlRTMessageType == null || type == null) {
                Activator.log.debug("RTMessage element type is not accessible");
                return super.getBeforeEditContextCommand(request);
            }
            ArrayList<IElementType> types = new ArrayList<IElementType>(Arrays.asList(type.getAllSuperTypes()));
            types.add(type);
            if (types.contains(umlRTMessageType)) {
                GetEditContextCommand command = new GetEditContextCommand(request);
                if (request.getEditContext() instanceof Collaboration) {
                    IHintedType rTMessageTypeIn = UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_IN;
                    IHintedType rTMessageTypeOut = UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_OUT;
                    IHintedType rTMessageTypeInOut = UMLRTElementTypesEnumerator.PROTOCOL_MESSAGE_INOUT;
                    if (types.contains(rTMessageTypeIn)) {
                        command.setEditContext((Object)ProtocolUtils.getMessageSetIn((Collaboration)request.getEditContext()));
                    } else if (types.contains(rTMessageTypeOut)) {
                        command.setEditContext((Object)ProtocolUtils.getMessageSetOut((Collaboration)request.getEditContext()));
                    } else if (types.contains(rTMessageTypeInOut)) {
                        command.setEditContext((Object)ProtocolUtils.getMessageSetInOut((Collaboration)request.getEditContext()));
                    } else {
                        return super.getBeforeEditContextCommand(request);
                    }
                }
                return command;
            }
        }
        return super.getBeforeEditContextCommand(request);
    }

    protected ICommand getAfterSetCommand(SetRequest request) {
        if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(request.getFeature())) {
            EObject elementToEdit = request.getElementToEdit();
            if (!(elementToEdit instanceof Collaboration)) {
                return super.getAfterSetCommand(request);
            }
            final Collaboration protocol = (Collaboration)elementToEdit;
            final String newName = request.getValue() != null ? request.getValue().toString() : "Protocol";
            RecordingCommand command = new RecordingCommand(request.getEditingDomain(), "Change Dependents", "Change the names of the dependents of the Protocol"){

                protected void doExecute() {
                    Interface interfaceInOut;
                    Interface interfaceOut;
                    Package protocolContainer = ProtocolUtils.getProtocolContainer(protocol);
                    if (protocolContainer == null) {
                        return;
                    }
                    protocolContainer.setName(newName);
                    protocol.setName(newName);
                    Interface interfaceIn = ProtocolContainerUtils.getMessageSetIn(protocolContainer);
                    if (interfaceIn != null) {
                        interfaceIn.setName(MessageSetUtils.computeInterfaceInName(newName));
                    }
                    if ((interfaceOut = ProtocolContainerUtils.getMessageSetOut(protocolContainer)) != null) {
                        interfaceOut.setName(MessageSetUtils.computeInterfaceOutName(newName));
                    }
                    if ((interfaceInOut = ProtocolContainerUtils.getMessageSetInOut(protocolContainer)) != null) {
                        interfaceInOut.setName(MessageSetUtils.computeInterfaceInOutName(newName));
                    }
                }
            };
            ICommand superCommand = super.getAfterSetCommand(request);
            if (superCommand != null) {
                return superCommand.compose((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)command));
            }
            return new EMFtoGMFCommandWrapper((Command)command);
        }
        return super.getAfterSetCommand(request);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Collaboration protocol = (Collaboration)request.getElementToConfigure();
        final String name = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)"Protocol", (Collection)protocol.eContainer().eContents());
        return new ConfigureElementCommand(request){
            private IProgressMonitor progressMonitor;
            private IAdaptable info;

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                this.progressMonitor = progressMonitor;
                this.info = info;
                this.createElement(protocol, name, (IElementType)UMLRTElementTypesEnumerator.PROTOCOL_CONTAINER, Relation.PARENT);
                String nameIn = MessageSetUtils.computeInterfaceInName(name);
                Interface rtMessageSetInt = (Interface)this.createElement(protocol, nameIn, (IElementType)UMLRTElementTypesEnumerator.RT_MESSAGE_SET, Relation.SIBLING);
                this.setRtMsgKind(rtMessageSetInt, RTMessageKind.IN);
                this.createInterfaceRealization(protocol, nameIn, rtMessageSetInt);
                String nameOut = MessageSetUtils.computeInterfaceOutName(name);
                Interface rtMessageSetOutInt = (Interface)this.createElement(protocol, nameOut, (IElementType)UMLRTElementTypesEnumerator.RT_MESSAGE_SET, Relation.SIBLING);
                this.setRtMsgKind(rtMessageSetOutInt, RTMessageKind.OUT);
                this.createUsage(protocol, nameOut, rtMessageSetOutInt);
                this.createElement(protocol, "*", (IElementType)UMLElementTypes.ANY_RECEIVE_EVENT, Relation.SIBLING);
                String nameInOut = MessageSetUtils.computeInterfaceInOutName(name);
                Interface rtMessageSetInOutInt = (Interface)this.createElement(protocol, nameInOut, (IElementType)UMLRTElementTypesEnumerator.RT_MESSAGE_SET, Relation.SIBLING);
                this.setRtMsgKind(rtMessageSetInOutInt, RTMessageKind.IN_OUT);
                this.createInterfaceRealization(protocol, nameInOut, rtMessageSetInOutInt);
                this.createUsage(protocol, nameInOut, rtMessageSetInOutInt);
                protocol.setName(name);
                return CommandResult.newOKCommandResult((Object)protocol);
            }

            private void createUsage(Collaboration protocol2, String name2, Interface rtMessageSet) throws ExecutionException {
                Usage usageOut = (Usage)this.createElement(protocol2, name2, (IElementType)UMLElementTypes.USAGE, Relation.SIBLING);
                usageOut.getClients().add((Object)protocol2);
                usageOut.getSuppliers().add((Object)rtMessageSet);
            }

            private void createInterfaceRealization(Collaboration protocol2, String name2, Interface rtMessageSetInt) throws ExecutionException {
                InterfaceRealization realization = (InterfaceRealization)this.createElement(protocol2, name2, (IElementType)UMLElementTypes.INTERFACE_REALIZATION, Relation.CHILD);
                realization.setContract(rtMessageSetInt);
                realization.setImplementingClassifier((BehavioredClassifier)protocol2);
            }

            private EObject createElement(Collaboration referenceElement, String name2, IElementType elementType, Relation relation) throws ExecutionException {
                if (referenceElement == null || name2 == null) {
                    throw new ExecutionException("Either the referenceElement or the name parameter is null. ");
                }
                EObject newElement = null;
                CreateElementRequest createElementRequest = new CreateElementRequest((EObject)referenceElement.getNearestPackage(), elementType);
                CreateElementCommand command = new CreateElementCommand(createElementRequest);
                command.execute(this.progressMonitor, this.info);
                newElement = command.getNewElement();
                if (newElement == null) {
                    throw new ExecutionException("Element creation problem for " + elementType.getDisplayName() + ".");
                }
                ((NamedElement)newElement).setName(name2);
                if (relation == Relation.CHILD) {
                    if (elementType == UMLElementTypes.INTERFACE_REALIZATION) {
                        referenceElement.getInterfaceRealizations().add((Object)((InterfaceRealization)newElement));
                    } else {
                        referenceElement.createOwnedAttribute(name2, (Type)newElement);
                    }
                } else if (relation == Relation.SIBLING) {
                    Package nearestPackage = referenceElement.getNearestPackage();
                    nearestPackage.getPackagedElements().add((Object)((PackageableElement)newElement));
                } else if (relation == Relation.PARENT) {
                    Package container = (Package)newElement;
                    EList packagedElements = container.getPackagedElements();
                    packagedElements.add((Object)referenceElement);
                }
                return newElement;
            }

            private void setRtMsgKind(Interface rtMessageSetInt, RTMessageKind kind) {
                RTMessageSet rtMessageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)rtMessageSetInt, RTMessageSet.class);
                rtMessageSet.setRtMsgKind(kind);
            }
        };
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        final Collaboration protocol = (Collaboration)request.getElementToConfigure();
        final String name = protocol.getPackage().getName();
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                protocol.setName(name);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    protected ICommand getAfterDestroyElementCommand(DestroyElementRequest request) {
        PackageableElement protocolToDestroy = (PackageableElement)request.getElementToDestroy();
        Package protocolContainerToDestroy = protocolToDestroy.getNearestPackage();
        request = new DestroyElementRequest((EObject)protocolContainerToDestroy, false);
        return new DestroyElementCommand(request);
    }

    private static enum Relation {
        CHILD,
        SIBLING,
        PARENT;

    }
}

