/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.comparator;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.papyrus.infra.nattable.comparator.TableCellLabelProviderComparator;
import org.eclipse.papyrus.infra.nattable.manager.axis.ITreeItemAxisComparator;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.SortLabelProviderFullCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class TreeTableCellLabelProviderComparator
extends TableCellLabelProviderComparator {
    private ITreeItemAxisComparator comparator;

    public TreeTableCellLabelProviderComparator(IConfigRegistry configRegistry) {
        this.comparator = new ITreeItemAxisComparator((INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"}));
    }

    @Override
    public int compare(SortLabelProviderFullCellContextElementWrapper sortWrapper1, SortLabelProviderFullCellContextElementWrapper sortWrapper2) {
        IConfigRegistry configRegistry = sortWrapper1.getConfigRegistry();
        ISortModel sortModel = (ISortModel)configRegistry.getConfigAttribute(NattableConfigAttributes.ROW_SORT_MODEl, "NORMAL", new String[0]);
        int selectedColumn = sortWrapper1.getColumnIndex();
        Assert.isTrue((selectedColumn == sortWrapper2.getColumnIndex() ? 1 : 0) != 0);
        Object row1 = sortWrapper1.getRowObject();
        Object col1 = sortWrapper1.getColumnObject();
        Object row2 = sortWrapper2.getRowObject();
        Object col2 = sortWrapper2.getColumnObject();
        int colIndex1 = sortWrapper1.getColumnIndex();
        int colIndex2 = sortWrapper2.getColumnIndex();
        Assert.isTrue((colIndex1 == colIndex2 ? 1 : 0) != 0);
        SortDirectionEnum direction = sortModel.getSortDirection(colIndex1);
        if (row1 == row2 && col1 == col2) {
            return 0;
        }
        if (row1 instanceof ITreeItemAxis && row2 instanceof ITreeItemAxis) {
            ITreeItemAxis axis1 = (ITreeItemAxis)row1;
            ITreeItemAxis axis2 = (ITreeItemAxis)row2;
            ArrayList<ITreeItemAxis> path1 = new ArrayList<ITreeItemAxis>();
            ArrayList<ITreeItemAxis> path2 = new ArrayList<ITreeItemAxis>();
            TableHelper.getPath(path1, axis1);
            TableHelper.getPath(path2, axis2);
            Object rep1 = AxisUtils.getRepresentedElement(axis1);
            Object rep2 = AxisUtils.getRepresentedElement(axis2);
            if (path1.size() != path2.size() || axis1.getParent() != axis2.getParent() || rep1 instanceof TreeFillingConfiguration || rep2 instanceof TreeFillingConfiguration) {
                int res = this.comparator.compare(axis1, axis2);
                if (direction == SortDirectionEnum.DESC) {
                    res = -res;
                }
                return res;
            }
            return super.compare(sortWrapper1, sortWrapper2);
        }
        if (row1 instanceof ITreeItemAxis || row2 instanceof ITreeItemAxis) {
            throw new UnsupportedOperationException();
        }
        return super.compare(sortWrapper1, sortWrapper2);
    }
}

