/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.filter.AbstractPapyrusMatcherEditor;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;

public class RegexFindEditor
extends AbstractPapyrusMatcherEditor {
    public RegexFindEditor(IColumnAccessor<Object> columnAccesor, int columnIndex, Object matchOn, IConfigRegistry configRegistry) {
        super(columnAccesor, columnIndex, matchOn, configRegistry);
    }

    @Override
    protected ca.odell.glazedlists.matchers.Matcher<Object> createMatcher(IColumnAccessor<Object> columnAccesor, final int columnIndex, final Object matchOn, final IConfigRegistry configRegistry) {
        Assert.isTrue((boolean)(matchOn instanceof String));
        return new ca.odell.glazedlists.matchers.Matcher<Object>(){

            public boolean matches(Object item) {
                Pattern pattern;
                if (matchOn == null || ((String)matchOn).isEmpty()) {
                    return true;
                }
                try {
                    pattern = Pattern.compile((String)matchOn);
                }
                catch (Exception e) {
                    return true;
                }
                INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
                int index = manager.getRowElementsList().indexOf(item);
                BodyLayerStack stack = manager.getBodyLayerStack();
                ILayerCell cell = stack.getCellByPosition(columnIndex, index);
                Object value = CellManagerFactory.INSTANCE.getCrossValue(manager.getColumnElement(columnIndex), item, manager);
                IDisplayConverter displayConverter = (IDisplayConverter)configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", new String[]{"FILTER_COLUMN_" + columnIndex});
                Object res = displayConverter.canonicalToDisplayValue(cell, configRegistry, value);
                String str = (String)res;
                Matcher m = pattern.matcher(str);
                return m.find();
            }
        };
    }
}

