/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;

public class ColumnDestroyAxisHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAxisManager axisManager = this.getColumnAxisManager();
        NatEventData eventData = this.getNatEventData();
        if (axisManager != null && eventData != null) {
            axisManager.destroyAxis(this.getFullSelectedColumnsIndex(eventData));
        }
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        NatEventData eventData = this.getNatEventData();
        boolean enabled = false;
        IAxisManager axisManager = this.getColumnAxisManager();
        if (this.isEnabled() && axisManager != null && eventData != null) {
            List<Integer> col = this.getFullSelectedColumnsIndex(eventData);
            enabled = axisManager.canDestroyAxis(col);
        }
        this.setBaseEnabled(enabled);
    }
}

