/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.papyrus.infra.nattable.dialog.PasteImportStatusDialog;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.manager.PasteAxisInNattableManager;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableClipboardUtils;
import org.eclipse.swt.widgets.Display;

public class PasteInTableHandler
extends AbstractTableHandler {
    public static final String OPEN_DIALOG_ON_FAIL_BOOLEAN_PARAMETER = "openDialogOnFail";
    public static final String OPEN__PROGRESS_MONITOR_DIALOG = "openProgressMonitorDialog";
    private boolean useProgressMonitorDialog = true;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CSVPasteHelper pasteHelper = new CSVPasteHelper();
        boolean openProgressMonitor = this.useProgressMonitorDialog;
        Object value = event.getParameters().get(OPEN__PROGRESS_MONITOR_DIALOG);
        if (value instanceof Boolean) {
            openProgressMonitor = (Boolean)value;
        }
        PasteAxisInNattableManager pasteManager = new PasteAxisInNattableManager(this.getCurrentNattableModelManager(), pasteHelper, openProgressMonitor, TableClipboardUtils.getClipboardContentsAsString());
        IStatus result = pasteManager.doPaste();
        this.displayDialog(event, result);
        return result;
    }

    private void displayDialog(ExecutionEvent event, IStatus result) {
        Object res;
        if (!result.isOK() && ((res = event.getParameters().get(OPEN_DIALOG_ON_FAIL_BOOLEAN_PARAMETER)) == null || Boolean.TRUE.equals(res))) {
            new PasteImportStatusDialog(Display.getDefault().getActiveShell(), result).open();
        }
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.getCurrentNattableModelManager() != null);
    }
}

