/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.listener;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class UpdateTableContentListener
implements ResourceSetListener {
    protected NattableModelManager tableManager;
    protected IAxisManagerForEventList axisManager;

    public UpdateTableContentListener(NattableModelManager tableManager, IAxisManagerForEventList axisManager) {
        this.tableManager = tableManager;
        this.axisManager = axisManager;
    }

    public NotificationFilter getFilter() {
        return new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                if (notification.isTouch() || notification.getNotifier() == null || notification.getFeature() == null) {
                    return false;
                }
                Object notifier = notification.getNotifier();
                if (notifier instanceof EObject && EcoreUtil.getRootContainer((EObject)((EObject)notifier).eClass()) == NattablePackage.eINSTANCE) {
                    try {
                        if (TableHelper.findTable((EObject)notifier) != UpdateTableContentListener.this.tableManager.getTable()) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
                return true;
            }
        };
    }

    public final Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    protected boolean containsTreeFillingConfigurationChange(ResourceSetChangeEvent event) {
        List notifications = event.getNotifications();
        for (Notification current : notifications) {
            Object feature = current.getFeature();
            if (feature != NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_OwnedAxisConfigurations()) continue;
            return true;
        }
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (this.containsTreeFillingConfigurationChange(event)) {
            this.axisManager.fillingConfigurationsHaveChanged();
            return;
        }
        List notifications = event.getNotifications();
        int i = 0;
        while (i < notifications.size()) {
            Notification current = (Notification)notifications.get(i);
            boolean isAMove = false;
            if (current.getEventType() != 3 || current.getFeature() != NattableaxisPackage.eINSTANCE.getITreeItemAxis_Children() || !(current.getNotifier() instanceof ITreeItemAxis) || ((EObject)current.getNotifier()).eContainer() != null && !(((EObject)current.getNotifier()).eContainer() instanceof AbstractAxisProvider)) {
                if (i + 1 < notifications.size()) {
                    Notification next = (Notification)notifications.get(i + 1);
                    int currentEvent = current.getEventType();
                    int nextEventType = next.getEventType();
                    if (currentEvent == 6 && nextEventType == 5 && current.getNotifier() == next.getNotifier() && current.getFeature() == next.getFeature()) {
                        Collection oldValue = (Collection)current.getOldValue();
                        Collection newValue = (Collection)next.getNewValue();
                        if (oldValue.size() == newValue.size()) {
                            for (Object object : newValue) {
                                if (oldValue.contains(object)) continue;
                                isAMove = true;
                            }
                        }
                    }
                }
                if (isAMove) {
                    if (i + 2 < notifications.size()) {
                        ++i;
                    }
                } else if (this.axisManager != null) {
                    this.axisManager.manageEvent(current);
                }
            }
            ++i;
        }
        this.tableManager.refreshNatTable();
    }

    public final boolean isAggregatePrecommitListener() {
        return false;
    }

    public final boolean isPrecommitOnly() {
        return false;
    }

    public final boolean isPostcommitOnly() {
        return false;
    }
}

