/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.cell;

import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.tools.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.infra.tools.converter.ConvertedValueContainer;

public abstract class AbstractCellManager
implements ICellManager {
    @Override
    public final Object getValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return this.doGetValue(columnElement, rowElement, tableManager);
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public void setValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        Command cmd = this.getSetValueCommand(domain, columnElement, rowElement, newValue, tableManager);
        if (cmd != null && cmd.canExecute()) {
            domain.getCommandStack().execute(cmd);
        }
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement) {
        return false;
    }

    @Override
    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueSolver, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public AbstractStringValueConverter getOrCreateStringValueConverterClass(INattableModelManager tableManager, Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator) {
        AbstractStringValueConverter converter = existingConverters.get(this.getClass());
        if (converter == null) {
            converter = new AbstractStringValueConverter(){

                public void dispose() {
                }

                protected ConvertedValueContainer<?> doDeduceValueFromString(Object type, String valueAsString) {
                    return null;
                }
            };
            existingConverters.put(converter.getClass(), converter);
        }
        return converter;
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap) {
        return this.isCellEditable(columnElement, rowElement);
    }

    @Override
    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueConverter, INattableModelManager tableManager, Map<?, ?> sharedMap) {
    }
}

