/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.tree.painter.TreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class PapyrusIndentedTreeImagePainter
extends IndentedTreeImagePainter {
    public PapyrusIndentedTreeImagePainter() {
    }

    public PapyrusIndentedTreeImagePainter(int treeIndent, CellEdgeEnum cellEdge, TreeImagePainter treeImagePainter) {
        super(treeIndent, cellEdge, treeImagePainter);
    }

    public PapyrusIndentedTreeImagePainter(int treeIndent, ICellPainter interiorPainter, boolean paintBg, boolean interiorPainterToSpanFullWidth) {
        super(treeIndent, interiorPainter, paintBg, interiorPainterToSpanFullWidth);
    }

    public PapyrusIndentedTreeImagePainter(int treeIndent, ICellPainter interiorPainter, CellEdgeEnum cellEdge, boolean paintBg, int spacing, boolean paintDecorationDependent) {
        super(treeIndent, interiorPainter, cellEdge, paintBg, spacing, paintDecorationDependent);
    }

    public PapyrusIndentedTreeImagePainter(int treeIndent, ICellPainter interiorPainter, CellEdgeEnum cellEdge, ICellPainter decoratorPainter, boolean paintBg, int spacing, boolean paintDecorationDependent) {
        super(treeIndent, interiorPainter, cellEdge, decoratorPainter, paintBg, spacing, paintDecorationDependent);
    }

    public PapyrusIndentedTreeImagePainter(int treeIndent, TreeImagePainter treeImagePainter) {
        super(treeIndent, treeImagePainter);
    }

    public PapyrusIndentedTreeImagePainter(int treeIndent) {
        super(treeIndent);
    }

    public Rectangle getWrappedPainterBounds(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        INattableModelManager tableManager = this.getTableManager(configRegistry);
        int depth = this.getDepth(cell);
        if (TableHelper.isMultiColumnTreeTable(tableManager)) {
            depth = 1;
        }
        int indent = this.getIndent(depth);
        return new Rectangle(bounds.x + indent, bounds.y, bounds.width - indent, bounds.height);
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        INattableModelManager tableManager = this.getTableManager(configRegistry);
        int depth = this.getDepth(cell);
        if (TableHelper.isMultiColumnTreeTable(tableManager)) {
            depth = 1;
        }
        int indent = this.getIndent(depth);
        return indent + super.getPreferredWidth(cell, gc, configRegistry);
    }

    protected int getDepth(ILayerCell cell) {
        int depth = 0;
        for (String configLabel : cell.getConfigLabels().getLabels()) {
            if (!configLabel.startsWith("TREE_DEPTH_")) continue;
            String[] tokens = configLabel.split("_");
            depth = Integer.valueOf(tokens[tokens.length - 1]);
        }
        return depth;
    }

    private INattableModelManager getTableManager(IConfigRegistry configRegistry) {
        return (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
    }
}

