/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.sort.painter.SortableHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class PapyrusSortableHeaderTextPainter
extends SortableHeaderTextPainter {
    public PapyrusSortableHeaderTextPainter() {
        this((ICellPainter)new TextPainter());
    }

    public PapyrusSortableHeaderTextPainter(ICellPainter interiorPainter) {
        this(interiorPainter, CellEdgeEnum.RIGHT);
    }

    public PapyrusSortableHeaderTextPainter(ICellPainter interiorPainter, CellEdgeEnum cellEdge) {
        this(interiorPainter, cellEdge, (ICellPainter)new SortIconPainter(true));
    }

    public PapyrusSortableHeaderTextPainter(ICellPainter interiorPainter, CellEdgeEnum cellEdge, ICellPainter decoratorPainter) {
        this.setWrappedPainter((ICellPainter)new CellPainterDecorator(interiorPainter, cellEdge, decoratorPainter));
    }

    protected static class SortIconPainter
    extends org.eclipse.nebula.widgets.nattable.sort.painter.SortIconPainter {
        public SortIconPainter(boolean paintBg) {
            super(paintBg);
        }

        public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
            INattableModelManager manager;
            AbstractHeaderAxisConfiguration config;
            int position = cell.getRowPosition();
            if (position == 0 && (config = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable((manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"})).getTable())) != null && config.isDisplayIndex()) {
                return;
            }
            Image image = this.getImage(cell, configRegistry);
            if (image != null) {
                Rectangle imageBounds = image.getBounds();
                imageBounds = new Rectangle(imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height);
                IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
                int y = bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height);
                gc.drawImage(image, bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.width), y);
            }
        }

        public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
            int width = super.getPreferredHeight(cell, gc, configRegistry);
            width = (int)((float)width + (gc.getFont().getFontData()[0].height + 2.0f));
            return width;
        }

        public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
            return super.getPreferredWidth(cell, gc, configRegistry);
        }
    }
}

