/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IPasteConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.parsers.RowIterator;
import org.eclipse.papyrus.infra.nattable.paste.IValueSetter;
import org.eclipse.papyrus.infra.nattable.paste.PastePostActionRegistry;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.PasteTreeUtils;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.tools.converter.AbstractStringValueConverter;
import org.eclipse.ui.progress.UIJob;

public class PasteEObjectTreeAxisInNattableCommandProvider {
    private static final int MIN_AXIS_FOR_PROGRESS_MONITOR = 5;
    private EStructuralFeature containmentFeature;
    private IElementType typeToCreate;
    private INattableModelManager tableManager;
    private boolean detachedMode;
    private List<String> postActions;
    private final CSVPasteHelper pasteHelper;
    private Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters;
    private static final String PASTE_ACTION_TASK_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteAction;
    private static final String PASTE_ROWS_JOB_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteRows;
    private static final String PASTE_COLUMNS_JOB_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteColumns;
    private static final String PASTE_COMMAND_HAS_BEEN_CANCELLED = Messages.PasteEObjectAxisInTableCommandProvider_CommandCreationHasBeenCancelled;
    private static final String PASTE_COMMAND_CANT_BE_EXECUTED = "The Paste command can't be executed";
    private static final String PASTE_COMMAND_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteFromStringCommand;
    private static final String CREATING_ELEMENT_A_NUMBER_X_Y = Messages.PasteEObjectAxisInTableCommandProvider_CreatingAnumberXonY;
    protected final boolean pasteColumn;
    private final int nbOperationsToDo;
    private int refreshEachReadChar = 1000;
    private boolean isDisposed = false;
    private final Reader reader;
    private CSVParser parser;
    int factor;
    private Table table;
    final TransactionalEditingDomain tableEditingDomain;
    final TransactionalEditingDomain contextEditingDomain;
    final EObject tableContext;
    List<Object> secondAxis;

    public PasteEObjectTreeAxisInNattableCommandProvider(INattableModelManager tableManager, boolean pasteColumn, Reader reader, CSVPasteHelper pasteHelper2, long totalSize) {
        this.tableManager = tableManager;
        this.existingConverters = new HashMap<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter>();
        this.pasteHelper = pasteHelper2;
        this.reader = reader;
        this.pasteColumn = pasteColumn;
        this.table = tableManager.getTable();
        this.tableContext = this.table.getContext();
        this.tableEditingDomain = TableEditingDomainUtils.getTableEditingDomain(this.table);
        this.contextEditingDomain = TableEditingDomainUtils.getTableContextEditingDomain(this.table);
        long div = -1L;
        if (totalSize > Integer.MAX_VALUE) {
            div = totalSize / Integer.MAX_VALUE;
            if (div > Integer.MAX_VALUE) {
                div *= 2L;
            }
            this.factor = (int)div;
            this.nbOperationsToDo = (int)(totalSize / div);
        } else {
            this.factor = 1;
            this.nbOperationsToDo = (int)totalSize;
        }
        this.parser = this.pasteHelper.createParser(reader);
        this.init();
    }

    protected List<IPasteConfiguration> getPasteConfigurationFor(int depth) {
        ArrayList<IPasteConfiguration> pasteConfs = new ArrayList<IPasteConfiguration>();
        for (TreeFillingConfiguration current : FillingConfigurationUtils.getAllTreeFillingConfiguration(this.table)) {
            if (current.getDepth() != depth) continue;
            PasteEObjectConfiguration pasteConf = current.getPasteConfiguration();
            Assert.isNotNull((Object)pasteConf);
            pasteConfs.add((IPasteConfiguration)pasteConf);
        }
        if (depth == 0 && pasteConfs.size() == 0 && FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, depth)) {
            IPasteConfiguration conf = (IPasteConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.tableManager.getTable(), NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), false);
            pasteConfs.add(conf);
        }
        return pasteConfs;
    }

    protected IPasteConfiguration getPasteConfigurationsFor(int depth, String categoryName) {
        if (depth == 0 && !FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0)) {
            LocalTableHeaderAxisConfiguration conf = this.table.getLocalRowHeaderAxisConfiguration();
            if (conf != null) {
                conf = this.table.getTableConfiguration().getRowHeaderAxisConfiguration();
            }
            List<TreeFillingConfiguration> filling = FillingConfigurationUtils.getAllTreeFillingConfigurationForDepth(this.table, depth);
            ArrayList<PasteEObjectConfiguration> referencedPasteConf = new ArrayList<PasteEObjectConfiguration>();
            for (TreeFillingConfiguration tmp : filling) {
                if (tmp.getPasteConfiguration() == null) continue;
                referencedPasteConf.add(tmp.getPasteConfiguration());
            }
            for (IAxisConfiguration axisConf : conf.getOwnedAxisConfigurations()) {
                if (!(axisConf instanceof IPasteConfiguration) || referencedPasteConf.contains(axisConf)) continue;
                return (IPasteConfiguration)axisConf;
            }
        }
        for (TreeFillingConfiguration curr : FillingConfigurationUtils.getAllTreeFillingConfiguration(this.table)) {
            Object element;
            if (curr.getDepth() != depth) continue;
            if (categoryName == null || categoryName.isEmpty()) {
                return curr.getPasteConfiguration();
            }
            String featureName = curr.getAxisUsedAsAxisProvider().getAlias();
            if ((featureName == null || "".equals(featureName)) && (element = curr.getAxisUsedAsAxisProvider().getElement()) instanceof EStructuralFeature) {
                featureName = ((EStructuralFeature)element).getName();
            }
            if (!categoryName.equals(featureName)) continue;
            return curr.getPasteConfiguration();
        }
        return null;
    }

    protected boolean pasteInDetachedMode(Table table) {
        List<IPasteConfiguration> confs = this.getPasteConfigurationFor(0);
        for (IPasteConfiguration current : confs) {
            if (!current.isDetachedMode()) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.detachedMode = this.pasteInDetachedMode(this.table);
        this.secondAxis = this.tableManager.getColumnElementsList();
    }

    public void executePasteFromStringCommand(boolean useProgressMonitor) {
        if (this.isDisposed) {
            throw new RuntimeException("The command provider is disposed");
        }
        String pasteJobName = PASTE_ROWS_JOB_NAME;
        this.executePasteFromStringCommandInAttachedMode(useProgressMonitor, pasteJobName);
    }

    private void executePasteFromStringCommandInDetachedMode(boolean useProgressMonitor, String pasteJobName) {
        final HashMap<Object, Object> sharedMap = new HashMap<Object, Object>();
        sharedMap.put("pastedElementContainer", this.tableContext);
        sharedMap.put("referencesToSet", new ArrayList());
        sharedMap.put("cellsToAdd", new ArrayList());
        sharedMap.put("additionnal_post_actions_to_conclude_paste", new ArrayList());
        if (!useProgressMonitor) {
            ICommand pasteCommand = this.getPasteFromStringCommandInDetachedMode(this.contextEditingDomain, this.tableEditingDomain, (IProgressMonitor)new NullProgressMonitor(), sharedMap);
            try {
                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
            sharedMap.clear();
        } else {
            UIJob job = new UIJob(pasteJobName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ICommand pasteCommand = PasteEObjectTreeAxisInNattableCommandProvider.this.getPasteFromStringCommandInDetachedMode(PasteEObjectTreeAxisInNattableCommandProvider.this.contextEditingDomain, PasteEObjectTreeAxisInNattableCommandProvider.this.tableEditingDomain, monitor, sharedMap);
                    if (pasteCommand == null) {
                        return new Status(8, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_HAS_BEEN_CANCELLED);
                    }
                    if (pasteCommand.canExecute()) {
                        try {
                            try {
                                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, monitor, null);
                            }
                            catch (ExecutionException e) {
                                Status status = new Status(4, "org.eclipse.papyrus.infra.nattable", "An exception occured during the paste", (Throwable)e);
                                sharedMap.clear();
                                return status;
                            }
                        }
                        finally {
                            sharedMap.clear();
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    sharedMap.clear();
                    return new Status(4, "org.eclipse.papyrus.infra.nattable", PasteEObjectTreeAxisInNattableCommandProvider.PASTE_COMMAND_CANT_BE_EXECUTED);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private void executePasteFromStringCommandInAttachedMode(boolean useProgressMonitor, String pasteJobName) {
        if (!useProgressMonitor) {
            ICommand pasteCommand = this.getPasteFromStringCommandInAttachedMode(this.contextEditingDomain, this.tableEditingDomain, (IProgressMonitor)new NullProgressMonitor());
            try {
                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
        } else {
            UIJob job = new UIJob(pasteJobName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ICommand pasteCommand = PasteEObjectTreeAxisInNattableCommandProvider.this.getPasteFromStringCommandInAttachedMode(PasteEObjectTreeAxisInNattableCommandProvider.this.contextEditingDomain, PasteEObjectTreeAxisInNattableCommandProvider.this.tableEditingDomain, monitor);
                    if (pasteCommand == null) {
                        return new Status(8, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_HAS_BEEN_CANCELLED);
                    }
                    if (pasteCommand.canExecute()) {
                        try {
                            EMFCommandOperation op = new EMFCommandOperation(PasteEObjectTreeAxisInNattableCommandProvider.this.contextEditingDomain, (Command)new GMFtoEMFCommandWrapper(pasteCommand));
                            CheckedOperationHistory.getInstance().execute((IUndoableOperation)op, monitor, null);
                        }
                        catch (Exception e) {
                            return new Status(4, "org.eclipse.papyrus.infra.nattable", "An exception occured during the paste", (Throwable)e);
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "org.eclipse.papyrus.infra.nattable", PasteEObjectTreeAxisInNattableCommandProvider.PASTE_COMMAND_CANT_BE_EXECUTED);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private ICommand getPasteRowFromStringCommandInDetachedMode(final TransactionalEditingDomain contextEditingDomain, final TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor, final Map<Object, Object> sharedMap) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        final ArrayList<EObject> createdElements = new ArrayList<EObject>();
        EClass eClassToCreate = this.typeToCreate.getEClass();
        EFactory eFactory = eClassToCreate.getEPackage().getEFactoryInstance();
        int nbCreatedElements = 0;
        long readChar = 0L;
        long previousreadChar = 0L;
        RowIterator rowIter = this.parser.parse();
        while (rowIter.hasNext()) {
            CellIterator cellIter = (CellIterator)rowIter.next();
            if (!cellIter.hasNext()) continue;
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return null;
            }
            previousreadChar = this.parser.getReadCharacters();
            if (progressMonitor != null && (readChar += this.parser.getReadCharacters() - previousreadChar) > (long)this.refreshEachReadChar) {
                readChar = 0L;
                progressMonitor.subTask(NLS.bind((String)"{0} {1} have been created.", (Object[])new Object[]{nbCreatedElements, this.typeToCreate.getEClass().getName()}));
                progressMonitor.worked(this.refreshEachReadChar);
            }
            ++nbCreatedElements;
            EObject createdElement = eFactory.create(eClassToCreate);
            createdElements.add(createdElement);
            ++nbCreatedElements;
            for (String currentPostActions : this.postActions) {
                PastePostActionRegistry.INSTANCE.doPostAction(this.tableManager, currentPostActions, this.tableContext, createdElement, sharedMap, null);
            }
            Iterator<Object> secondAxisIterator = this.secondAxis.iterator();
            while (secondAxisIterator.hasNext() && cellIter.hasNext()) {
                Object rowObject;
                Object columnObject;
                Object currentAxis = secondAxisIterator.next();
                String valueAsString = (String)cellIter.next();
                if (this.pasteColumn) {
                    columnObject = createdElement;
                    rowObject = currentAxis;
                } else {
                    columnObject = currentAxis;
                    rowObject = createdElement;
                }
                boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject, sharedMap);
                if (!isEditable) continue;
                AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, this.tableManager, this.existingConverters, this.pasteHelper.getMultiValueSeparator());
                CellManagerFactory.INSTANCE.setStringValue(columnObject, rowObject, valueAsString, converter, this.tableManager, sharedMap);
            }
            while (cellIter.hasNext()) {
                cellIter.next();
            }
        }
        AbstractTransactionalCommand pasteCommand = new AbstractTransactionalCommand(tableEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Collection postActions = PasteEObjectTreeAxisInNattableCommandProvider.this.getPostActions();
                Collection postActionsAddedByCellManagers = (Collection)sharedMap.get("additionnal_post_actions_to_conclude_paste");
                postActions.addAll(postActionsAddedByCellManagers);
                List cells = (List)sharedMap.get("cellsToAdd");
                List valueToSet = (List)sharedMap.get("referencesToSet");
                int nbTasks = 1;
                ++nbTasks;
                nbTasks += postActions.size();
                ++nbTasks;
                nbTasks += valueToSet.size();
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        PasteEObjectTreeAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.beginTask(Messages.PasteEObjectAxisInTableCommandProvider_FinishingThePaste, nbTasks);
                }
                AddCommand.create((EditingDomain)contextEditingDomain, (Object)PasteEObjectTreeAxisInNattableCommandProvider.this.tableContext, (Object)PasteEObjectTreeAxisInNattableCommandProvider.this.containmentFeature, (Collection)createdElements).execute();
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_AddingElementToTheTable);
                }
                Command cmd = null;
                cmd = PasteEObjectTreeAxisInNattableCommandProvider.this.pasteColumn ? PasteEObjectTreeAxisInNattableCommandProvider.this.tableManager.getAddColumnElementCommand(createdElements) : PasteEObjectTreeAxisInNattableCommandProvider.this.tableManager.getAddRowElementCommand(createdElements);
                if (cmd != null) {
                    cmd.execute();
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_DoingAdditionalActions);
                }
                for (String currentPostActions : postActions) {
                    PastePostActionRegistry.INSTANCE.concludePostAction(PasteEObjectTreeAxisInNattableCommandProvider.this.tableManager, currentPostActions, sharedMap);
                    progressMonitor.worked(1);
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(Messages.PasteEObjectAxisInTableCommandProvider_LinkingReferencesToTheModel);
                }
                if (valueToSet.size() > 0) {
                    for (IValueSetter current : valueToSet) {
                        current.doSetValue((EditingDomain)contextEditingDomain);
                        if (progressMonitor == null) continue;
                        if (progressMonitor.isCanceled()) {
                            return CommandResult.newCancelledCommandResult();
                        }
                        progressMonitor.worked(1);
                    }
                }
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.worked(1);
                }
                AddCommand.create((EditingDomain)tableEditingDomain, (Object)PasteEObjectTreeAxisInNattableCommandProvider.this.table, (Object)NattablePackage.eINSTANCE.getTable_Cells(), (Collection)cells).execute();
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
                PasteEObjectTreeAxisInNattableCommandProvider.this.localDispose();
                return CommandResult.newOKCommandResult();
            }
        };
        return pasteCommand;
    }

    private ICommand getPasteFromStringCommandInDetachedMode(TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, IProgressMonitor progressMonitor, Map<Object, Object> sharedMap) {
        if (!this.pasteColumn) {
            return this.getPasteRowFromStringCommandInDetachedMode(contextEditingDomain, tableEditingDomain, progressMonitor, sharedMap);
        }
        return null;
    }

    private boolean isCategory(int nbReadCell) {
        return PasteTreeUtils.isCategory(nbReadCell, FillingConfigurationUtils.getMaxDepthForTree(this.table), StyleUtils.getHiddenDepths(this.table), FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0));
    }

    private int getDepth(int nbReadCell) {
        return PasteTreeUtils.getDepth(nbReadCell, FillingConfigurationUtils.getMaxDepthForTree(this.table), StyleUtils.getHiddenDepths(this.table), FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0));
    }

    protected void crossCellIteratorToFirstBodyCell(CellIterator cellIter, int nbReadCell) {
        if (!TableHelper.isSingleColumnTreeTable(this.table)) {
            int nbColumns = (FillingConfigurationUtils.getMaxDepthForTree(this.table) + 1) * 2;
            if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0)) {
                --nbColumns;
            }
            List<Integer> hiddenDepth = StyleUtils.getHiddenDepths(this.table);
            int nbVisibleColumns = nbColumns - hiddenDepth.size();
            while (nbReadCell < nbVisibleColumns) {
                cellIter.next();
                ++nbReadCell;
            }
        }
    }

    private ICommand getPasteRowFromStringInAttachedModeCommand(final TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, final IProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        AbstractTransactionalCommand pasteAllCommand = new AbstractTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ArrayList<Status> resultStatus = new ArrayList<Status>();
                long readChar = 0L;
                long previousreadChar = 0L;
                HashMap<Integer, EObject> contextMap = new HashMap<Integer, EObject>();
                contextMap.put(-1, PasteEObjectTreeAxisInNattableCommandProvider.this.table.getContext());
                HashMap<Integer, PasteEObjectConfiguration> confMap = new HashMap<Integer, PasteEObjectConfiguration>();
                RowIterator rowIter = PasteEObjectTreeAxisInNattableCommandProvider.this.parser.parse();
                int nbCreatedElements = 0;
                int nbReadLine = 0;
                block2: while (rowIter.hasNext()) {
                    CellIterator cellIter = (CellIterator)rowIter.next();
                    ++nbReadLine;
                    if (!cellIter.hasNext()) continue;
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        PasteEObjectTreeAxisInNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    previousreadChar = PasteEObjectTreeAxisInNattableCommandProvider.this.parser.getReadCharacters();
                    if (progressMonitor != null && (readChar += PasteEObjectTreeAxisInNattableCommandProvider.this.parser.getReadCharacters() - previousreadChar) > (long)PasteEObjectTreeAxisInNattableCommandProvider.this.refreshEachReadChar) {
                        readChar = 0L;
                        progressMonitor.worked(PasteEObjectTreeAxisInNattableCommandProvider.this.refreshEachReadChar);
                    }
                    Iterator<Object> secondAxisIterator = PasteEObjectTreeAxisInNattableCommandProvider.this.secondAxis.iterator();
                    while (cellIter.hasNext()) {
                        String valueAsString = (String)cellIter.next();
                        int nbReadCell = 1;
                        while (cellIter.hasNext() && valueAsString.isEmpty()) {
                            valueAsString = (String)cellIter.next();
                            ++nbReadCell;
                        }
                        int depth = PasteEObjectTreeAxisInNattableCommandProvider.this.getDepth(nbReadCell);
                        boolean isCategory = PasteEObjectTreeAxisInNattableCommandProvider.this.isCategory(nbReadCell);
                        if (isCategory) {
                            confMap.put(depth, (PasteEObjectConfiguration)PasteEObjectTreeAxisInNattableCommandProvider.this.getPasteConfigurationsFor(depth, valueAsString));
                            while (cellIter.hasNext()) {
                                cellIter.next();
                            }
                            continue block2;
                        }
                        PasteEObjectConfiguration pasteConfToUse = (PasteEObjectConfiguration)confMap.get(depth);
                        if (pasteConfToUse == null) {
                            pasteConfToUse = (PasteEObjectConfiguration)PasteEObjectTreeAxisInNattableCommandProvider.this.getPasteConfigurationsFor(depth, null);
                            if (pasteConfToUse != null) {
                                confMap.put(depth, pasteConfToUse);
                            } else {
                                Status status = new Status(4, "org.eclipse.papyrus.infra.nattable", 1, NLS.bind((String)"No paste configuration found for the depth {0}", (Object)depth), null);
                                return new CommandResult((IStatus)status);
                            }
                        }
                        IElementType typeToCreate = ElementTypeRegistry.getInstance().getType(pasteConfToUse.getPastedElementId());
                        EStructuralFeature containmentFeature = pasteConfToUse.getPasteElementContainementFeature();
                        EObject context = (EObject)contextMap.get(depth - 1);
                        CreateElementRequest createRequest1 = new CreateElementRequest(contextEditingDomain, context, typeToCreate, (EReference)containmentFeature);
                        IElementEditService creationContextCommandProvider = ElementEditServiceUtils.getCommandProvider((Object)context);
                        ICommand commandCreation = creationContextCommandProvider.getEditCommand((IEditCommandRequest)createRequest1);
                        if (!commandCreation.canExecute()) continue;
                        commandCreation.execute(monitor, info);
                        ++nbCreatedElements;
                        CommandResult res = commandCreation.getCommandResult();
                        commandCreation.dispose();
                        Object createdElement = res.getReturnValue();
                        contextMap.put(depth, (EObject)createdElement);
                        if (createdElement instanceof EObject) {
                            Command addCommand;
                            EObject eobject = (EObject)createdElement;
                            EStructuralFeature nameFeature = ((EObject)createdElement).eClass().getEStructuralFeature("name");
                            if (nameFeature != null) {
                                ICommand setName;
                                SetRequest setNameRequest = new SetRequest(contextEditingDomain, (EObject)createdElement, nameFeature, (Object)valueAsString);
                                IElementEditService createdElementCommandProvider = ElementEditServiceUtils.getCommandProvider((Object)createdElement);
                                if (createdElementCommandProvider != null && (setName = createdElementCommandProvider.getEditCommand((IEditCommandRequest)setNameRequest)) != null && setName.canExecute()) {
                                    setName.execute(monitor, info);
                                }
                            }
                            if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(PasteEObjectTreeAxisInNattableCommandProvider.this.table, 0) && ((EObject)createdElement).eContainer() == PasteEObjectTreeAxisInNattableCommandProvider.this.tableContext && (addCommand = PasteEObjectTreeAxisInNattableCommandProvider.this.tableManager.getAddRowElementCommand(Collections.singleton(createdElement))) != null) {
                                addCommand.execute();
                                addCommand.dispose();
                            }
                        }
                        PasteEObjectTreeAxisInNattableCommandProvider.this.crossCellIteratorToFirstBodyCell(cellIter, nbReadCell);
                        while (secondAxisIterator.hasNext() && cellIter.hasNext()) {
                            AbstractStringValueConverter converter;
                            Command setValueCommand;
                            Object rowObject;
                            valueAsString = (String)cellIter.next();
                            Object currentAxis = secondAxisIterator.next();
                            Object columnObject = currentAxis;
                            boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnObject, rowObject = createdElement);
                            if (!isEditable || (setValueCommand = CellManagerFactory.INSTANCE.getSetStringValueCommand(contextEditingDomain, columnObject, rowObject, valueAsString, converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnObject, rowObject, PasteEObjectTreeAxisInNattableCommandProvider.this.tableManager, PasteEObjectTreeAxisInNattableCommandProvider.this.existingConverters, PasteEObjectTreeAxisInNattableCommandProvider.this.pasteHelper.getMultiValueSeparator()), PasteEObjectTreeAxisInNattableCommandProvider.this.tableManager)) == null || !setValueCommand.canExecute()) continue;
                            try {
                                setValueCommand.execute();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            setValueCommand.dispose();
                        }
                        int tooManyCellOnRow = 0;
                        while (cellIter.hasNext()) {
                            cellIter.next();
                            ++tooManyCellOnRow;
                        }
                        if (tooManyCellOnRow == 0) continue;
                        String message = NLS.bind((String)"There are too many cells on the rows number {0}", (Object)nbReadLine);
                        Status status = new Status(2, "org.eclipse.papyrus.infra.nattable", 6, message, null);
                        resultStatus.add(status);
                    }
                }
                progressMonitor.done();
                PasteEObjectTreeAxisInNattableCommandProvider.this.localDispose();
                if (resultStatus.isEmpty()) {
                    return CommandResult.newOKCommandResult();
                }
                MultiStatus resultingStatus = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, resultStatus.toArray(new IStatus[resultStatus.size()]), "The paste has been done, but we found some problems", null);
                return new CommandResult((IStatus)resultingStatus);
            }
        };
        return pasteAllCommand;
    }

    protected boolean useDetachedMode() {
        return false;
    }

    protected Command getSetNameCommandusingLabel(Object createdElement, String label) {
        return null;
    }

    private ICommand getPasteFromStringCommandInAttachedMode(TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, IProgressMonitor progressMonitor) {
        if (this.pasteColumn) {
            return new UnexecutableCommand((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", "We can't paste columns in a tree table"));
        }
        return this.getPasteRowFromStringInAttachedModeCommand(contextEditingDomain, tableEditingDomain, progressMonitor);
    }

    private Collection<String> getPostActions() {
        return this.postActions;
    }

    private void localDispose() {
        this.isDisposed = true;
        this.tableManager = null;
        this.typeToCreate = null;
        this.containmentFeature = null;
        for (AbstractStringValueConverter current : this.existingConverters.values()) {
            current.dispose();
        }
        this.existingConverters.clear();
        try {
            this.reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

