/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.tree;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;

public class ITreeItemAxisHelper {
    private ITreeItemAxisHelper() {
    }

    public static ITreeItemAxis createITreeItemAxis(TransactionalEditingDomain editingDomain, final ITreeItemAxis parentAxis, Object child, AxisManagerRepresentation axisRepresentation) {
        if (!(child instanceof EObject)) {
            Object axis = null;
            throw new UnsupportedOperationException("The only managed case is EObject, others cases are not yet managed");
        }
        EObjectTreeItemAxis axis = NattableaxisFactory.eINSTANCE.createEObjectTreeItemAxis();
        axis.setElement((EObject)child);
        try {
            if (editingDomain != null) {
                GMFUnsafe.write((TransactionalEditingDomain)editingDomain, (Runnable)new Runnable((ITreeItemAxis)axis, axisRepresentation){
                    private final /* synthetic */ ITreeItemAxis val$axis;
                    private final /* synthetic */ AxisManagerRepresentation val$axisRepresentation;
                    {
                        this.val$axis = iTreeItemAxis2;
                        this.val$axisRepresentation = axisManagerRepresentation;
                    }

                    @Override
                    public void run() {
                        if (parentAxis != null) {
                            this.val$axis.setParent(parentAxis);
                        }
                        this.val$axis.setManager(this.val$axisRepresentation);
                    }
                });
            } else {
                if (parentAxis != null) {
                    axis.setParent(parentAxis);
                }
                axis.setManager(axisRepresentation);
            }
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
        catch (RollbackException e) {
            Activator.log.error((Throwable)e);
        }
        return axis;
    }

    public static void destroyITreeItemAxis(TransactionalEditingDomain domain, final ITreeItemAxis axisToDestroy) {
        try {
            GMFUnsafe.write((TransactionalEditingDomain)domain, (Runnable)new Runnable(){

                @Override
                public void run() {
                    axisToDestroy.setParent(null);
                }
            });
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
        catch (RollbackException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public static final void linkITreeItemAxisToSemanticElement(Map<Object, Set<ITreeItemAxis>> managedElements, ITreeItemAxis axis) {
        Object object = axis.getElement();
        Set<ITreeItemAxis> value = managedElements.get(object);
        if (value == null) {
            value = new HashSet<ITreeItemAxis>();
            managedElements.put(object, value);
        }
        value.add(axis);
    }

    public static final void unlinkITreeItemAxisToSemanticElement(Map<Object, Set<ITreeItemAxis>> managedElements, ITreeItemAxis axis) {
        Object element = axis.getElement();
        Set<ITreeItemAxis> values = managedElements.get(element);
        if (values != null) {
            values.remove(axis);
        }
        if (values == null || values.size() == 0) {
            managedElements.remove(element);
        }
    }
}

