/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;

public class StyleUtils {
    public static final List<Integer> getHiddenDepths(Table table) {
        IntListValueStyle style = StyleUtils.getHiddenDepthsValueStyle(table);
        if (style == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(style.getIntListValue());
    }

    public static final List<Integer> getHiddenDepths(INattableModelManager manager) {
        return StyleUtils.getHiddenDepths(manager.getTable());
    }

    public static final IntListValueStyle getHiddenDepthsValueStyle(Table table) {
        return (IntListValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getIntListValueStyle(), "hiddenCategoriesByDepth");
    }

    public static final IntListValueStyle getHiddenDepthsValueStyle(INattableModelManager manager) {
        return StyleUtils.getHiddenDepthsValueStyle(manager.getTable());
    }

    public static final boolean isHiddenDepth(INattableModelManager manager, int depth) {
        return StyleUtils.isHiddenDepth(manager.getTable(), depth);
    }

    public static final boolean isHiddenDepth(Table table, int depth) {
        List<Integer> hidden = StyleUtils.getHiddenDepths(table);
        return hidden.contains(depth);
    }
}

