/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.widgets.util.ImageDescriptorManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.widgets";
    private static Activator plugin;
    public static LogHelper log;
    public ImageDescriptorManager imageDescriptorManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)plugin);
        this.imageDescriptorManager = new ImageDescriptorManager();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        log = null;
        this.imageDescriptorManager.reset();
        this.imageDescriptorManager = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Image getImage(String path) {
        return this.getImage(PLUGIN_ID, path);
    }

    public Image getImage(String pluginId, String path) {
        String key;
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(key = String.valueOf(pluginId) + "/" + path);
        if (image == null) {
            registry.put(key, AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path));
            image = registry.get(key);
        }
        return image;
    }

    public Image getImage(ImageDescriptor descriptor) {
        ImageRegistry registry = this.getImageRegistry();
        if (this.imageDescriptorManager == null || registry == null) {
            return null;
        }
        String key = this.imageDescriptorManager.getKey(descriptor);
        Image image = registry.get(key);
        if (image == null) {
            registry.put(key, descriptor);
            image = registry.get(key);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String pluginId, String path) {
        String key;
        ImageRegistry registry = this.getImageRegistry();
        ImageDescriptor descriptor = registry.getDescriptor(key = String.valueOf(pluginId) + "/" + path);
        if (descriptor == null) {
            registry.put(key, AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path));
            descriptor = registry.getDescriptor(key);
        }
        return descriptor;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        return this.getImageDescriptor(PLUGIN_ID, path);
    }

    public Image getImageFromPlugin(String imagePath) {
        if (imagePath.startsWith("/")) {
            imagePath = imagePath.substring(1, imagePath.length());
            String pluginId = imagePath.substring(0, imagePath.indexOf("/"));
            String path = imagePath.substring(imagePath.indexOf("/"), imagePath.length());
            return this.getImage(pluginId, path);
        }
        return this.getImage(imagePath);
    }
}

