/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.papyrus.sysml.diagram.internalblock.Activator;
import org.eclipse.papyrus.sysml.diagram.internalblock.migration.OldElementTypes;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.util.ViewServiceUtil;

public class InternalBlockDiagramReconcilierUndefinedTo100
extends DiagramReconciler {
    public ICommand getReconcileCommand(Diagram diagram) {
        try {
            CompoundCommand cc = new CompoundCommand("Update Internal Block Diagram From Undefined To 1.0.0");
            Command updateCommandFromUndefinedTo_081 = InternalBlockDiagramReconcilierUndefinedTo100.getUpdateCommandFromUndefinedTo_081(diagram);
            Command updateCommandFrom081To_091 = InternalBlockDiagramReconcilierUndefinedTo100.getUpdateCommandFrom081To_091(diagram);
            cc.append(updateCommandFromUndefinedTo_081);
            cc.append(updateCommandFrom081To_091);
            return EMFtoGMFCommandWrapper.wrap((Command)cc);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            return UnexecutableCommand.INSTANCE;
        }
    }

    public static Command getUpdateCommandFromUndefinedTo_081(final Diagram diagram) throws Exception {
        RecordingCommand command = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)diagram), "Diagram version updater (from undefined to 0.8.1)"){
            private Map<String, String> conversionMapping;
            {
                super($anonymous0, $anonymous1);
                this.conversionMapping = new HashMap<String, String>();
            }

            private void initializeMappings() {
                this.conversionMapping.put(OldElementTypes.CLASS.getSemanticHint(), "shape_sysml_block_as_composite");
                this.conversionMapping.put("5156", "label_sysml_block_name");
                this.conversionMapping.put("7073", "compartment_sysml_structure");
                this.conversionMapping.put(OldElementTypes.PROPERTY_CN.getSemanticHint(), "shape_sysml_blockproperty_as_composite");
                this.conversionMapping.put("5126", "label_uml_property_label");
                this.conversionMapping.put("7077", "compartment_sysml_blockproperty_structure");
                this.conversionMapping.put("6029", "affixedlabel_uml_appliedstereotype");
                this.conversionMapping.put(OldElementTypes.CONNECTOR.getSemanticHint(), "link_uml_connector");
                this.conversionMapping.put("6025", "linklabel_uml_appliedstereotype");
                this.conversionMapping.put("6050", "linklabel_uml_connector_label");
                this.conversionMapping.put("6051", "linklabel_uml_connector_source_multiplicity");
                this.conversionMapping.put("6052", "linklabel_uml_connector_target_multiplicity");
            }

            protected void doExecute() {
                this.initializeMappings();
                ArrayList<View> blockViews = new ArrayList<View>();
                ArrayList<View> portViews = new ArrayList<View>();
                TreeIterator it = diagram.eAllContents();
                while (it.hasNext()) {
                    EObject currentEObject = (EObject)it.next();
                    if (!(currentEObject instanceof View)) continue;
                    View currentView = (View)currentEObject;
                    if (this.conversionMapping.containsKey(currentView.getType())) {
                        if (currentView.getType().equals(OldElementTypes.CLASS.getSemanticHint())) {
                            blockViews.add(currentView);
                        }
                        currentView.setType(this.conversionMapping.get(currentView.getType()));
                    }
                    if (!currentView.getType().equals(OldElementTypes.PORT_CN.getSemanticHint()) && !currentView.getType().equals("5125")) continue;
                    portViews.add(currentView);
                }
                for (View portView : portViews) {
                    EObject eObject = portView.getElement();
                    if (((ISpecializationType)SysMLElementTypes.FLOW_PORT).getMatcher().matches(eObject)) {
                        if (portView.getType().equals(OldElementTypes.PORT_CN.getSemanticHint())) {
                            portView.setType("shape_sysml_flowport_as_affixed");
                        }
                        if (!portView.getType().equals("5125")) continue;
                        portView.setType("affixedlabel_sysml_flowport_label");
                        continue;
                    }
                    if (portView.getType().equals(OldElementTypes.PORT_CN.getSemanticHint())) {
                        portView.setType("shape_uml_port_as_affixed");
                    }
                    if (!portView.getType().equals("5125")) continue;
                    portView.setType("affixedlabel_uml_port_label");
                }
                for (View blockView : blockViews) {
                    EAnnotation stereotypeAnnotation = blockView.getEAnnotation("Stereotype_Annotation");
                    blockView.getEAnnotations().remove((Object)stereotypeAnnotation);
                }
            }

            public boolean canUndo() {
                return false;
            }
        };
        return command;
    }

    public static Command getUpdateCommandFrom081To_091(final Diagram diagram) throws Exception {
        RecordingCommand command = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)diagram), "Diagram version updater (from 0.8.1 to 0.9.1)"){
            private Map<String, String> conversionMapping;
            private List<IStatus> results;
            {
                super($anonymous0, $anonymous1);
                this.conversionMapping = new HashMap<String, String>();
                this.results = new ArrayList<IStatus>();
            }

            private void initializeMappings() {
                this.conversionMapping.put("shape_sysml_nestedblockproperty_as_composite", "shape_sysml_blockproperty_as_composite");
            }

            protected void doExecute() {
                this.initializeMappings();
                ViewServiceUtil.forceLoad();
                ArrayList<View> nestedPropertyViews = new ArrayList<View>();
                ArrayList<View> failedPropertyUpdates = new ArrayList<View>();
                TreeIterator it = diagram.eAllContents();
                while (it.hasNext()) {
                    View currentView;
                    String currentViewType;
                    EObject currentEObject = (EObject)it.next();
                    if (!(currentEObject instanceof View) || !this.conversionMapping.containsKey(currentViewType = (currentView = (View)currentEObject).getType()) || !"shape_sysml_nestedblockproperty_as_composite".equals(currentViewType)) continue;
                    currentView.setType(this.conversionMapping.get(currentView.getType()));
                    nestedPropertyViews.add(currentView);
                    Node compartment = ViewService.createNode((View)currentView, (String)"compartment_sysml_blockproperty_structure", (PreferencesHint)PreferencesHint.USE_DEFAULTS);
                    if (compartment != null) continue;
                    failedPropertyUpdates.add(currentView);
                }
                if (!failedPropertyUpdates.isEmpty()) {
                    Activator.log.warn("Impossible to create a compartment for the properties: " + failedPropertyUpdates);
                }
            }

            public boolean canUndo() {
                return false;
            }

            public Collection<IStatus> getResult() {
                return this.results;
            }
        };
        return command;
    }
}

