/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.ui.editor;

import com.google.inject.Injector;
import org.eclipse.papyrus.uml.alf.libraries.helper.AlfUtil;
import org.eclipse.papyrus.uml.alf.ui.editor.AlfEditedResourceProvider;
import org.eclipse.papyrus.uml.alf.ui.editor.AlfEditorKeyListener;
import org.eclipse.papyrus.uml.alf.ui.internal.AlfActivator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class AlfPopupEditor {
    protected Element contextElement;
    protected Object[] args;
    protected Injector alfInjector = null;
    protected Shell alfEditorParentComposite;
    protected EmbeddedEditorModelAccess embeddedEditorAccess;

    public AlfPopupEditor(Element contextElement, Object[] args) {
        if (contextElement == null) {
            return;
        }
        this.contextElement = contextElement;
        this.alfInjector = AlfActivator.getInstance().getInjector("org.eclipse.papyrus.uml.alf.Alf");
        this.args = args;
    }

    public void openEditor() {
        AlfUtil.getInstance().clean();
        this.alfEditorParentComposite = new Shell(18544);
        String title = "";
        if (this.contextElement != null && this.contextElement instanceof NamedElement) {
            title = String.valueOf(title) + "Editing " + this.contextElement.eClass().getName() + " " + ((NamedElement)this.contextElement).getQualifiedName();
        }
        this.alfEditorParentComposite.setLayout((Layout)new FillLayout());
        this.alfEditorParentComposite.setText(title);
        AlfEditedResourceProvider embeddedAlfResourceProvider = new AlfEditedResourceProvider(this.alfInjector);
        EmbeddedEditorFactory editorFactory = (EmbeddedEditorFactory)this.alfInjector.getInstance(EmbeddedEditorFactory.class);
        EmbeddedEditor editor = editorFactory.newEditor((IEditedResourceProvider)embeddedAlfResourceProvider).showErrorAndWarningAnnotations().withParent((Composite)this.alfEditorParentComposite);
        this.embeddedEditorAccess = editor.createPartialEditor();
        this.embeddedEditorAccess.updateModel("", AlfUtil.getInstance().getTextualRepresentation(this.contextElement), "");
        this.registerKeyListener(editor.getViewer().getTextWidget());
        this.alfEditorParentComposite.setVisible(true);
    }

    protected void registerKeyListener(StyledText textWidget) {
        AlfEditorKeyListener keyListener = new AlfEditorKeyListener(this.contextElement, this.args, this.embeddedEditorAccess);
        textWidget.addVerifyKeyListener((VerifyKeyListener)keyListener);
        textWidget.addKeyListener((KeyListener)keyListener);
    }
}

