/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.migration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.InsertFloatingLabelFromMapCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;

public class ClassReconcilier
extends DiagramReconciler {
    final String CONTAINMENT_LINK_OLD_VISUAL_ID = "4022";
    final String CONTAINMENT_LINK_NEW_VISUAL_ID = Integer.toString(4023);
    final String CONTAINMENT_LINK_AFFIXEDNODE_OLD_VISUAL_ID = "3032";

    public ICommand getReconcileCommand(Diagram diagram) {
        CompositeCommand cc = new CompositeCommand("Migrate Class diagram and derivated diagrams");
        this.updateContainmentLinks(diagram, cc);
        cc.add((IUndoableOperation)new InsertFloatingLabelFromMapCommand(diagram, this.getFloatingLabelMap()));
        return cc;
    }

    private Map<String, String> getFloatingLabelMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(String.valueOf(2008), String.valueOf(8510));
        map.put(String.valueOf(2013), String.valueOf(8504));
        map.put(String.valueOf(2015), String.valueOf(8521));
        map.put(String.valueOf(3010), String.valueOf(8518));
        map.put(String.valueOf(2002), String.valueOf(8503));
        map.put(String.valueOf(3021), String.valueOf(8513));
        map.put(String.valueOf(2010), String.valueOf(8502));
        map.put(String.valueOf(3027), String.valueOf(8520));
        map.put(String.valueOf(2014), String.valueOf(8522));
        map.put(String.valueOf(2006), String.valueOf(8508));
        map.put(String.valueOf(3025), String.valueOf(8516));
        map.put(String.valueOf(2099), String.valueOf(8512));
        map.put(String.valueOf(3040), String.valueOf(8517));
        map.put(String.valueOf(2001), String.valueOf(8505));
        map.put(String.valueOf(3020), String.valueOf(8509));
        map.put(String.valueOf(2004), String.valueOf(8507));
        map.put(String.valueOf(3023), String.valueOf(8515));
        map.put(String.valueOf(2009), String.valueOf(8511));
        map.put(String.valueOf(3026), String.valueOf(8519));
        map.put(String.valueOf(2003), String.valueOf(8506));
        map.put(String.valueOf(3022), String.valueOf(8514));
        return map;
    }

    protected void updateContainmentLinks(Diagram diagram, CompositeCommand cc) {
        cc.add((IUndoableOperation)new UpdateContainmentLinksCommand(diagram));
        TreeIterator allContentIterator = diagram.eAllContents();
        while (allContentIterator.hasNext()) {
            EObject eObject = (EObject)allContentIterator.next();
            if (!(eObject instanceof View) || !((View)eObject).getType().equals("3032")) continue;
            DeleteCommand cmd = new DeleteCommand((View)eObject);
            cc.add((IUndoableOperation)cmd);
        }
    }

    protected class UpdateContainmentLinksCommand
    extends AbstractCommand {
        protected final Diagram diagram;

        public UpdateContainmentLinksCommand(Diagram diagram) {
            super("Update containementLinks in Class diagram and derivated diagrams");
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            TreeIterator allContentIterator = this.diagram.eAllContents();
            while (allContentIterator.hasNext()) {
                Edge edge;
                View source;
                EObject sourceContainer;
                EObject eObject = (EObject)allContentIterator.next();
                if (!(eObject instanceof Edge) || !((Edge)eObject).getType().equals("4022") || !((sourceContainer = (source = (edge = (Edge)eObject).getSource()).eContainer()) instanceof View)) continue;
                edge.setSource((View)sourceContainer);
                edge.setType(ClassReconcilier.this.CONTAINMENT_LINK_NEW_VISUAL_ID);
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

