/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.uml.diagram.sequence.command.ChangeEdgeTargetCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateElementAndNodeCommand;
import org.eclipse.papyrus.uml.diagram.sequence.part.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.uml2.uml.InteractionFragment;

public class PromptCreateElementAndNodeCommand
extends CreateOrSelectElementCommand {
    private static final List<IElementType> executionTypes = new ArrayList<IElementType>();
    private final CompoundCommand command;
    private TransactionalEditingDomain editingDomain;
    private CreateConnectionViewRequest.ConnectionViewDescriptor descriptor;
    private ShapeNodeEditPart targetEP;
    private EObject target;
    private Point location;
    private InteractionFragment container;
    private CreateConnectionRequest request;
    private EditPart sourceEP;

    static {
        executionTypes.add(UMLElementTypes.ActionExecutionSpecification_3006);
        executionTypes.add(UMLElementTypes.BehaviorExecutionSpecification_3003);
    }

    public PromptCreateElementAndNodeCommand(Command createCommand, TransactionalEditingDomain editingDomain, CreateConnectionViewRequest.ConnectionViewDescriptor descriptor, ShapeNodeEditPart targetEP, EObject target, EditPart sourceEP, CreateConnectionRequest request, InteractionFragment container) {
        super(Display.getCurrent().getActiveShell(), executionTypes);
        this.editingDomain = editingDomain;
        this.descriptor = descriptor;
        this.targetEP = targetEP;
        this.target = target;
        this.sourceEP = sourceEP;
        this.request = request;
        this.location = request.getLocation();
        this.container = container;
        this.command = new CompoundCommand();
        this.command.add(createCommand);
        this.setPopupMenu(new PopupMenu(executionTypes, this.getLabelProvider()){

            public boolean show(Control parent) {
                Menu menu = new Menu(parent);
                this.createMenuItems(menu, this, new ArrayList());
                menu.setVisible(true);
                org.eclipse.swt.graphics.Point loc = PromptCreateElementAndNodeCommand.this.getMenuLocation();
                if (loc != null) {
                    menu.setLocation(loc);
                }
                Display display = menu.getDisplay();
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (!menu.isDisposed()) {
                    menu.dispose();
                    if (this.getResult() != null) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    protected org.eclipse.swt.graphics.Point getMenuLocation() {
        if (this.location == null || this.sourceEP == null || this.sourceEP.getViewer() == null) {
            return null;
        }
        Control control = this.sourceEP.getViewer().getControl();
        org.eclipse.swt.graphics.Point menuLoc = new org.eclipse.swt.graphics.Point(this.location.x, this.location.y);
        return control.toDisplay(menuLoc);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.sourceEP.eraseSourceFeedback((Request)this.request);
        this.targetEP.eraseSourceFeedback((Request)this.request);
        CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
        if (!cmdResult.getStatus().isOK()) {
            return cmdResult;
        }
        Object returnValue = cmdResult.getReturnValue();
        if (!(returnValue instanceof IHintedType)) {
            return cmdResult;
        }
        IHintedType connectionType = (IHintedType)returnValue;
        CreateElementAndNodeCommand createExecutionSpecificationCommand = new CreateElementAndNodeCommand(this.editingDomain, this.targetEP, this.target, connectionType, this.location);
        createExecutionSpecificationCommand.putCreateElementRequestParameter("InteractionFragment Container", this.container);
        this.command.add((Command)new ICommandProxy((ICommand)createExecutionSpecificationCommand));
        ChangeEdgeTargetCommand changeTargetCommand = new ChangeEdgeTargetCommand(this.editingDomain, createExecutionSpecificationCommand, this.descriptor, "(1.0, 0.0)");
        this.command.add((Command)new ICommandProxy((ICommand)changeTargetCommand));
        this.command.execute();
        return CommandResult.newOKCommandResult((Object)this.descriptor);
    }

    public boolean canUndo() {
        return this.command != null && this.command.canUndo();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.command != null) {
            this.command.redo();
        }
        return super.doRedoWithResult(progressMonitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.command != null) {
            this.command.undo();
        }
        return super.doUndoWithResult(progressMonitor, info);
    }

    protected ILabelProvider getLabelProvider() {
        return new CreateOrSelectElementCommand.LabelProvider(){

            public String getText(Object object) {
                if (object instanceof IHintedType) {
                    IHintedType elementType = (IHintedType)object;
                    switch (UMLVisualIDRegistry.getVisualID(elementType.getSemanticHint())) {
                        case 3006: {
                            return Messages.createActionExecutionSpecification2CreationTool_title;
                        }
                        case 3003: {
                            return Messages.createBehaviorExecutionSpecification3CreationTool_title;
                        }
                    }
                }
                return super.getText(object);
            }
        };
    }
}

