/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class GeneralOrderingReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public GeneralOrderingReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof GeneralOrdering)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof OccurrenceSpecification) || !(this.newEnd instanceof OccurrenceSpecification)) {
            return false;
        }
        OccurrenceSpecification target = this.getLink().getAfter();
        if (!(this.getLink().eContainer() instanceof InteractionFragment)) {
            return false;
        }
        InteractionFragment container = (InteractionFragment)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistGeneralOrdering_4012(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof OccurrenceSpecification) || !(this.newEnd instanceof OccurrenceSpecification)) {
            return false;
        }
        OccurrenceSpecification source = this.getLink().getBefore();
        if (!(this.getLink().eContainer() instanceof InteractionFragment)) {
            return false;
        }
        InteractionFragment container = (InteractionFragment)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistGeneralOrdering_4012(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setBefore(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setAfter(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected GeneralOrdering getLink() {
        return (GeneralOrdering)this.getElementToEdit();
    }

    protected OccurrenceSpecification getOldSource() {
        return (OccurrenceSpecification)this.oldEnd;
    }

    protected OccurrenceSpecification getNewSource() {
        return (OccurrenceSpecification)this.newEnd;
    }

    protected OccurrenceSpecification getOldTarget() {
        return (OccurrenceSpecification)this.oldEnd;
    }

    protected OccurrenceSpecification getNewTarget() {
        return (OccurrenceSpecification)this.newEnd;
    }
}

