/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.helper.NotificationHelper;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BehaviorExecutionSpecificationBehaviorEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomInteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ExecutionSpecificationEndEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.ExecutionGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomBehaviorExecutionSpecificationItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.BehaviorDisplayHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomBehaviorExecutionSpecificationEditPart
extends BehaviorExecutionSpecificationEditPart {
    private NotificationHelper helper = new NotificationHelper(new UIAdapterImpl(){

        protected void safeNotifyChanged(Notification msg) {
            CustomBehaviorExecutionSpecificationEditPart.this.handleNotificationEvent(msg);
        }
    });
    private EditPartListener selfRemovingListener;

    public CustomBehaviorExecutionSpecificationEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomBehaviorExecutionSpecificationItemSemanticEditPolicy());
        this.removeEditPolicy("GraphicalNodeEditPolicy");
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ExecutionGraphicalNodeEditPolicy());
    }

    @Override
    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof BehaviorExecutionSpecificationBehaviorEditPart) {
                    return new BorderItemSelectionEditPolicy(){

                        protected List createSelectionHandles() {
                            MoveHandle mh = new MoveHandle((GraphicalEditPart)this.getHost());
                            mh.setBorder(null);
                            return Collections.singletonList(mh);
                        }

                        protected org.eclipse.gef.commands.Command getMoveCommand(ChangeBoundsRequest request) {
                            IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
                            IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
                            if (borderItemLocator != null) {
                                LayoutConstraint layout = ((Node)this.getHost().getModel()).getLayoutConstraint();
                                Point location = new Point();
                                if (layout instanceof Location) {
                                    location.x = ((Location)layout).getX();
                                    location.y = ((Location)layout).getY();
                                }
                                location.translate(request.getMoveDelta());
                                SetBoundsCommand moveCommand = new SetBoundsCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), location);
                                return new ICommandProxy((ICommand)moveCommand);
                            }
                            return null;
                        }
                    };
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected org.eclipse.gef.commands.Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected org.eclipse.gef.commands.Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    @Override
    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(16, 60){

            protected boolean isDefaultAnchorArea(PrecisionPoint p) {
                return false;
            }

            public ConnectionAnchor getConnectionAnchor(String terminal) {
                int position;
                if (terminal != null && terminal.indexOf("{") != -1 && terminal.indexOf("}") != -1 && (8 == (position = AnchorHelper.FixedAnchorEx.parsePosition(terminal)) || 32 == position)) {
                    return new AnchorHelper.FixedAnchorEx((IFigure)this, position);
                }
                return super.getConnectionAnchor(terminal);
            }
        };
        result.setMinimumSize(new Dimension(this.getMapMode().DPtoLP(16), this.getMapMode().DPtoLP(20)));
        return result;
    }

    @Override
    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new DelegatingLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape, (Object)new AbstractExecutionSpecificationEditPart.FillParentLocator());
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    private BorderedNodeFigure getBorderedFigure() {
        EditPart parent = this.getParent();
        while (parent != null && !(parent instanceof CustomInteractionEditPart)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return ((CustomInteractionEditPart)parent).getBorderedFigure();
        }
        return null;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof BehaviorExecutionSpecificationBehaviorEditPart) {
            IFigure childFigure = ((BehaviorExecutionSpecificationBehaviorEditPart)childEditPart).getFigure();
            BorderedNodeFigure borderedFigure = this.getBorderedFigure();
            IFigure figure = this.getFigure();
            BehaviorLabelLocator locator = new BehaviorLabelLocator(figure);
            if (borderedFigure != null) {
                borderedFigure.getBorderItemContainer().add(childFigure, (Object)locator);
            }
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof BehaviorExecutionSpecificationBehaviorEditPart) {
            IFigure childFigure = ((BehaviorExecutionSpecificationBehaviorEditPart)childEditPart).getFigure();
            BorderedNodeFigure borderedFigure = this.getBorderedFigure();
            if (borderedFigure != null) {
                borderedFigure.getBorderItemContainer().remove(childFigure);
            }
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    @Override
    protected void setLineWidth(int width) {
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshBehavior();
    }

    protected void refreshBounds() {
        super.refreshBounds();
        this.refreshBehavior();
    }

    protected void refreshBehavior() {
        if (!BehaviorDisplayHelper.shouldDisplayBehavior(this.getNotationView())) {
            return;
        }
        List children = this.getChildren();
        for (Object child : children) {
            if (!(child instanceof BehaviorExecutionSpecificationBehaviorEditPart)) continue;
            ((BehaviorExecutionSpecificationBehaviorEditPart)((Object)child)).refresh();
        }
    }

    public void activate() {
        Behavior behavior;
        super.activate();
        EObject elt = this.resolveSemanticElement();
        if (elt instanceof BehaviorExecutionSpecification && (behavior = ((BehaviorExecutionSpecification)elt).getBehavior()) != null) {
            this.helper.listenObject((Notifier)behavior);
        }
        this.addSelfRemovingListener(this.getParent());
    }

    private void addSelfRemovingListener(EditPart editPart) {
        if (editPart == null || editPart instanceof RootEditPart) {
            return;
        }
        if (this.selfRemovingListener == null) {
            this.selfRemovingListener = new EditPartListener.Stub(){

                public void removingChild(EditPart child, int index) {
                    boolean removeBehavior = false;
                    CustomBehaviorExecutionSpecificationEditPart editPart = CustomBehaviorExecutionSpecificationEditPart.this;
                    while (editPart != null && !(editPart instanceof RootEditPart)) {
                        if (editPart == child) {
                            removeBehavior = true;
                            break;
                        }
                        editPart = editPart.getParent();
                    }
                    if (removeBehavior) {
                        ArrayList children = new ArrayList(CustomBehaviorExecutionSpecificationEditPart.this.getChildren());
                        for (Object object : children) {
                            if (!(object instanceof BehaviorExecutionSpecificationBehaviorEditPart)) continue;
                            CustomBehaviorExecutionSpecificationEditPart.this.removeChild((EditPart)object);
                            break;
                        }
                    }
                }
            };
        }
        if (editPart != null) {
            editPart.removeEditPartListener(this.selfRemovingListener);
            editPart.addEditPartListener(this.selfRemovingListener);
            this.addSelfRemovingListener(editPart.getParent());
        }
    }

    private void removeSelfRemovingListener(EditPart editPart) {
        if (editPart == null || editPart instanceof RootEditPart || this.selfRemovingListener == null) {
            return;
        }
        if (editPart != null) {
            editPart.removeEditPartListener(this.selfRemovingListener);
            this.removeSelfRemovingListener(editPart.getParent());
        }
    }

    public void deactivate() {
        this.helper.unlistenAll();
        this.removeSelfRemovingListener(this.getParent());
        super.deactivate();
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        EObject elt;
        super.handleNotificationEvent(event);
        Object feature = event.getFeature();
        Object notifier = event.getNotifier();
        if (UMLPackage.eINSTANCE.getBehaviorExecutionSpecification_Behavior() == feature) {
            this.helper.unlistenObject((Notifier)event.getOldValue());
            this.helper.listenObject((Notifier)event.getNewValue());
            this.refreshBehavior();
        } else if (notifier != null && (elt = this.resolveSemanticElement()) instanceof BehaviorExecutionSpecification && notifier == ((BehaviorExecutionSpecification)elt).getBehavior()) {
            this.refreshBehavior();
        }
        if (BehaviorDisplayHelper.isDisplayBehaviorChanged(event)) {
            this.refreshChildren();
        }
    }

    protected List getModelChildren() {
        ArrayList<DecorationNode> modelChildren = new ArrayList<DecorationNode>(super.getModelChildren());
        boolean displayBehavior = BehaviorDisplayHelper.shouldDisplayBehavior(this.getNotationView());
        boolean hasBehaviorLabel = false;
        final View view = this.getNotationView();
        for (Object object : view.getChildren()) {
            if (!(object instanceof View) || !"BehaviorExecutionSpecification_Behavior".equals(((View)object).getType())) continue;
            hasBehaviorLabel = true;
            if (displayBehavior) break;
            modelChildren.remove(object);
            break;
        }
        if (!hasBehaviorLabel && displayBehavior) {
            final DecorationNode behaviorLabel = NotationFactory.eINSTANCE.createDecorationNode();
            Location location = NotationFactory.eINSTANCE.createLocation();
            location.setX(16);
            location.setY(16);
            behaviorLabel.setLayoutConstraint((LayoutConstraint)location);
            behaviorLabel.setType("BehaviorExecutionSpecification_Behavior");
            CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)new ExecutionSpecificationEndEditPart.DummyCommand(){

                @Override
                public void execute() {
                    ViewUtil.insertChildView((View)view, (View)behaviorLabel, (int)-1, (boolean)true);
                }
            }, true);
            modelChildren.add(behaviorLabel);
        }
        return modelChildren;
    }

    private static class BehaviorLabelLocator
    implements IBorderItemLocator {
        private IFigure referenceFigure;
        private Rectangle constraint = new Rectangle();

        public BehaviorLabelLocator(IFigure referenceFigure) {
            this.referenceFigure = referenceFigure;
        }

        public void setConstraint(Rectangle constraint) {
            this.constraint = constraint;
        }

        public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
            return new Rectangle(proposedLocation);
        }

        public int getCurrentSideOfParent() {
            return 0;
        }

        public void relocate(IFigure target) {
            Rectangle ref = this.referenceFigure.getBounds().getCopy();
            this.referenceFigure.translateToAbsolute((Translatable)ref);
            Rectangle bounds = this.constraint.getTranslated(ref.getLocation());
            bounds.setSize(target.getPreferredSize());
            target.translateToRelative((Translatable)bounds);
            target.setBounds(bounds);
        }
    }
}

