/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.IPapyrusWrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CenteredWrappedLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomStateInvariantLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ExecutionSpecificationEndEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.StateInvariantEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AppliedStereotypeCommentCreationEditPolicyEx;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomStateInvariantItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.locator.CenterLocator;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.NotificationHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomStateInvariantEditPart
extends StateInvariantEditPart
implements IPapyrusEditPart {
    public static final int DEFAULT_MARGIN = 0;
    public static final String TOP_MARGIN_PROPERTY = "TopMarginLabel";
    public static final String LEFT_MARGIN_PROPERTY = "LeftMarginLabel";
    public static final String BOTTOM_MARGIN_PROPERTY = "BottomMarginLabel";
    public static final String RIGHT_MARGIN_PROPERTY = "RightMarginLabel";
    private NotificationHelper notifierHelper = new NotificationHelper(new UIAdapterImpl(){

        protected void safeNotifyChanged(Notification msg) {
            CustomStateInvariantEditPart.this.handleNotificationEvent(msg);
        }
    });

    public CustomStateInvariantEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        EObject element = this.resolveSemanticElement();
        if (element instanceof StateInvariant && ((StateInvariant)element).getInvariant() != null) {
            this.notifierHelper.listenObject((Notifier)((StateInvariant)element).getInvariant());
        }
    }

    public void deactivate() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof StateInvariant && ((StateInvariant)element).getInvariant() != null) {
            this.notifierHelper.unlistenObject((Notifier)((StateInvariant)element).getInvariant());
        }
        super.deactivate();
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomStateInvariantItemSemanticEditPolicy());
        this.installEditPolicy("AppliedStereotypeComment", (EditPolicy)new AppliedStereotypeCommentCreationEditPolicyEx());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
    }

    protected void handleNotificationEvent(Notification notification) {
        EObject element;
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        Object notifier = notification.getNotifier();
        if (this.getModel() != null && this.getModel() == notifier) {
            if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
                this.refreshLineWidth();
            }
        } else if (UMLPackage.eINSTANCE.getStateInvariant_Invariant() == feature) {
            if (1 == notification.getEventType() || 2 == notification.getEventType()) {
                this.notifierHelper.unlistenObject((Notifier)notification.getOldValue());
                this.notifierHelper.listenObject((Notifier)notification.getNewValue());
            }
            this.refreshLabels();
        } else if (notifier != null && (element = this.resolveSemanticElement()) instanceof StateInvariant && notifier == ((StateInvariant)element).getInvariant()) {
            this.refreshLabels();
        }
    }

    protected List getModelChildren() {
        ArrayList<DecorationNode> modelChildren = new ArrayList<DecorationNode>(super.getModelChildren());
        boolean hasInvariantView = false;
        for (Object e : modelChildren) {
            if (!(e instanceof View) || !UMLVisualIDRegistry.getType(5023).equals(((View)e).getType())) continue;
            hasInvariantView = true;
            break;
        }
        if (!hasInvariantView) {
            final View view = this.getNotationView();
            final DecorationNode guardNode = NotationFactory.eINSTANCE.createDecorationNode();
            guardNode.setType(UMLVisualIDRegistry.getType(5023));
            CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)new ExecutionSpecificationEndEditPart.DummyCommand(){

                @Override
                public void execute() {
                    ViewUtil.insertChildView((View)view, (View)guardNode, (int)-1, (boolean)true);
                }
            }, true);
            modelChildren.add(guardNode);
        }
        return modelChildren;
    }

    protected void setFontColor(Color color) {
        super.setFontColor(color);
        StateInvariantFigure primaryShape = this.getPrimaryShape();
        if (primaryShape != null && primaryShape.getConstraintContentContainer() != null) {
            primaryShape.getConstraintContentContainer().setForegroundColor(color);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineWidth();
        this.refreshTransparency();
        this.refreshLabels();
        this.refreshLabelMargin();
    }

    private void refreshLabelMargin() {
        IFigure figure = null;
        int leftMargin = 0;
        int rightMargin = 0;
        int topMargin = 0;
        int bottomMargin = 0;
        Object model = this.getModel();
        if (model instanceof View) {
            leftMargin = NotationUtils.getIntValue((View)((View)model), (String)LEFT_MARGIN_PROPERTY, (int)0);
            rightMargin = NotationUtils.getIntValue((View)((View)model), (String)RIGHT_MARGIN_PROPERTY, (int)0);
            topMargin = NotationUtils.getIntValue((View)((View)model), (String)TOP_MARGIN_PROPERTY, (int)0);
            bottomMargin = NotationUtils.getIntValue((View)((View)model), (String)BOTTOM_MARGIN_PROPERTY, (int)0);
        }
        if (this instanceof IPapyrusEditPart) {
            figure = this.getPrimaryShape();
            List labelChildFigureList = FigureUtils.findChildFigureInstances((IFigure)figure, IPapyrusWrappingLabel.class);
            for (IPapyrusWrappingLabel label : labelChildFigureList) {
                if (label == null) continue;
                label.setMarginLabel(leftMargin, topMargin, rightMargin, bottomMargin);
            }
        }
    }

    protected void refreshLabels() {
        List parts = this.getChildren();
        for (Object p : parts) {
            if (!(p instanceof CustomStateInvariantLabelEditPart)) continue;
            ((CustomStateInvariantLabelEditPart)((Object)p)).refreshLabel();
        }
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void refreshBounds() {
        if (this.getBorderItemLocator() != null) {
            int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            Point loc = new Point(x, y);
            int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            Dimension size = new Dimension(width, height);
            this.getFigure().setBounds(new Rectangle(loc, size));
            this.getBorderItemLocator().setConstraint(new Rectangle(loc, size));
        } else {
            super.refreshBounds();
        }
    }

    @Override
    public StateInvariantFigure getPrimaryShape() {
        return (StateInvariantFigure)this.primaryShape;
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof CustomStateInvariantLabelEditPart) {
            ((CustomStateInvariantLabelEditPart)childEditPart).setLabel(this.getPrimaryShape().getInvariantFigure());
            return true;
        }
        return super.addFixedChild(childEditPart);
    }

    @Override
    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof CustomStateInvariantLabelEditPart) {
            return true;
        }
        return super.removeFixedChild(childEditPart);
    }

    @Override
    protected IFigure createNodeShape() {
        this.primaryShape = new StateInvariantFigure();
        return this.primaryShape;
    }

    public class StateInvariantFigure
    extends StateInvariantEditPart.ContinuationFigure
    implements ILabelFigure,
    IMultilineEditableFigure,
    IPapyrusNodeUMLElementFigure {
        protected static final String LEFT_BRACE = "{";
        protected static final String RIGHT_BRACE = "}";
        private int transparency;
        private FlowPage constraintContentContainer;
        private TextFlowEx constraintContent;
        private CenteredWrappedLabel fFigureContinuationNameLabel;
        private PapyrusWrappingLabel stereotypesLabel;
        private Label stereotypePropertiesLabel;
        private IFigure labelContainer;

        public StateInvariantFigure() {
            super(CustomStateInvariantEditPart.this);
            this.transparency = 0;
            this.getChildren().clear();
            this.setBorder((Border)new MarginBorder(8));
            RoundedRectangle contents = new RoundedRectangle();
            contents.setCornerDimensions(new Dimension(CustomStateInvariantEditPart.this.getMapMode().DPtoLP(50), CustomStateInvariantEditPart.this.getMapMode().DPtoLP(50)));
            contents.setOutline(false);
            this.add((IFigure)contents);
            this.fFigureContinuationNameLabel = new CenteredWrappedLabel();
            contents.add((IFigure)this.fFigureContinuationNameLabel);
            this.constraintContentContainer = new FlowPage();
            this.constraintContentContainer.setOpaque(false);
            this.constraintContentContainer.setHorizontalAligment(2);
            this.constraintContent = new TextFlowEx("");
            this.constraintContentContainer.add((IFigure)this.constraintContent);
            contents.add((IFigure)this.constraintContentContainer);
            ToolbarLayout layout = new ToolbarLayout(false);
            layout.setStretchMinorAxis(true);
            layout.setMinorAlignment(0);
            contents.setLayoutManager((LayoutManager)layout);
            this.labelContainer = contents;
        }

        public FlowPage getConstraintContentContainer() {
            return this.constraintContentContainer;
        }

        @Override
        public CenteredWrappedLabel getFigureContinuationNameLabel() {
            return this.fFigureContinuationNameLabel;
        }

        @Override
        public IFigure getInvariantFigure() {
            return this;
        }

        protected void fillShape(Graphics graphics) {
            graphics.pushState();
            this.applyTransparency(graphics);
            graphics.fillRoundRectangle(this.getBounds(), this.corner.width, this.corner.height);
            graphics.popState();
        }

        public int getTransparency() {
            return this.transparency;
        }

        public void setTransparency(int transparency) {
            if (transparency != this.transparency && transparency >= 0 && transparency <= 100) {
                this.transparency = transparency;
                this.repaint();
            }
        }

        protected void applyTransparency(Graphics g) {
            g.setAlpha(255 - this.transparency * 255 / 100);
        }

        public void setText(String text) {
            if (this.constraintContent != null) {
                this.constraintContent.setText(LEFT_BRACE + text + RIGHT_BRACE);
            }
        }

        public String getText() {
            if (this.constraintContent != null) {
                return this.constraintContent.getText();
            }
            return null;
        }

        public void setIcon(Image icon) {
        }

        public Image getIcon() {
            return null;
        }

        public Point getEditionLocation() {
            if (this.constraintContentContainer != null) {
                return this.constraintContentContainer.getLocation();
            }
            return null;
        }

        public void setStereotypeDisplay(String stereotypes, Image image) {
            if (stereotypes == null || stereotypes.trim().equals("")) {
                if (this.stereotypesLabel != null) {
                    this.labelContainer.remove((IFigure)this.stereotypesLabel);
                }
                this.stereotypesLabel = null;
            } else if (this.stereotypesLabel == null) {
                this.stereotypesLabel = new PapyrusWrappingLabel(stereotypes, image);
                this.labelContainer.add((IFigure)this.stereotypesLabel, 0);
            } else {
                this.stereotypesLabel.setText(stereotypes);
                this.stereotypesLabel.setIcon(image);
            }
        }

        public void setStereotypePropertiesInBrace(String stereotypeProperties) {
            if (stereotypeProperties == null || stereotypeProperties.trim().equals("")) {
                if (this.stereotypePropertiesLabel != null) {
                    this.labelContainer.remove((IFigure)this.stereotypePropertiesLabel);
                }
                this.stereotypePropertiesLabel = null;
            } else {
                if (this.stereotypePropertiesLabel == null) {
                    this.stereotypePropertiesLabel = new Label();
                    int index = this.labelContainer.getChildren().indexOf(this.stereotypesLabel);
                    this.labelContainer.add((IFigure)this.stereotypePropertiesLabel, index + 1);
                }
                this.stereotypePropertiesLabel.setText(LEFT_BRACE + stereotypeProperties + RIGHT_BRACE);
            }
        }

        public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
        }

        public PapyrusWrappingLabel getStereotypesLabel() {
            return this.stereotypesLabel;
        }
    }

    static class StateInvariantLocator
    extends CenterLocator {
        public StateInvariantLocator(IFigure parentFigure, int location) {
            super(parentFigure, location);
        }

        @Override
        public void relocate(IFigure borderItem) {
            Point constraintLocation = this.getConstraint().getLocation();
            Dimension size = this.getSize(borderItem);
            Point ptNewLocation = new Point(this.getParentBorder().getCenter().x - size.width / 2, constraintLocation.y);
            borderItem.setBounds(new Rectangle(ptNewLocation, size));
        }

        @Override
        public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
            Rectangle realLocation = new Rectangle(proposedLocation);
            Point point = new Point(this.getParentBorder().getCenter().x - realLocation.getSize().width / 2, realLocation.y);
            realLocation.setLocation(point);
            return realLocation;
        }
    }

    public static class StateInvariantResizableEditPolicy
    extends BorderItemResizableEditPolicy {
        protected org.eclipse.gef.commands.Command getResizeCommand(ChangeBoundsRequest request) {
            IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
            IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
            if (borderItemLocator != null) {
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                this.getHostFigure().translateToRelative((Translatable)rect);
                Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
                if (borderItemEP.getParent() instanceof LifelineEditPart && !this.restrictInParentBounds((LifelineEditPart)borderItemEP.getParent(), borderItemEP, realLocation.getCopy())) {
                    return null;
                }
                SetBoundsCommand moveCommand = new SetBoundsCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), realLocation);
                return new ICommandProxy((ICommand)moveCommand);
            }
            return null;
        }

        protected org.eclipse.gef.commands.Command getMoveCommand(ChangeBoundsRequest request) {
            IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
            IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
            if (borderItemLocator != null) {
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                this.getHostFigure().translateToRelative((Translatable)rect);
                Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
                if (borderItemEP.getParent() instanceof LifelineEditPart && !this.restrictInParentBounds((LifelineEditPart)borderItemEP.getParent(), borderItemEP, realLocation.getCopy())) {
                    return null;
                }
                Point location = realLocation.getTopLeft();
                SetBoundsCommand moveCommand = new SetBoundsCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), location);
                return new ICommandProxy((ICommand)moveCommand);
            }
            return null;
        }

        private boolean restrictInParentBounds(LifelineEditPart ep, IBorderItemEditPart borderItemEP, Rectangle realLocation) {
            borderItemEP.getFigure().translateToAbsolute((Translatable)realLocation);
            Rectangle bounds = ep.getPrimaryShape().getBounds().getCopy();
            ep.getPrimaryShape().translateToAbsolute((Translatable)bounds);
            int nameHeight = ep.getPrimaryShape().getFigureLifelineNameContainerFigure().getBounds().height;
            if (realLocation.y - nameHeight < bounds.y) {
                return false;
            }
            return realLocation.getBottom().y <= bounds.getBottom().y;
        }
    }
}

