/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.AddCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.commands.wrappers.CommandProxyWithResult;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.commands.DeferredCreateCommand;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationObservationHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateGateViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateLocatedConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.RestoreDurationConstraintLinkCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomCombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.CombinedFragmentMoveHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeObservation;

public class CustomDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public static final String LIFELINE_MISSING = "There is no representation of lifeline {0}";
    public static final String DIALOG_TITLE = "Element missing";

    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)SequenceLinkMappingHelper.getInstance());
    }

    protected Set<Integer> getDroppableElementVisualId() {
        HashSet<Integer> elementsVisualId = new HashSet<Integer>();
        elementsVisualId.add(3001);
        elementsVisualId.add(3006);
        elementsVisualId.add(3003);
        elementsVisualId.add(3002);
        elementsVisualId.add(2001);
        elementsVisualId.add(3005);
        elementsVisualId.add(3004);
        elementsVisualId.add(3018);
        elementsVisualId.add(4010);
        elementsVisualId.add(3007);
        elementsVisualId.add(3016);
        elementsVisualId.add(3017);
        elementsVisualId.add(3009);
        elementsVisualId.add(5006);
        elementsVisualId.add(3008);
        elementsVisualId.add(5012);
        elementsVisualId.add(4011);
        elementsVisualId.add(3024);
        elementsVisualId.add(3019);
        elementsVisualId.add(3020);
        elementsVisualId.add(3021);
        elementsVisualId.add(1000);
        elementsVisualId.add(4003);
        elementsVisualId.add(4004);
        elementsVisualId.add(4005);
        elementsVisualId.add(4006);
        elementsVisualId.add(4006);
        elementsVisualId.add(4007);
        elementsVisualId.add(4008);
        elementsVisualId.add(4009);
        elementsVisualId.add(4008);
        elementsVisualId.add(4012);
        elementsVisualId.add(3022);
        elementsVisualId.add(3017);
        elementsVisualId.add(3019);
        elementsVisualId.add(3021);
        elementsVisualId.add(3023);
        elementsVisualId.add(3020);
        elementsVisualId.add(3024);
        elementsVisualId.add(3001);
        elementsVisualId.add(-1);
        return elementsVisualId;
    }

    public Command getCommand(Request request) {
        Command command = super.getCommand(request);
        if (!(request instanceof ChangeBoundsRequest)) {
            return command;
        }
        boolean someCombinedFragment = false;
        boolean someNonCombinedFragment = false;
        List editParts = ((ChangeBoundsRequest)request).getEditParts();
        if (editParts != null) {
            for (Object part : editParts) {
                someCombinedFragment |= part instanceof CustomCombinedFragmentEditPart;
                someNonCombinedFragment |= !(part instanceof CustomCombinedFragmentEditPart);
            }
        }
        if (someCombinedFragment && someNonCombinedFragment) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        if (someNonCombinedFragment) {
            return command;
        }
        return this.getMoveCombinedFragmentCommand((ChangeBoundsRequest)request);
    }

    protected Command getMoveCombinedFragmentCommand(ChangeBoundsRequest request) {
        CompoundCommand cc = new CompoundCommand("move CombinedFragments to new parent");
        Rectangle rectangleDroppedCombined = CombinedFragmentMoveHelper.calcCombinedRect(request);
        org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart newParentEP = CombinedFragmentMoveHelper.findNewParentEP(request, this.getHost());
        List editParts = request.getEditParts();
        if (editParts != null) {
            for (Object part : editParts) {
                CustomCombinedFragmentEditPart combinedFragmentEP = (CustomCombinedFragmentEditPart)((Object)part);
                CombinedFragment combinedFragment = (CombinedFragment)ViewUtil.resolveSemanticElement((View)((View)combinedFragmentEP.getModel()));
                if (combinedFragmentEP.getParent() == newParentEP) continue;
                View containerNewParent = (View)newParentEP.getModel();
                EObject contextNewParent = ViewUtil.resolveSemanticElement((View)containerNewParent);
                TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                Command moveSemanticCmd = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new MoveRequest(editingDomain, contextNewParent, (EObject)combinedFragment)));
                if (moveSemanticCmd == null) {
                    return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
                }
                cc.add(moveSemanticCmd);
                View container = (View)newParentEP.getModel();
                View view = (View)combinedFragmentEP.getModel();
                cc.add((Command)new ICommandProxy((ICommand)new AddCommand(combinedFragmentEP.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)container), (IAdaptable)new EObjectAdapter((EObject)view))));
            }
        }
        Rectangle newParentOldRect = newParentEP.getFigure().getBounds().getCopy();
        newParentEP.getFigure().translateToAbsolute((Translatable)newParentOldRect);
        Rectangle newParentNewRect = new Rectangle(newParentOldRect.getUnion(rectangleDroppedCombined));
        if (this.getHost().getParent() instanceof CustomCombinedFragmentEditPart) {
            CombinedFragmentMoveHelper.adjustNewParentOperands(cc, newParentNewRect, newParentOldRect, this.getHost());
        }
        Point newParentOffsetSW = new Point(newParentNewRect.x - newParentOldRect.x, newParentNewRect.y - newParentOldRect.y);
        if (newParentEP.getParent().getParent() != null) {
            ChangeBoundsRequest moveParentRequest = new ChangeBoundsRequest();
            moveParentRequest.setType((Object)"move");
            moveParentRequest.setMoveDelta(newParentOffsetSW);
            moveParentRequest.setEditParts(newParentEP.getParent().getParent());
            moveParentRequest.setSizeDelta(new Dimension(newParentNewRect.width - newParentOldRect.width, newParentNewRect.height - newParentOldRect.height));
            moveParentRequest.setResizeDirection(12);
            cc.add(newParentEP.getParent().getParent().getCommand((Request)moveParentRequest));
        }
        if (editParts != null) {
            for (Object part : request.getEditParts()) {
                CustomCombinedFragmentEditPart combinedFragmentEP = (CustomCombinedFragmentEditPart)((Object)part);
                CombinedFragmentMoveHelper.moveCombinedFragmentEP(cc, request, combinedFragmentEP, newParentEP, newParentOffsetSW);
            }
        }
        return cc;
    }

    protected IUndoableOperation getDropObjectCommand(DropObjectsRequest dropRequest, EObject droppedObject) {
        IUndoableOperation dropObjectCommand = super.getDropObjectCommand(dropRequest, droppedObject);
        if (dropObjectCommand != null && dropObjectCommand.canExecute()) {
            return dropObjectCommand;
        }
        if (droppedObject instanceof ConnectableElement) {
            return this.doDropConnectableElement(dropRequest, (ConnectableElement)droppedObject);
        }
        return dropObjectCommand;
    }

    private IUndoableOperation doDropConnectableElement(DropObjectsRequest dropRequest, ConnectableElement droppedObject) {
        Point location = dropRequest.getLocation();
        CreateViewRequest createShapeRequest = CreateViewRequestFactory.getCreateShapeRequest((IElementType)UMLElementTypes.Lifeline_3001, (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        createShapeRequest.setLocation(location);
        CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)createShapeRequest.getViewDescriptors().get(0);
        CreateElementRequestAdapter elementAdapter = (CreateElementRequestAdapter)viewDescriptor.getElementAdapter();
        CreateElementRequest createElementRequest = (CreateElementRequest)elementAdapter.getAdapter(CreateElementRequest.class);
        createElementRequest.setParameter("Connectable Element", (Object)droppedObject);
        EditPart host = this.getHost();
        Command theRealCmd = ((IGraphicalEditPart)host).getCommand((Request)createShapeRequest);
        if (theRealCmd != null && theRealCmd.canExecute()) {
            return new CommandProxy(theRealCmd);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public IElementType getUMLElementType(int elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        Point location = dropRequest.getLocation().getCopy();
        if (semanticElement instanceof Gate) {
            return this.dropGate((Gate)semanticElement, location);
        }
        Command cmd = this.handleNodeOnMessage(semanticElement, nodeVISUALID, linkVISUALID, location);
        if (cmd != null) {
            return cmd;
        }
        if (nodeVISUALID != -1) {
            switch (nodeVISUALID) {
                case 3003: 
                case 3006: {
                    return this.dropExecutionSpecification((ExecutionSpecification)semanticElement, nodeVISUALID, location);
                }
                case 3022: {
                    return this.dropDestructionOccurrence((DestructionOccurrenceSpecification)semanticElement, nodeVISUALID, location);
                }
                case 3017: {
                    return this.dropStateInvariant((StateInvariant)semanticElement, nodeVISUALID, location);
                }
                case 3019: 
                case 3021: {
                    return this.dropIntervalConstraintInLifeline((IntervalConstraint)semanticElement, nodeVISUALID);
                }
                case 3020: {
                    return this.dropTimeObservationInLifeline((TimeObservation)semanticElement, nodeVISUALID, location);
                }
                case 3018: {
                    return this.dropCoRegion((CombinedFragment)semanticElement, nodeVISUALID, location);
                }
                case 3008: 
                case 3009: {
                    if (semanticElement instanceof DurationConstraint) {
                        return this.dropDurationConstraint((DurationConstraint)semanticElement, location);
                    }
                }
                case 3001: 
                case 3002: 
                case 5012: {
                    return this.dropNodeElement(semanticElement, nodeVISUALID, location);
                }
                case 3004: 
                case 3007: {
                    return this.dropCombinedFragment((CombinedFragment)semanticElement, nodeVISUALID, location);
                }
                case 3005: 
                case 3016: {
                    return this.dropCompartmentNodeElement(semanticElement, nodeVISUALID, location);
                }
            }
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        if (linkVISUALID != -1) {
            switch (linkVISUALID) {
                case 4003: 
                case 4004: 
                case 4005: 
                case 4006: 
                case 4007: 
                case 4008: 
                case 4009: {
                    return this.dropMessage(dropRequest, semanticElement, linkVISUALID);
                }
                case 4012: {
                    return this.dropGeneralOrdering(dropRequest, semanticElement, linkVISUALID);
                }
            }
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropNodeElement(Element element, int nodeVISUALID, Point location) {
        List existingViews;
        Element parent = element.getOwner();
        if (this.getHostObject().equals(parent) && !(existingViews = DiagramEditPartsUtil.findViews((EObject)parent, (EditPartViewer)this.getViewer())).isEmpty()) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(this.getHost(), nodeVISUALID, location, (EObject)element));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropCombinedFragment(CombinedFragment combinedFragment, int nodeVISUALID, Point location) {
        EditPart parentEditPart;
        List existingViews;
        Element parent = combinedFragment.getOwner();
        Element parentContainer = parent.getOwner();
        if (!(parentContainer instanceof CombinedFragment)) {
            parentContainer = parent;
        }
        if (this.getHostObject().equals(parentContainer) && !(existingViews = DiagramEditPartsUtil.findViews((EObject)parent, (EditPartViewer)this.getViewer())).isEmpty() && (parentEditPart = this.lookForEditPart((EObject)parent)) instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart) {
            Rectangle bounds = null;
            for (Lifeline lifeline : combinedFragment.getCovereds()) {
                EditPart lifelineEditPart = this.lookForEditPart((EObject)lifeline);
                if (lifelineEditPart == null) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageDialog.openError((Shell)shell, (String)DIALOG_TITLE, (String)NLS.bind((String)LIFELINE_MISSING, (Object)lifeline.getName()));
                    return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
                }
                if (!(lifelineEditPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)) continue;
                org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart graphicalEditPart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)lifelineEditPart;
                Rectangle rectangle = graphicalEditPart.getFigure().getBounds().getCopy();
                graphicalEditPart.getFigure().translateToAbsolute((Translatable)rectangle);
                bounds = bounds == null ? rectangle : bounds.union(rectangle);
            }
            if (bounds == null) {
                return new ICommandProxy(this.getDefaultDropNodeCommand(parentEditPart, nodeVISUALID, location, (EObject)combinedFragment));
            }
            location.x = bounds.x;
            return new ICommandProxy(this.dropCombinedFragment(this.getHost(), nodeVISUALID, location, new Dimension(bounds.width, 100), (EObject)combinedFragment));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected ICommand dropCombinedFragment(EditPart hostEP, int nodeVISUALID, Point absoluteLocation, Dimension size, EObject droppedObject) {
        List existingViews;
        IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
        String semanticHint = null;
        if (type != null) {
            semanticHint = type.getSemanticHint();
        }
        if ((existingViews = DiagramEditPartsUtil.findViews((EObject)droppedObject, (EditPartViewer)this.getViewer())).isEmpty()) {
            EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, true, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            createViewRequest.setLocation(absoluteLocation);
            createViewRequest.setSize(size);
            Command command = hostEP.getCommand((Request)createViewRequest);
            if (createViewRequest.getNewObject() instanceof List) {
                for (Object object : (List)createViewRequest.getNewObject()) {
                    if (!(object instanceof IAdaptable)) continue;
                    DeferredCreateCommand createCommand2 = new DeferredCreateCommand(this.getEditingDomain(), droppedObject, (IAdaptable)object, this.getHost().getViewer());
                    command.chain((Command)new ICommandProxy((ICommand)createCommand2));
                }
            }
            return new CommandProxyWithResult(command, (Object)descriptor);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropCompartmentNodeElement(Element element, int nodeVISUALID, Point location) {
        EditPart parentEditPart;
        List existingViews;
        Element parent;
        Element directParent = parent = element.getOwner();
        if (parent instanceof InteractionOperand) {
            parent = parent.getOwner();
        }
        if (this.getHostObject().equals(parent) && !(existingViews = DiagramEditPartsUtil.findViews((EObject)directParent, (EditPartViewer)this.getViewer())).isEmpty() && (parentEditPart = this.lookForEditPart((EObject)directParent)) != null) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(parentEditPart, nodeVISUALID, location, (EObject)element));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command handleNodeOnMessage(Element semanticElement, int nodeVISUALID, int linkVISUALID, Point location) {
        EList events;
        if (nodeVISUALID == -1 && linkVISUALID == -1 && semanticElement instanceof DurationObservation && (events = ((DurationObservation)semanticElement).getEvents()).size() >= 2) {
            return this.dropMessageNodeBetweenEvents(semanticElement, (Element)events.get(0), (Element)events.get(1));
        }
        if (this.isDurationConstraintHint(nodeVISUALID, linkVISUALID) && semanticElement instanceof DurationConstraint) {
            return this.dropDurationConstraint((DurationConstraint)semanticElement, location);
        }
        return null;
    }

    protected Command dropDurationConstraint(DurationConstraint durationConstraint, Point location) {
        EList events = durationConstraint.getConstrainedElements();
        Element event1 = null;
        Element event2 = null;
        if (events.size() >= 2) {
            event1 = (Element)events.get(0);
            event2 = (Element)events.get(1);
        } else if (events.size() == 1) {
            event1 = event2 = (Element)events.get(0);
        }
        return this.dropDurationConstraint((Element)durationConstraint, event1, event2, location);
    }

    private Command dropDurationConstraint(Element durationConstraint, Element event1, Element event2, Point location) {
        List existingViews = DiagramEditPartsUtil.findViews((EObject)durationConstraint, (EditPartViewer)this.getViewer());
        if (!existingViews.isEmpty()) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)durationConstraint);
        IHintedType elementType = (IHintedType)UMLElementTypes.getElementType(3021);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, elementType.getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(location);
        Command command = this.getHost().getCommand((Request)createViewRequest);
        if (command == null || !command.canExecute()) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        CompositeCommand result = new CompositeCommand(command.getLabel());
        result.add((IUndoableOperation)new CommandProxyWithResult(command, (Object)descriptor));
        Point[] constraintLocations = this.getLocationForDurationConstraint((DurationConstraint)durationConstraint, event1, event2, location);
        if (constraintLocations[0] != null && constraintLocations[1] != null) {
            if (constraintLocations[0].y <= constraintLocations[1].y) {
                result.add((IUndoableOperation)new RestoreDurationConstraintLinkCommand(this.getEditingDomain(), (IAdaptable)descriptor, this.getViewer(), true, constraintLocations[0], this.getDiagramPreferencesHint()));
                result.add((IUndoableOperation)new RestoreDurationConstraintLinkCommand(this.getEditingDomain(), (IAdaptable)descriptor, this.getViewer(), false, constraintLocations[1], this.getDiagramPreferencesHint()));
            } else if (constraintLocations[0].y > constraintLocations[1].y) {
                result.add((IUndoableOperation)new RestoreDurationConstraintLinkCommand(this.getEditingDomain(), (IAdaptable)descriptor, this.getViewer(), false, constraintLocations[0], this.getDiagramPreferencesHint()));
                result.add((IUndoableOperation)new RestoreDurationConstraintLinkCommand(this.getEditingDomain(), (IAdaptable)descriptor, this.getViewer(), true, constraintLocations[1], this.getDiagramPreferencesHint()));
            }
        } else if (constraintLocations[0] != null) {
            result.add((IUndoableOperation)new RestoreDurationConstraintLinkCommand(this.getEditingDomain(), (IAdaptable)descriptor, this.getViewer(), null, constraintLocations[0], this.getDiagramPreferencesHint()));
        } else if (constraintLocations[1] != null) {
            result.add((IUndoableOperation)new RestoreDurationConstraintLinkCommand(this.getEditingDomain(), (IAdaptable)descriptor, this.getViewer(), null, constraintLocations[1], this.getDiagramPreferencesHint()));
        }
        return new ICommandProxy((ICommand)result);
    }

    private Point[] getLocationForDurationConstraint(DurationConstraint durationConstraint, Element event1, Element event2, Point location) {
        EditPart editPart;
        Point[] constraintLocations = new Point[2];
        if (event1 instanceof OccurrenceSpecification) {
            constraintLocations[0] = this.getLocationForDurationConstraintOnEvent((OccurrenceSpecification)event1);
        }
        if (event2 instanceof OccurrenceSpecification) {
            constraintLocations[1] = this.getLocationForDurationConstraintOnEvent((OccurrenceSpecification)event2);
        }
        if (constraintLocations[0] == null && event1 != null && (editPart = this.lookForEditPart((EObject)event1)) instanceof INodeEditPart) {
            constraintLocations[0] = this.getLocationForDurationConstraintOnEditPart((INodeEditPart)editPart, location);
        }
        if (constraintLocations[1] == null && event2 != null && (editPart = this.lookForEditPart((EObject)event2)) instanceof INodeEditPart) {
            constraintLocations[1] = this.getLocationForDurationConstraintOnEditPart((INodeEditPart)editPart, location.getTranslated(0, 40));
        }
        if (event1 != null && event1 == event2 && constraintLocations[0] != null && constraintLocations[0].equals((Object)constraintLocations[1]) && (editPart = this.lookForEditPart((EObject)event1)) instanceof IGraphicalEditPart) {
            Rectangle rect = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)editPart);
            if (rect.contains(constraintLocations[0].getTranslated(0, 40))) {
                constraintLocations[1] = constraintLocations[0].getTranslated(0, 40);
            } else if (rect.contains(constraintLocations[0].getTranslated(0, -40))) {
                constraintLocations[1] = constraintLocations[0].getTranslated(0, -40);
            }
        }
        return constraintLocations;
    }

    private Point getLocationForDurationConstraintOnEditPart(INodeEditPart nodeEditPart, Point reference) {
        Rectangle rect = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)nodeEditPart);
        Point location = new Point();
        location.y = reference.y < rect.y ? rect.y + 1 : (reference.y > rect.bottom() ? rect.bottom() - 1 : reference.y);
        int x = rect.x;
        while (x <= rect.right()) {
            CreateConnectionRequest request = new CreateConnectionRequest();
            request.setType((Object)"connection end");
            request.setTargetEditPart((EditPart)nodeEditPart);
            location.x = x++;
            request.setLocation(location);
            ConnectionAnchor targetAnchor = nodeEditPart.getTargetConnectionAnchor((Request)request);
            if (targetAnchor == null) continue;
            location = targetAnchor.getLocation(reference);
            break;
        }
        return location;
    }

    private Point getLocationForDurationConstraintOnEvent(OccurrenceSpecification event) {
        Point targetLocation;
        block8: {
            ExecutionSpecification execution;
            block6: {
                ConnectionNodeEditPart messageEditPart;
                Message message;
                block7: {
                    targetLocation = null;
                    if (!(event instanceof MessageOccurrenceSpecification)) break block6;
                    message = ((MessageOccurrenceSpecification)event).getMessage();
                    if (message == null) {
                        return null;
                    }
                    messageEditPart = null;
                    DiagramEditPart diag = DiagramEditPartsUtil.getDiagramEditPart((EditPart)this.getHost());
                    for (Object conn : diag.getConnections()) {
                        EObject connElt;
                        if (!(conn instanceof ConnectionNodeEditPart) || !message.equals(connElt = ((ConnectionNodeEditPart)conn).resolveSemanticElement())) continue;
                        messageEditPart = (ConnectionNodeEditPart)conn;
                        break;
                    }
                    if (messageEditPart == null) {
                        return null;
                    }
                    if (event != message.getSendEvent()) break block7;
                    targetLocation = SequenceUtil.getAbsoluteEdgeExtremity(messageEditPart, true);
                    break block8;
                }
                if (event != message.getReceiveEvent()) break block8;
                targetLocation = SequenceUtil.getAbsoluteEdgeExtremity(messageEditPart, false);
                break block8;
            }
            if (event instanceof ExecutionOccurrenceSpecification && (execution = ((ExecutionOccurrenceSpecification)event).getExecution()) != null) {
                List existingViews = DiagramEditPartsUtil.findViews((EObject)execution, (EditPartViewer)this.getViewer());
                for (View view : existingViews) {
                    Object object;
                    if (3006 != UMLVisualIDRegistry.getVisualID(view) && 3003 != UMLVisualIDRegistry.getVisualID(view) || !((object = this.getViewer().getEditPartRegistry().get(view)) instanceof IGraphicalEditPart)) continue;
                    Rectangle bounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)object);
                    if (event == execution.getStart()) {
                        targetLocation = bounds.getTop();
                        continue;
                    }
                    if (event != execution.getFinish()) continue;
                    targetLocation = bounds.getBottom();
                }
            }
        }
        return targetLocation;
    }

    private Command dropMessageNodeBetweenEvents(Element droppedElement, Element event1, Element event2) {
        if (event1 instanceof MessageOccurrenceSpecification && event2 instanceof MessageOccurrenceSpecification && !event1.equals(event2)) {
            boolean endsOfSameMessage = false;
            int visualId = -1;
            if (droppedElement instanceof DurationConstraint) {
                visualId = 3023;
                endsOfSameMessage = DurationConstraintHelper.endsOfSameMessage((OccurrenceSpecification)((OccurrenceSpecification)event1), (OccurrenceSpecification)((OccurrenceSpecification)event2));
            } else if (droppedElement instanceof DurationObservation) {
                visualId = 3024;
                endsOfSameMessage = DurationObservationHelper.endsOfSameMessage((OccurrenceSpecification)((OccurrenceSpecification)event1), (OccurrenceSpecification)((OccurrenceSpecification)event2));
            }
            if (endsOfSameMessage) {
                Message message = ((MessageOccurrenceSpecification)event1).getMessage();
                DiagramEditPart diag = DiagramEditPartsUtil.getDiagramEditPart((EditPart)this.getHost());
                for (Object conn : diag.getConnections()) {
                    EObject connElt;
                    if (!(conn instanceof ConnectionNodeEditPart) || !message.equals(connElt = ((ConnectionNodeEditPart)conn).resolveSemanticElement())) continue;
                    for (Object child : ((ConnectionNodeEditPart)conn).getChildren()) {
                        EObject childElt;
                        if (!(child instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart) || !droppedElement.equals(childElt = ((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)child).resolveSemanticElement())) continue;
                        return null;
                    }
                    return this.dropNodeOnMessage((PackageableElement)droppedElement, (ConnectionNodeEditPart)conn, visualId);
                }
            }
        }
        return null;
    }

    private boolean isDurationConstraintHint(int nodeVISUALID, int linkVISUALID) {
        if (linkVISUALID != -1) {
            return false;
        }
        return nodeVISUALID == -1 || nodeVISUALID == 3008 || nodeVISUALID == 3021 || nodeVISUALID == 3023;
    }

    private Command dropNodeOnMessage(PackageableElement durationLabelElement, ConnectionNodeEditPart messageEditPart, int nodeVISUALID) {
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)durationLabelElement);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint());
        return messageEditPart.getCommand((Request)new CreateViewRequest(descriptor));
    }

    private Command dropTimeObservationInLifeline(TimeObservation observation, int nodeVISUALID, Point dropLocation) {
        Point middlePoint;
        NamedElement occ1;
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)observation);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
        cc.add(this.getHost().getCommand((Request)new CreateViewRequest(descriptor)));
        LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost());
        if (lifelinePart != null && (occ1 = observation.getEvent()) instanceof OccurrenceSpecification && (middlePoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ1))) != null) {
            int height = this.getDefaultDropHeight(nodeVISUALID);
            Point startPoint = middlePoint.getCopy();
            if (height > 0) {
                startPoint.translate(0, -height / 2);
            }
            Rectangle newBounds = new Rectangle(startPoint, new Dimension(-1, height));
            lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
            Point parentLoc = lifelinePart.getLocation();
            newBounds.translate(parentLoc.getNegated());
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
            cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            return cc;
        }
        if (this.getHost() instanceof InteractionInteractionCompartmentEditPart) {
            Rectangle newBounds = new Rectangle(dropLocation, new Dimension(-1, -1));
            ((InteractionInteractionCompartmentEditPart)this.getHost()).getFigure().translateToRelative((Translatable)newBounds);
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
            cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            return cc;
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropIntervalConstraintInLifeline(IntervalConstraint constraint, int nodeVISUALID) {
        Point middlePoint;
        Element occ1;
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)constraint);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
        cc.add(this.getHost().getCommand((Request)new CreateViewRequest(descriptor)));
        LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost());
        if (lifelinePart != null && constraint.getConstrainedElements().size() >= 2) {
            Element occ12 = (Element)constraint.getConstrainedElements().get(0);
            Element occ2 = (Element)constraint.getConstrainedElements().get(1);
            if (occ12 instanceof OccurrenceSpecification && occ2 instanceof OccurrenceSpecification) {
                Point startPoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ12));
                Point endPoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ2));
                if (startPoint != null && endPoint != null) {
                    int height = endPoint.y - startPoint.y;
                    Rectangle newBounds = null;
                    newBounds = height < 0 ? new Rectangle(endPoint, new Dimension(-1, -height)) : new Rectangle(startPoint, new Dimension(-1, height));
                    lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
                    Point parentLoc = lifelinePart.getLocation();
                    newBounds.translate(parentLoc.getNegated());
                    SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
                    cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
                    return cc;
                }
            }
        } else if (lifelinePart != null && constraint.getConstrainedElements().size() == 1 && (occ1 = (Element)constraint.getConstrainedElements().get(0)) instanceof OccurrenceSpecification && (middlePoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ1))) != null) {
            int height = this.getDefaultDropHeight(nodeVISUALID);
            Point startPoint = middlePoint.getCopy();
            if (height > 0) {
                startPoint.translate(0, -height / 2);
            }
            Rectangle newBounds = new Rectangle(startPoint, new Dimension(-1, height));
            lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
            Point parentLoc = lifelinePart.getLocation();
            newBounds.translate(parentLoc.getNegated());
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
            cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            return cc;
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private int getDefaultDropHeight(int nodeVISUALID) {
        if (3019 == nodeVISUALID || 3020 == nodeVISUALID) {
            return 2;
        }
        return -1;
    }

    private Command dropStateInvariant(StateInvariant stateInvariant, int nodeVISUALID, Point location) {
        Lifeline lifeline = (Lifeline)stateInvariant.getCovereds().get(0);
        if (lifeline.equals(this.getHostObject())) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)stateInvariant));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private List<Lifeline> getLifelines(List<View> existingViews) {
        ArrayList<Lifeline> lifelines = new ArrayList<Lifeline>();
        for (View view : existingViews) {
            EObject eObject = ViewUtil.resolveSemanticElement((View)((View)view.eContainer()));
            if (!(eObject instanceof Lifeline)) continue;
            lifelines.add((Lifeline)eObject);
        }
        return lifelines;
    }

    private Command dropGate(Gate gate, Point location) {
        return new ICommandProxy(this.getDropGateCommand(gate, location));
    }

    private ICommand getDropGateCommand(Gate gate, Point location) {
        GraphicalEditPart parent;
        EObject owner;
        List existingViews = DiagramEditPartsUtil.findViews((EObject)gate, (EditPartViewer)this.getViewer());
        if (existingViews.isEmpty() && (owner = gate.eContainer()) != null && (parent = (GraphicalEditPart)this.lookForEditPart(owner)) != null) {
            Point gateLocation = GateHelper.computeGateLocation(location, parent.getFigure(), null);
            return new CreateGateViewCommand(this.getEditingDomain(), (IAdaptable)parent, gateLocation, (IAdaptable)new EObjectAdapter((EObject)gate));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropDestructionOccurrence(DestructionOccurrenceSpecification destructionOccurence, int nodeVISUALID, Point location) {
        List existingViews = DiagramEditPartsUtil.findViews((EObject)destructionOccurence, (EditPartViewer)this.getViewer());
        List<Lifeline> lifelines = this.getLifelines(existingViews);
        if (!lifelines.contains(this.getHostObject())) {
            Lifeline lifeline = (Lifeline)this.getHostObject();
            for (InteractionFragment ift : lifeline.getCoveredBys()) {
                DestructionOccurrenceSpecification occurrenceSpecification;
                if (!(ift instanceof DestructionOccurrenceSpecification) || !destructionOccurence.equals(occurrenceSpecification = (DestructionOccurrenceSpecification)ift)) continue;
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)destructionOccurence));
            }
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropExecutionSpecification(ExecutionSpecification es, int nodeVISUALID, Point location) {
        Lifeline lifeline;
        List existingViews = DiagramEditPartsUtil.findViews((EObject)es, (EditPartViewer)this.getViewer());
        if (existingViews.isEmpty() && es.getStart() != null && !es.getStart().getCovereds().isEmpty() && (lifeline = (Lifeline)es.getStart().getCovereds().get(0)).equals(this.getHostObject())) {
            IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
            String semanticHint = null;
            if (type != null) {
                semanticHint = type.getSemanticHint();
            }
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)es);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, true, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            Rectangle bounds = this.getExecutionSpecificationBounds(es);
            if (bounds != null) {
                createViewRequest.setLocation(bounds.getLocation());
                createViewRequest.setSize(bounds.getSize());
            } else {
                createViewRequest.setLocation(location);
            }
            Command command = this.getHost().getCommand((Request)createViewRequest);
            return new ICommandProxy((ICommand)new CommandProxyWithResult(command, (Object)descriptor));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropCoRegion(CombinedFragment combinedFragment, int nodeVISUALID, Point location) {
        IGraphicalEditPart hostEditpart;
        EObject element;
        List existingViews = DiagramEditPartsUtil.findViews((EObject)combinedFragment, (EditPartViewer)this.getViewer());
        if (existingViews.isEmpty() && (element = (hostEditpart = (IGraphicalEditPart)this.getHost()).getNotationView().getElement()) instanceof Lifeline) {
            IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
            String semanticHint = null;
            if (type != null) {
                semanticHint = type.getSemanticHint();
            }
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)combinedFragment);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, true, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            createViewRequest.setLocation(location);
            Command command = this.getHost().getCommand((Request)createViewRequest);
            return new ICommandProxy((ICommand)new CommandProxyWithResult(command, (Object)descriptor));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Rectangle getExecutionSpecificationBounds(ExecutionSpecification es) {
        Point startLocation = null;
        Point finishLocation = null;
        Rectangle possibleStartLocations = null;
        Rectangle possibleFinishLocations = null;
        OccurrenceSpecification startEvent = es.getStart();
        OccurrenceSpecification finishEvent = es.getFinish();
        if (startEvent != null && finishEvent != null && this.getHost() instanceof LifelineEditPart) {
            int bottom;
            int top;
            LifelineEditPart hostLifeline = (LifelineEditPart)this.getHost();
            startLocation = SequenceUtil.findLocationOfEvent((LifelineEditPart)this.getHost(), (InteractionFragment)startEvent);
            if (startLocation == null) {
                possibleStartLocations = SequenceUtil.findPossibleLocationsForEvent(hostLifeline, startEvent);
            }
            if ((finishLocation = SequenceUtil.findLocationOfEvent(hostLifeline, (InteractionFragment)finishEvent)) == null) {
                possibleFinishLocations = SequenceUtil.findPossibleLocationsForEvent(hostLifeline, finishEvent);
                if (possibleFinishLocations.height <= 0) {
                    possibleFinishLocations.height = 50;
                }
            }
            if (startLocation == null) {
                if (finishLocation != null) {
                    top = possibleStartLocations.x;
                    bottom = possibleStartLocations.bottom();
                    if (top > finishLocation.y) {
                        return null;
                    }
                    startLocation = possibleStartLocations.getTop();
                    startLocation.y = (top + Math.min(bottom, finishLocation.y)) / 2;
                } else {
                    int topS = possibleStartLocations.y;
                    int bottomS = possibleStartLocations.bottom();
                    int topF = possibleFinishLocations.y;
                    int bottomF = possibleFinishLocations.bottom();
                    if (topS > bottomF) {
                        return null;
                    }
                    startLocation = possibleStartLocations.getTop();
                    finishLocation = possibleFinishLocations.getBottom();
                    if (bottomS < topF) {
                        startLocation.y = (topS + bottomS) / 2;
                        finishLocation.y = (topF + bottomF) / 2;
                    } else {
                        startLocation.y = (topS + bottomS + topS + topF) / 4;
                        finishLocation.y = (bottomF + topF + bottomF + bottomS) / 4;
                    }
                }
            }
            if (finishLocation == null) {
                top = possibleFinishLocations.y;
                bottom = possibleFinishLocations.bottom();
                if (bottom < startLocation.y) {
                    return null;
                }
                finishLocation = possibleFinishLocations.getBottom();
                finishLocation.y = (bottom + Math.max(top, startLocation.y)) / 2;
            }
            Rectangle result = new Rectangle(startLocation, finishLocation);
            result.width = 16;
            return result;
        }
        return null;
    }

    private Command dropMessage(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        List existingViews = DiagramEditPartsUtil.findViews((EObject)semanticLink, (EditPartViewer)this.getViewer());
        if (!existingViews.isEmpty()) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        Collection<?> sources = SequenceLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = SequenceLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (!sources.isEmpty() && !targets.isEmpty()) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return this.getDropLocatedLinkCommand(dropRequest, source, target, linkVISUALID, semanticLink);
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected Command getDropLocatedLinkCommand(DropObjectsRequest dropRequest, Element source, Element target, int linkVISUALID, Element semanticLink) {
        ICommand createCommand;
        org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart sourceEditPart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.lookForEditPart((EObject)source);
        org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart targetEditPart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.lookForEditPart((EObject)target);
        CompositeCommand cc = new CompositeCommand("Drop");
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getUMLElementType(linkVISUALID), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        if (sourceEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkSourceDropLocation(dropRequest.getLocation(), source, target), (EObject)source);
            cc.add((IUndoableOperation)createCommand);
            sourceAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (targetEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkTargetDropLocation(dropRequest.getLocation(), source, target), (EObject)target);
            cc.add((IUndoableOperation)createCommand);
            targetAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
        }
        CreateLocatedConnectionViewCommand aLinkCommand = new CreateLocatedConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        Point[] sourceAndTarget = this.getLinkSourceAndTargetLocations(semanticLink, sourceEditPart, targetEditPart, dropRequest.getLocation().getCopy());
        aLinkCommand.setLocations(sourceAndTarget[0], sourceAndTarget[1]);
        cc.compose((IUndoableOperation)aLinkCommand);
        return new ICommandProxy((ICommand)cc);
    }

    protected ICommand getDefaultDropNodeCommand(Point absoluteLocation, EObject droppedObject) {
        if (droppedObject instanceof Gate) {
            return this.getDropGateCommand((Gate)droppedObject, absoluteLocation);
        }
        return super.getDefaultDropNodeCommand(absoluteLocation, droppedObject);
    }

    private Point[] getLinkSourceAndTargetLocations(Element semanticLink, org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart sourceEditPart, org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart targetEditPart, Point dropLocation) {
        MessageEnd rcvEvent;
        MessageEnd sendEvent;
        Point[] sourceAndTarget = new Point[2];
        OccurrenceSpecification sourceEvent = null;
        OccurrenceSpecification targetEvent = null;
        if (semanticLink instanceof Message) {
            sendEvent = ((Message)semanticLink).getSendEvent();
            if (sendEvent instanceof OccurrenceSpecification) {
                sourceEvent = (OccurrenceSpecification)sendEvent;
            } else if (sendEvent instanceof Gate) {
                sourceAndTarget[0] = sourceEditPart != null ? SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)sourceEditPart).getCenter() : dropLocation;
            } else if (sendEvent == null) {
                sourceAndTarget[0] = dropLocation;
            }
            rcvEvent = ((Message)semanticLink).getReceiveEvent();
            if (rcvEvent instanceof OccurrenceSpecification) {
                targetEvent = (OccurrenceSpecification)rcvEvent;
            } else if (rcvEvent instanceof Gate) {
                sourceAndTarget[1] = targetEditPart != null ? SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)targetEditPart).getCenter() : dropLocation;
            } else if (rcvEvent == null) {
                sourceAndTarget[1] = dropLocation;
            }
        } else if (semanticLink instanceof GeneralOrdering) {
            sourceEvent = ((GeneralOrdering)semanticLink).getBefore();
            targetEvent = ((GeneralOrdering)semanticLink).getAfter();
        }
        if (sourceEvent != null || targetEvent != null) {
            int bottomTarget;
            int centerTarget;
            Rectangle possibleSourceLocations = null;
            Rectangle possibleTargetLocations = null;
            if (sourceEvent != null && sourceEditPart instanceof LifelineEditPart) {
                sourceAndTarget[0] = SequenceUtil.findLocationOfEvent((LifelineEditPart)sourceEditPart, (InteractionFragment)sourceEvent);
                if (sourceAndTarget[0] == null) {
                    possibleSourceLocations = SequenceUtil.findPossibleLocationsForEvent((LifelineEditPart)sourceEditPart, sourceEvent);
                }
            } else if (sourceEditPart instanceof GateEditPart) {
                possibleSourceLocations = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)sourceEditPart);
            }
            if (targetEvent != null && targetEditPart instanceof LifelineEditPart) {
                sourceAndTarget[1] = SequenceUtil.findLocationOfEvent((LifelineEditPart)targetEditPart, (InteractionFragment)targetEvent);
                if (sourceAndTarget[1] == null) {
                    possibleTargetLocations = SequenceUtil.findPossibleLocationsForEvent((LifelineEditPart)targetEditPart, targetEvent);
                }
            } else if (targetEditPart instanceof GateEditPart) {
                possibleTargetLocations = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)sourceEditPart);
            }
            if (sourceAndTarget[0] == null && possibleSourceLocations != null) {
                if (sourceAndTarget[1] == null && possibleTargetLocations == null) {
                    sourceAndTarget[0] = possibleSourceLocations.getCenter();
                } else if (sourceAndTarget[1] != null) {
                    int topSource = possibleSourceLocations.y;
                    int centerSource = possibleSourceLocations.getCenter().y;
                    if (sourceAndTarget[1].y < topSource) {
                        sourceAndTarget[0] = possibleSourceLocations.getTop();
                    } else if (centerSource <= sourceAndTarget[1].y) {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                    } else {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[0].y = sourceAndTarget[1].y;
                    }
                } else {
                    centerTarget = possibleTargetLocations.getCenter().y;
                    bottomTarget = possibleTargetLocations.bottom();
                    int topSource = possibleSourceLocations.y;
                    int centerSource = possibleSourceLocations.getCenter().y;
                    if (bottomTarget < topSource) {
                        sourceAndTarget[0] = possibleSourceLocations.getTop();
                        sourceAndTarget[1] = possibleTargetLocations.getBottom();
                    } else if (centerSource <= centerTarget) {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[1] = possibleTargetLocations.getCenter();
                    } else {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[0].y = (topSource + bottomTarget) / 2;
                        sourceAndTarget[1] = possibleTargetLocations.getCenter();
                        sourceAndTarget[1].y = (topSource + bottomTarget) / 2;
                    }
                }
            }
            if (sourceAndTarget[1] == null && possibleTargetLocations != null) {
                centerTarget = possibleTargetLocations.getCenter().y;
                bottomTarget = possibleTargetLocations.bottom();
                if (sourceAndTarget[0] == null) {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                } else if (bottomTarget < sourceAndTarget[0].y) {
                    sourceAndTarget[1] = possibleTargetLocations.getBottom();
                } else if (sourceAndTarget[0].y <= centerTarget) {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                } else {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                    sourceAndTarget[1].y = sourceAndTarget[0].y;
                }
            }
        }
        if (semanticLink instanceof Message) {
            sendEvent = ((Message)semanticLink).getSendEvent();
            if (sendEvent == null && sourceAndTarget[1] != null) {
                sourceAndTarget[0] = new Point(dropLocation.x, sourceAndTarget[1].y);
            }
            if ((rcvEvent = ((Message)semanticLink).getReceiveEvent()) == null && sourceAndTarget[0] != null) {
                sourceAndTarget[1] = new Point(dropLocation.x, sourceAndTarget[0].y);
            }
        }
        return sourceAndTarget;
    }

    private Command dropGeneralOrdering(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sources = SequenceLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = SequenceLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (!sources.isEmpty() && !targets.isEmpty()) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return this.getDropLocatedLinkCommand(dropRequest, source, target, linkVISUALID, semanticLink);
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }
}

