/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.sequence.command.CustomContextLinkCreateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ContextLinkEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomInteractionOperandItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;

public class CustomInteractionOperandContextLinkSemanticEditPolicy
extends CustomInteractionOperandItemSemanticEditPolicy {
    @Override
    protected Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (UMLElementTypes.ConstraintContext_8500 == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new CustomContextLinkCreateCommand(req, req.getSource(), req.getTarget()));
        }
        return super.getCompleteCreateRelationshipCommand(req);
    }

    public EditPart getTargetEditPart(Request request) {
        ReconnectRequest reconnectRequest;
        ConnectionEditPart connectionEditPart;
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!UMLElementTypes.ConstraintContext_8500.equals(obj)) continue;
                Point location = ((DropRequest)request).getLocation();
                EditPart host = this.getHost();
                if (!this.isEnterAnchorArea(host, location)) continue;
                return host;
            }
        }
        if (request instanceof ReconnectRequest && (connectionEditPart = (reconnectRequest = (ReconnectRequest)request).getConnectionEditPart()) instanceof ContextLinkEditPart) {
            Point location = ((DropRequest)request).getLocation();
            EditPart host = this.getHost();
            if (this.isEnterAnchorArea(host, location)) {
                return host;
            }
        }
        return super.getTargetEditPart(request);
    }

    private boolean isEnterAnchorArea(EditPart editPart, Point location) {
        Point p = location.getCopy();
        if (editPart instanceof InteractionEditPart || editPart instanceof CombinedFragmentEditPart || editPart instanceof InteractionOperandEditPart) {
            IFigure figure = ((AbstractGraphicalEditPart)editPart).getFigure();
            figure.translateToRelative((Translatable)p);
            Rectangle innerRetangle = figure.getBounds().getCopy().shrink(10, 10);
            if (innerRetangle.contains(p)) {
                return false;
            }
        }
        return true;
    }
}

