/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.uml.extensionpoints.Activator;
import org.eclipse.papyrus.uml.extensionpoints.library.IRegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.standard.ExtensionIds;
import org.eclipse.papyrus.uml.extensionpoints.standard.RegisteredElementExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredLibrary
extends RegisteredElementExtensionPoint
implements IRegisteredLibrary {
    private static final String TAG_LIBRARY = "library";

    public RegisteredLibrary(IConfigurationElement configElt, int ordinal) {
        super(configElt, ordinal);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public static List<IRegisteredLibrary> getRegisteredLibraries() {
        ArrayList<IRegisteredLibrary> libraries = new ArrayList<IRegisteredLibrary>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(ExtensionIds.LIBRARY_EXTENSION_ID);
        int j = 0;
        while (j < configElements.length) {
            IRegisteredLibrary proxy = RegisteredLibrary.parseLibraryExtension(configElements[j], libraries.size());
            if (proxy != null) {
                libraries.add(proxy);
            }
            ++j;
        }
        return libraries;
    }

    private static IRegisteredLibrary parseLibraryExtension(IConfigurationElement configElt, int ordinal) {
        if (!TAG_LIBRARY.equals(configElt.getName())) {
            return null;
        }
        try {
            return new RegisteredLibrary(configElt, ordinal);
        }
        catch (Exception e) {
            String name = configElt.getAttribute("name");
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load library named " + name + " in " + configElt.getDeclaringExtension().getExtensionPointUniqueIdentifier();
            Activator.log(msg);
            return null;
        }
    }
}

