/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.nattable.celleditor.AbstractOpenDialogCellEditorButtonAction;
import org.eclipse.papyrus.infra.nattable.celleditor.config.IAxisCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.uml.nattable.converter.UMLMultiReferenceDisplayConverter;
import org.eclipse.papyrus.uml.nattable.editor.MultiReferenceCellEditor;
import org.eclipse.papyrus.uml.nattable.manager.cell.editor.UMLReferenceTextWithCompletionCellEditor;
import org.eclipse.papyrus.uml.nattable.messages.Messages;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class UMLMultiReferenceTextualCellEditorWithButtonConfiguration
implements IAxisCellEditorConfiguration {
    public boolean handles(Table table, Object object) {
        Object tmp = AxisUtils.getRepresentedElement((Object)object);
        if (tmp instanceof EReference) {
            EReference ref = (EReference)tmp;
            if (ref.isContainment() || !ref.isChangeable() || ref.isDerived()) {
                return false;
            }
            if (!ref.isMany()) {
                return false;
            }
            EClassifier type = ref.getEType();
            return true;
        }
        if (object instanceof String && ((String)object).startsWith("property_of_stereotype:/")) {
            String str = (String)tmp;
            Property prop = UMLTableUtils.getRealStereotypeProperty(table.getContext(), str);
            if (prop != null) {
                if (prop.isDerived()) {
                    return false;
                }
                Type type = prop.getType();
                if (type instanceof DataType) {
                    return false;
                }
                if (!(type instanceof NamedElement)) {
                    return false;
                }
                if (!prop.isMultivalued()) {
                    return false;
                }
                switch (prop.getAggregation()) {
                    case NONE_LITERAL: 
                    case SHARED_LITERAL: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public IDisplayConverter getDisplayConvert(Table table, Object axisElement, ILabelProvider provider) {
        return new UMLMultiReferenceDisplayConverter();
    }

    public ICellPainter getCellPainter(Table table, Object axisElement) {
        return new TextPainter();
    }

    public ICellEditor getICellEditor(Table table, final Object axisElement, final ITableAxisElementProvider elementProvider) {
        UMLReferenceTextWithCompletionCellEditor editor = new UMLReferenceTextWithCompletionCellEditor(table, axisElement, elementProvider);
        editor.setIsMultiValued(true);
        AbstractOpenDialogCellEditorButtonAction openDialogConfiguration = new AbstractOpenDialogCellEditorButtonAction(){

            public AbstractDialogCellEditor createDialogCellEditor() {
                return new MultiReferenceCellEditor(axisElement, elementProvider);
            }
        };
        editor.setOpenDialogCellEditorButtonAction(openDialogConfiguration);
        openDialogConfiguration.setText("...");
        openDialogConfiguration.setTooltipText(Messages.UMLReferenceCellEditorConfiguration_OpenDialogToChooseTheValue);
        return editor;
    }

    public String getDisplayMode(Table table, Object axisElement) {
        return "EDIT";
    }

    public String getEditorConfigId() {
        return "org.eclipse.papyrus.uml.reference.text.with.completion.editor.and.dialog";
    }

    public IDataValidator getDataValidator(Table table, Object axisElement) {
        return null;
    }

    public String getEditorDescription() {
        return "This configuration provides a Text editor with completion for multi references";
    }
}

