/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.cell.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.papyrus.infra.nattable.celleditor.AbstractPapyrusStyledTextCellEditor;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.CrossAxisWrapper;
import org.eclipse.papyrus.infra.widgets.editors.StringEditorWithCompletionWrapper;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.infra.widgets.util.ISetPapyrusConverter;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.tools.util.UMLReferenceConverter;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionHelper;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLReferenceTextWithCompletionCellEditor
extends AbstractPapyrusStyledTextCellEditor {
    private StringEditorWithCompletionWrapper textCompletion = null;
    private INameResolutionHelper helper;
    private IPapyrusConverter parser;
    private boolean isMultiValued = false;

    public UMLReferenceTextWithCompletionCellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider, boolean commitOnUpDown, boolean moveSelectionOnEnter) {
        super(table, axisElement, elementProvider, commitOnUpDown, moveSelectionOnEnter);
    }

    public UMLReferenceTextWithCompletionCellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider, boolean commitOnUpDown) {
        super(table, axisElement, elementProvider, commitOnUpDown);
    }

    public UMLReferenceTextWithCompletionCellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider) {
        super(table, axisElement, elementProvider);
    }

    public void setIsMultiValued(boolean isMultivalued) {
        this.isMultiValued = isMultivalued;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.helper = this.createNameResolutionHelper();
        this.parser = new UMLReferenceConverter(this.helper, this.isMultiValued);
        this.setPapyrusConverter(this.parser);
        return super.activateCell(parent, originalCanonicalValue);
    }

    private void setPapyrusConverter(IPapyrusConverter parser) {
        if (this.displayConverter instanceof ISetPapyrusConverter) {
            ((ISetPapyrusConverter)this.displayConverter).setPapyrusConverter(parser);
        }
    }

    public Control getEditorControl() {
        return super.getEditorControl();
    }

    protected StyledText createStyledText(Composite parent, int style) {
        this.textCompletion = new StringEditorWithCompletionWrapper(parent, this.parser);
        return this.textCompletion.getTextViewer().getTextWidget();
    }

    public void keyPressed(KeyEvent event) {
        if (this.isMultiValued && this.textCompletion.isContentAssistOpened()) {
            return;
        }
        super.keyPressed(event);
    }

    protected INameResolutionHelper createNameResolutionHelper() {
        CrossAxisWrapper<EObject, EStructuralFeature> editedElement = UMLTableUtils.getRealEditedObject(this.layerCell, this.elementProvider);
        EObject element = (EObject)editedElement.getFirstAxis();
        Element scope = element instanceof Element ? (Element)element : UMLUtil.getBaseElement((EObject)element);
        EStructuralFeature feature = (EStructuralFeature)editedElement.getSecondAxis();
        EClassifier eType = feature.getEType();
        if (eType instanceof EClass) {
            NameResolutionHelper helper = new NameResolutionHelper(scope, (EClass)eType);
            return helper;
        }
        return null;
    }

    public Object getCanonicalValue(IEditErrorHandler conversionErrorHandler) {
        Object canonnicalValue = super.getCanonicalValue(conversionErrorHandler);
        if (canonnicalValue instanceof Collection) {
            return canonnicalValue;
        }
        if (this.isMultiValued) {
            ArrayList<Object> coll = new ArrayList<Object>();
            coll.add(canonnicalValue);
            return coll;
        }
        return canonnicalValue;
    }

    public Object getCanonicalValue() {
        return super.getCanonicalValue();
    }

    public void close() {
        this.textCompletion.getTextWidget().dispose();
        super.close();
    }

    protected EObject getEditedEObject() {
        return null;
    }
}

