/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.Collection;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.PropertyUtil;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortUtil
extends PropertyUtil {
    public static String getCustomLabel(Property property, Collection<String> maskValues) {
        boolean multiLine;
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if (maskValues.contains("visibility")) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)property));
        }
        if (maskValues.contains("derived") && property.isDerived()) {
            buffer.append("/");
        }
        if (maskValues.contains("name")) {
            buffer.append(" ");
            buffer.append(property.getName());
        }
        if (maskValues.contains("type")) {
            if (maskValues.contains("conjugated")) {
                if (((Port)property).isConjugated()) {
                    buffer.append(": ~");
                } else {
                    buffer.append(": ");
                }
            } else {
                buffer.append(": ");
            }
            if (property.getType() != null) {
                buffer.append(property.getType().getName());
            } else {
                buffer.append("<Undefined>");
            }
        }
        if (maskValues.contains("multiplicity")) {
            String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property);
            buffer.append(multiplicity);
        }
        if (maskValues.contains("defaultValue") && property.getDefaultValue() != null) {
            buffer.append(" = ");
            buffer.append(ValueSpecificationUtil.getSpecificationValue(property.getDefaultValue()));
        }
        if (maskValues.contains("modifiers") && !(modifiers = PropertyUtil.getModifiersAsString(property, multiLine = maskValues.contains("multiline"))).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            if (!buffer.toString().endsWith(" ")) {
                buffer.append(" ");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }
}

