/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EAttributeTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeproxyFactory;
import org.eclipse.papyrus.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.papyrus.emf.facet.custom.ui.IContentPropertiesHandlerFactory;
import org.eclipse.papyrus.emf.facet.custom.ui.ICustomizedContentProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.ICustomizedTreeContentProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.efacet.core.FacetUtils;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.papyrus.emf.facet.util.core.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizedTreeContentProvider
implements ICustomizedTreeContentProvider,
ICustomizedContentProvider {
    private final ICustomizationManager customManager;
    private final IContentPropertiesHandler contentHandler;
    private Object[] rootElements;
    private final Map<EObjectCacheElement, TreeElement> cache;

    public CustomizedTreeContentProvider(ICustomizationManager customManager) {
        this.customManager = customManager;
        this.contentHandler = IContentPropertiesHandlerFactory.DEFAULT.createIContentPropertiesHandler(customManager);
        this.cache = new HashMap<EObjectCacheElement, TreeElement>();
    }

    protected Object[] getRootElements(Object inputElement) {
        Object[] result;
        if (inputElement == null) {
            result = new Object[]{};
        } else if (inputElement instanceof EObject) {
            result = new EObject[]{(EObject)inputElement};
        } else if (inputElement instanceof Collection) {
            result = ((Collection)inputElement).toArray();
        } else if (inputElement instanceof EObject[]) {
            result = (EObject[])inputElement;
        } else {
            throw new IllegalArgumentException("Unhandled input element type: " + inputElement.getClass().getSimpleName());
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        int n;
        int n2;
        Object[] objectArray;
        Object[] elements = this.getRootElements(inputElement);
        ArrayList<Object> elementList = new ArrayList<Object>();
        IdentityHashMap<Object, Object> index = new IdentityHashMap<Object, Object>(elements.length + 1);
        if (this.rootElements != null) {
            objectArray = this.rootElements;
            n2 = this.rootElements.length;
            n = 0;
            while (n < n2) {
                Object next = objectArray[n];
                if (next instanceof EObjectTreeElement) {
                    index.put(((EObjectTreeElement)next).getEObject(), next);
                } else {
                    index.put(next, next);
                }
                ++n;
            }
        }
        objectArray = elements;
        n2 = elements.length;
        n = 0;
        while (n < n2) {
            Object element = objectArray[n];
            if (this.isVisible(element, null)) {
                Object existing = index.get(element);
                if (existing != null) {
                    elementList.add(existing);
                } else if (element instanceof EObject) {
                    EObjectTreeElement eObjectProxy = this.getEObjectProxy(element, null);
                    elementList.add(eObjectProxy);
                } else {
                    elementList.add(element);
                }
            }
            ++n;
        }
        this.rootElements = elementList.toArray();
        return this.rootElements;
    }

    protected static EObjectTreeElement createEObjectProxy(Object element, TreeElement parent) {
        EObject eObject = (EObject)element;
        EObjectTreeElement eObjectProxy = TreeproxyFactory.eINSTANCE.createEObjectTreeElement();
        eObjectProxy.setEObject(eObject);
        eObjectProxy.setParent(parent);
        return eObjectProxy;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result;
        if (parentElement == null) {
            result = new Object[]{};
        } else if (parentElement instanceof EObjectTreeElement) {
            EObjectTreeElement eObjectProxy = (EObjectTreeElement)parentElement;
            result = this.getChildren(eObjectProxy);
        } else if (parentElement instanceof EAttributeTreeElement) {
            EAttributeTreeElement attributeProxy = (EAttributeTreeElement)parentElement;
            result = this.getChildren(attributeProxy);
        } else if (parentElement instanceof EReferenceTreeElement) {
            EReferenceTreeElement referenceProxy = (EReferenceTreeElement)parentElement;
            result = this.getChildren(referenceProxy);
        } else {
            Logger.logError((String)("Unknown element in tree: " + parentElement.getClass()), (Plugin)Activator.getDefault());
            result = new Object[]{};
        }
        return result;
    }

    public Object[] getChildren(EObjectTreeElement treeElement) {
        List facetFeatures;
        try {
            facetFeatures = FacetUtils.getETypedElements((EObject)treeElement.getEObject(), EStructuralFeature.class, (IFacetManager)this.customManager.getFacetManager());
        }
        catch (FacetManagerException e) {
            facetFeatures = Collections.emptyList();
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        ArrayList<Object> children = new ArrayList<Object>();
        this.createAttributes(treeElement, facetFeatures, children);
        this.createReferences(treeElement, facetFeatures, children);
        return children.toArray();
    }

    public Object[] getChildren(EAttributeTreeElement attributeProxy) {
        ArrayList<Object> children = new ArrayList<Object>();
        EAttribute eAttribute = attributeProxy.getEAttribute();
        if (eAttribute.isMany()) {
            TreeElement parent = attributeProxy.getParent();
            if (!(parent instanceof EObjectTreeElement)) {
                throw new IllegalStateException("An attribute should appear only under a model element");
            }
            EObjectTreeElement parentProxy = (EObjectTreeElement)parent;
            EObject eObject = parentProxy.getEObject();
            try {
                IFacetManager facetManager = this.customManager.getFacetManager();
                List result = facetManager.getOrInvokeMultiValued(eObject, (ETypedElement)eAttribute, null);
                for (Object object : result) {
                    if (object instanceof EObject) {
                        EObject childEObject = (EObject)object;
                        children.add(this.getEObjectProxy(childEObject, (TreeElement)attributeProxy));
                    }
                    children.add(object);
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return children.toArray();
    }

    public Object[] getChildren(EReferenceTreeElement referenceProxy) {
        TreeElement child;
        EReference eReference = referenceProxy.getEReference();
        EObjectTreeElement parent = referenceProxy.getParent();
        if (!(parent instanceof EObjectTreeElement)) {
            throw new IllegalStateException("A reference should appear only under a model element");
        }
        EObjectTreeElement parentProxy = parent;
        EObject eObject = parentProxy.getEObject();
        List<Object> result = eReference.isMany() ? this.getMultiValuedReferenceChildren(eReference, eObject, referenceProxy) : ((child = this.getSingleValuedReferenceChild(eReference, eObject, referenceProxy)) == null ? Collections.emptyList() : Collections.singletonList(child));
        return result.toArray();
    }

    private TreeElement getSingleValuedReferenceChild(EReference eReference, EObject eObject, EReferenceTreeElement parent) {
        TreeElement child = null;
        if (parent.getReferedEObjectTE() == null || parent.getReferedEObjectTE().size() == 0) {
            try {
                IFacetManager facetManager = this.customManager.getFacetManager();
                EObject referedEObject = (EObject)facetManager.getOrInvoke(eObject, (ETypedElement)eReference, EObject.class);
                if (referedEObject != null) {
                    child = this.getEObjectProxy(referedEObject, (TreeElement)parent);
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        } else {
            child = (TreeElement)parent.getReferedEObjectTE().get(0);
        }
        return child;
    }

    private List<EObjectTreeElement> getMultiValuedReferenceChildren(EReference eReference, EObject eObject, EReferenceTreeElement parent) {
        ArrayList<EObjectTreeElement> children = new ArrayList();
        if (parent.getReferedEObjectTE() == null || parent.getReferedEObjectTE().size() == 0) {
            try {
                IFacetManager facetManager = this.customManager.getFacetManager();
                List result = facetManager.getOrInvokeMultiValued(eObject, (ETypedElement)eReference, null);
                for (Object object : result) {
                    if (!(object instanceof EObject)) continue;
                    EObject childEObject = (EObject)object;
                    children.add(this.getEObjectProxy(childEObject, (TreeElement)parent));
                }
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        } else {
            children = parent.getReferedEObjectTE();
        }
        return children;
    }

    public Object getParent(Object element) {
        TreeElement result = null;
        if (element instanceof TreeElement) {
            TreeElement treeElement = (TreeElement)element;
            result = treeElement.getParent();
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != newInput) {
            this.cache.clear();
        }
    }

    @Override
    public ICustomizationManager getCustomizationManager() {
        return this.customManager;
    }

    public boolean isVisible(Object object, ETypedElement eTypedElement) {
        Boolean result = Boolean.TRUE;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            try {
                result = (Boolean)this.customManager.getCustomValueOf(eObject, eTypedElement, this.contentHandler.getIsVisible(), Boolean.class);
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    private boolean collapseLink(Object object, EReference eTypedElement) {
        Boolean result = Boolean.TRUE;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            try {
                result = (Boolean)this.customManager.getCustomValueOf(eObject, (ETypedElement)eTypedElement, this.contentHandler.getCollapseLink(), Boolean.class);
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    private void createReferences(EObjectTreeElement treeElement, Collection<EStructuralFeature> facetFeatures, Collection<Object> children) {
        EObject eObject = treeElement.getEObject();
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            this.createReference(treeElement, eObject, eReference, children);
        }
        for (EStructuralFeature eStructuralFeature : facetFeatures) {
            if (!(eStructuralFeature instanceof EReference)) continue;
            this.createReference(treeElement, eObject, (EReference)eStructuralFeature, children);
        }
    }

    private void createReference(EObjectTreeElement treeElement, EObject eObject, EReference eReference, Collection<Object> children) {
        if (this.isVisible(eObject, (ETypedElement)eReference)) {
            if (this.collapseLink(eObject, eReference)) {
                if (eReference.getUpperBound() != 1) {
                    this.collectMultiValuedReferenceChildren(eReference, eObject, (TreeElement)treeElement, children);
                } else {
                    Object child = this.getSingleValuedReferenceChild(eReference, eObject, (TreeElement)treeElement);
                    if (child != null) {
                        children.add(child);
                    }
                }
            } else {
                children.add(this.getEReferenceProxy(eReference, treeElement));
            }
        }
    }

    private void createAttributes(EObjectTreeElement treeElement, Collection<EStructuralFeature> facetFeatures, Collection<? super TreeElement> children) {
        EObject eObject = treeElement.getEObject();
        for (EAttribute eAttribute : eObject.eClass().getEAllAttributes()) {
            this.createAttribute(treeElement, eObject, eAttribute, children);
        }
        for (EStructuralFeature eStructuralFeature : facetFeatures) {
            if (!(eStructuralFeature instanceof EAttribute)) continue;
            this.createAttribute(treeElement, eObject, (EAttribute)eStructuralFeature, children);
        }
    }

    private void createAttribute(EObjectTreeElement treeElement, EObject eObject, EAttribute eAttribute, Collection<? super TreeElement> children) {
        EAttributeTreeElement eAttributeTreeElement;
        if (this.isVisible(eObject, (ETypedElement)eAttribute) && (eAttributeTreeElement = this.getEAttributeProxy(eAttribute, (TreeElement)treeElement)) != null) {
            children.add((TreeElement)eAttributeTreeElement);
        }
    }

    private EReferenceTreeElement createReferenceProxy(EReference reference, EObjectTreeElement parent) {
        EObject eObject = parent.getEObject();
        if (this.isVisible(eObject, (ETypedElement)reference)) {
            EReferenceTreeElement referenceProxy = TreeproxyFactory.eINSTANCE.createEReferenceTreeElement();
            referenceProxy.setEReference(reference);
            referenceProxy.setParent(parent);
            return referenceProxy;
        }
        return null;
    }

    private EAttributeTreeElement createAttributeProxy(EAttribute attribute, EObjectTreeElement parent) {
        EObject eObject = parent.getEObject();
        if (this.isVisible(eObject, (ETypedElement)attribute)) {
            EAttributeTreeElement attributeProxy = TreeproxyFactory.eINSTANCE.createEAttributeTreeElement();
            attributeProxy.setEAttribute(attribute);
            attributeProxy.setParent((TreeElement)parent);
            return attributeProxy;
        }
        return null;
    }

    private Object getSingleValuedReferenceChild(EReference eReference, EObject eObject, TreeElement parent) {
        EObjectTreeElement child = null;
        try {
            IFacetManager facetManager = this.customManager.getFacetManager();
            Object result = facetManager.getOrInvoke(eObject, (ETypedElement)eReference, null);
            if (result instanceof EObject) {
                EObject childEObject = (EObject)result;
                child = this.getEObjectProxy(childEObject, parent);
            }
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return child;
    }

    private void collectMultiValuedReferenceChildren(EReference eReference, EObject eObject, TreeElement parent, Collection<Object> children) {
        try {
            IFacetManager facetManager = this.customManager.getFacetManager();
            List result = facetManager.getOrInvokeMultiValued(eObject, (ETypedElement)eReference, null);
            for (Object object : result) {
                if (!(object instanceof EObject)) continue;
                EObject childEObject = (EObject)object;
                children.add(this.getEObjectProxy(childEObject, parent));
            }
        }
        catch (FacetManagerException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    protected EObjectTreeElement getEObjectProxy(Object element, TreeElement parent) {
        EObjectCacheElement cacheElement = new EObjectCacheElement((EObject)element, parent);
        if (!this.cache.containsKey(cacheElement)) {
            this.cache.put(cacheElement, (TreeElement)CustomizedTreeContentProvider.createEObjectProxy(element, parent));
        }
        return (EObjectTreeElement)this.cache.get(cacheElement);
    }

    protected EAttributeTreeElement getEAttributeProxy(Object element, TreeElement parent) {
        EObjectCacheElement cacheElement = new EObjectCacheElement((EObject)element, parent);
        if (!this.cache.containsKey(cacheElement)) {
            this.cache.put(cacheElement, (TreeElement)this.createAttributeProxy((EAttribute)element, (EObjectTreeElement)parent));
        }
        return (EAttributeTreeElement)this.cache.get(cacheElement);
    }

    protected EReferenceTreeElement getEReferenceProxy(Object element, EObjectTreeElement parent) {
        EObjectCacheElement cacheElement = new EObjectCacheElement((EObject)element, (TreeElement)parent);
        if (!this.cache.containsKey(cacheElement)) {
            this.cache.put(cacheElement, (TreeElement)this.createReferenceProxy((EReference)element, parent));
        }
        return (EReferenceTreeElement)this.cache.get(cacheElement);
    }

    public void dispose() {
        this.cache.clear();
        this.rootElements = null;
    }

    private class EObjectCacheElement {
        private final EObject element;
        private final TreeElement parent;

        public EObjectCacheElement(EObject element, TreeElement parent) {
            this.element = element;
            this.parent = parent;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EObjectCacheElement)) {
                return false;
            }
            EObjectCacheElement other = (EObjectCacheElement)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        private CustomizedTreeContentProvider getOuterType() {
            return CustomizedTreeContentProvider.this;
        }
    }
}

