/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStyleValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.listener.CustomStyleListener;
import org.eclipse.papyrus.uml.tools.databinding.CommandBasedObservableValue;

public abstract class AbstractCustomStyleObservableValue
extends AbstractObservableValue
implements CommandBasedObservableValue,
IChangeListener,
IObserving {
    protected View source;
    protected EditingDomain domain;
    protected String styleName;
    protected Object lastValue;
    protected CustomStyleListener listener;
    protected EClass styleClass;
    protected EStructuralFeature styleFeature;

    public AbstractCustomStyleObservableValue(View source, EditingDomain domain, String styleName, EClass styleClass, EStructuralFeature styleFeature) {
        this.source = source;
        this.domain = domain;
        this.styleName = styleName;
        this.styleClass = styleClass;
        this.styleFeature = styleFeature;
        this.listener = new CustomStyleListener(source, styleFeature, (IChangeListener)this, styleName);
        source.eAdapters().add((Object)this.listener);
    }

    public void handleChange(ChangeEvent event) {
        final Object oldValue = this.lastValue;
        final Object newValue = this.doGetValue();
        this.fireValueChange(new ValueDiff(){

            public Object getOldValue() {
                return oldValue;
            }

            public Object getNewValue() {
                return newValue;
            }
        });
    }

    protected Object doGetValue() {
        NamedStyle valueStyle = this.source.getNamedStyle(this.styleClass, this.styleName);
        this.lastValue = valueStyle != null ? valueStyle.eGet(this.styleFeature) : this.getDefaultValue();
        return this.lastValue;
    }

    protected abstract Object getDefaultValue();

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        this.domain.getCommandStack().execute(command);
        this.doGetValue();
    }

    public Command getCommand(Object value) {
        return new CustomStyleValueCommand(this.source, value, this.styleClass, this.styleFeature, this.styleName);
    }

    public Object getObserved() {
        return this.source;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.listener != null) {
            this.source.eAdapters().remove((Object)this.listener);
            this.listener.dispose();
            this.listener = null;
        }
        super.dispose();
    }
}

