/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpart;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IConflictingEditPartFilter;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusPopupBarEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.XYLayoutWithConstrainedResizedEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.handler.IRefreshHandlerPart;
import org.eclipse.papyrus.infra.gmfdiag.common.selection.PapyrusRubberbandDragTracker;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.SVGPostProcessor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.ui.IEditorPart;

public class PapyrusDiagramEditPart
extends DiagramEditPart {
    private static final Map<Diagram, Set<PapyrusDiagramEditPart>> diagrams = new WeakHashMap<Diagram, Set<PapyrusDiagramEditPart>>();
    private IConflictingEditPartFilter conflictFilter = IConflictingEditPartFilter.DEFAULT;
    public static final int RIGHT_MOUSE_BUTTON = 3;

    public PapyrusDiagramEditPart(View diagramView) {
        super(diagramView);
        PapyrusDiagramEditPart.register(diagramView, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(View diagramView, PapyrusDiagramEditPart editPart) {
        if (diagramView instanceof Diagram) {
            Diagram diagram = (Diagram)diagramView;
            Map<Diagram, Set<PapyrusDiagramEditPart>> map = diagrams;
            synchronized (map) {
                Set diagramEditParts = diagrams.get(diagram);
                if (diagramEditParts == null) {
                    diagramEditParts = Sets.newSetFromMap(new WeakHashMap());
                    diagrams.put(diagram, diagramEditParts);
                }
                diagramEditParts.add((PapyrusDiagramEditPart)editPart);
            }
        }
    }

    public void refresh() {
        if (SVGPostProcessor.instance instanceof IRefreshHandlerPart) {
            IEditorPart activeEditor = null;
            try {
                IMultiDiagramEditor multiDiagramEditor = (IMultiDiagramEditor)ServiceUtilsForEditPart.getInstance().getService(IMultiDiagramEditor.class, (Object)this);
                activeEditor = multiDiagramEditor.getActiveEditor();
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
            ((IRefreshHandlerPart)((Object)SVGPostProcessor.instance)).refresh(activeEditor);
        }
        super.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<? extends DiagramEditPart> getDiagramEditPartsFor(Diagram diagram) {
        Set<PapyrusDiagramEditPart> result;
        Map<Diagram, Set<PapyrusDiagramEditPart>> map = diagrams;
        synchronized (map) {
            result = diagrams.get(diagram);
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    protected void removeChild(EditPart child) {
        if (!this.getConflictingEditPartFilter().isConflicting(child)) {
            super.removeChild(child);
        }
    }

    public IConflictingEditPartFilter getConflictingEditPartFilter() {
        return this.conflictFilter;
    }

    public void setConflictingEditPartFilter(IConflictingEditPartFilter filter) {
        this.conflictFilter = filter == null ? IConflictingEditPartFilter.DEFAULT : filter;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutWithConstrainedResizedEditPolicy());
        this.removeEditPolicy("PopupBarEditPolicy");
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new PapyrusPopupBarEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new PapyrusRubberbandDragTracker();
    }
}

