/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticAdapter;

public class DefaultCreationEditPolicy
extends CreationEditPolicy {
    protected Command getCreateCommand(CreateViewRequest request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            CreateViewCommand createCommand = new CreateViewCommand(editingDomain, descriptor, (View)this.getHost().getModel());
            cc.compose((IUndoableOperation)createCommand);
        }
        return new ICommandProxy(cc.reduce());
    }

    protected ICommand getReparentViewCommand(IGraphicalEditPart gep) {
        GraphicalEditPart parent = (GraphicalEditPart)this.getHost();
        if (parent instanceof ListCompartmentEditPart && !this.canCreate(gep)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getReparentViewCommand(gep);
    }

    private boolean canCreate(IGraphicalEditPart gep) {
        CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor(gep);
        CreateViewRequest request = new CreateViewRequest(descriptor);
        Command createCommand = this.getCreateCommand(request);
        return createCommand.canExecute();
    }

    private CreateViewRequest.ViewDescriptor getViewDescriptor(IGraphicalEditPart gep) {
        String type = gep.getNotationView().getType();
        SemanticAdapter elementAdapter = new SemanticAdapter(gep.resolveSemanticElement(), null);
        return new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, type, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
    }
}

