/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateShapeCompartmentViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SetNodeVisibilityCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.NotificationManager;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ShapeService;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.swt.widgets.Display;

public class ShapeCompartmentEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String SHAPE_COMPARTMENT_EDIT_POLICY = "ShapeCompartmentEditPolicy";
    protected NotificationManager notificationManager;

    public void activate() {
        super.activate();
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.notificationManager = ShapeService.getInstance().createNotificationManager(this.getDiagramEventBroker(), (EObject)view, this);
        this.createShapeCompartment();
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.notificationManager.dispose();
        this.notificationManager = null;
        super.deactivate();
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    public void refreshDisplay() {
        IGraphicalEditPart editPart = (IGraphicalEditPart)this.getHost();
        editPart.refresh();
    }

    protected boolean hasToDisplayCompartment(EObject view) {
        return ShapeService.getInstance().hasShapeToDisplay(view);
    }

    protected void executeShapeCompartmentCreation(IGraphicalEditPart editPart) {
        try {
            TransactionalEditingDomain domain = this.getEditingDomain(editPart);
            CreateShapeCompartmentViewCommand command = new CreateShapeCompartmentViewCommand(domain, "Create Compartment", "Command that creates the compartment displaying shapes", editPart.getNotationView(), false);
            try {
                GMFUnsafe.write(domain, (Command)command);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected TransactionalEditingDomain getEditingDomain(IGraphicalEditPart editPart) {
        return editPart.getEditingDomain();
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void notifyChanged(Notification notification) {
        this.refreshDisplay();
    }

    public void createShapeCompartment() {
        IGraphicalEditPart editPart = (IGraphicalEditPart)this.getHost();
        View node = editPart.getNotationView();
        View shapeCompartment = this.getShapeCompartmentView(node);
        if (shapeCompartment == null) {
            this.executeShapeCompartmentCreation(editPart);
        }
    }

    private View getShapeCompartmentView(View node) {
        for (Object child : node.getChildren()) {
            if (!(child instanceof View) || !"compartment_shape_display".equals(((View)child).getType())) continue;
            return (View)child;
        }
        return null;
    }

    protected void setVisibility(final View view, final boolean isVisible) {
        final GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                SetNodeVisibilityCommand setCommand = new SetNodeVisibilityCommand(editPart.getEditingDomain(), view, isVisible);
                try {
                    GMFUnsafe.write(editPart.getEditingDomain(), (Command)setCommand);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
        });
    }
}

