/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.shape;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.notation.IntValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.CreateProviderNotificationManagersOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.GetAllShapeProvidersOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.GetSVGDocumentForViewOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.GetShapeProviderByIdentifierOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.GetShapesForViewOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.IShapeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.IShapeProviderOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.NotificationManager;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ProviderNotificationManager;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ShapeProviderConfiguration;
import org.w3c.dom.svg.SVGDocument;

public class ShapeService
extends Service {
    private static final String MAX_NUMBER_OF_SYMBOL = "maxNumberOfSymbol";
    private static ShapeService instance;

    protected ShapeService() {
    }

    public boolean hasShapeToDisplay(EObject view) {
        List images = this.execute(ExecutionStrategy.REVERSE, new GetShapesForViewOperation(view));
        return images != null && images.size() > 0;
    }

    public List<RenderedImage> getShapesToDisplay(EObject view) {
        List listOfListOfImages = this.execute(ExecutionStrategy.FORWARD, new GetShapesForViewOperation(view));
        ArrayList images = new ArrayList();
        for (List listOfImages : listOfListOfImages) {
            if (listOfImages == null || listOfImages.isEmpty()) continue;
            images.addAll(listOfImages);
        }
        int nbImagesToDisplay = NotationUtils.getIntValue((View)view, MAX_NUMBER_OF_SYMBOL, this.getDefaultMaxNumberOfSymbol());
        return images.subList(0, Math.min(nbImagesToDisplay, images.size()));
    }

    public List<SVGDocument> getSVGDocumentToDisplay(EObject view) {
        List listOfListOfImages = this.execute(ExecutionStrategy.FORWARD, new GetSVGDocumentForViewOperation(view));
        ArrayList images = new ArrayList();
        for (List listOfImages : listOfListOfImages) {
            if (listOfImages == null || listOfImages.isEmpty()) continue;
            images.addAll(listOfImages);
        }
        int nbImagesToDisplay = NotationUtils.getIntValue((View)view, MAX_NUMBER_OF_SYMBOL, this.getDefaultMaxNumberOfSymbol());
        return images.subList(0, Math.min(nbImagesToDisplay, images.size()));
    }

    private int getMaxNumberOfSymbolToDisplay(EObject view) {
        IntValueStyle maxNbImages = (IntValueStyle)((View)view).getNamedStyle(NotationPackage.eINSTANCE.getIntValueStyle(), MAX_NUMBER_OF_SYMBOL);
        int nbImagesToDisplay = maxNbImages != null ? maxNbImages.getIntValue() : this.getDefaultMaxNumberOfSymbol();
        return nbImagesToDisplay;
    }

    private int getDefaultMaxNumberOfSymbol() {
        return 10;
    }

    protected List<ProviderNotificationManager> createProviderNotificationManagers(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener notificationListener) {
        List providerNotificationManagers = this.execute(ExecutionStrategy.REVERSE, new CreateProviderNotificationManagersOperation(diagramEventBroker, view, notificationListener));
        return providerNotificationManagers;
    }

    public static synchronized ShapeService getInstance() {
        if (instance == null) {
            instance = new ShapeService();
            ShapeService.configureProviders();
        }
        return instance;
    }

    private static void configureProviders() {
        ShapeService.getInstance().configureProviders("org.eclipse.papyrus.infra.gmfdiag.common", "shapeProvider");
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    public List<IShapeProvider> getProviders() {
        ArrayList<IShapeProvider> providers = new ArrayList<IShapeProvider>();
        this.execute(ExecutionStrategy.REVERSE, new GetAllShapeProvidersOperation(providers));
        return providers;
    }

    public IShapeProvider getProvider(String id) {
        List providers = this.execute(ExecutionStrategy.REVERSE, new GetShapeProviderByIdentifierOperation(id));
        if (providers == null) {
            return null;
        }
        for (IShapeProvider aspectActionProvider : providers) {
            if (aspectActionProvider == null) continue;
            return aspectActionProvider;
        }
        return null;
    }

    public NotificationManager createNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener notificationListener) {
        NotificationManager manager = new NotificationManager(view);
        List<ProviderNotificationManager> providerNotificationManagers = this.createProviderNotificationManagers(diagramEventBroker, view, notificationListener);
        manager.getProviderNotificationManagers().addAll(providerNotificationManagers);
        return manager;
    }

    protected static class ProviderDescriptor
    extends ActivityFilterProviderDescriptor {
        protected ShapeProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = ShapeProviderConfiguration.parse(element);
            Assert.isNotNull((Object)((Object)this.providerConfiguration));
        }

        public boolean provides(IOperation operation) {
            if (!super.provides(operation)) {
                return false;
            }
            if (!(operation instanceof IShapeProviderOperation)) {
                return false;
            }
            if (operation instanceof GetShapeProviderByIdentifierOperation) {
                return this.providerConfiguration.getId().equals(((GetShapeProviderByIdentifierOperation)operation).getIdentifier());
            }
            return true;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                IProvider newProvider = super.getProvider();
                if (this.provider instanceof IShapeProvider) {
                    IShapeProvider defaultProvider = (IShapeProvider)newProvider;
                    defaultProvider.setConfiguration(this.getElement());
                }
                return newProvider;
            }
            return super.getProvider();
        }
    }
}

