/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.policy;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.DefaultActionHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SelectAndExecuteCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.requests.CanonicalDropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.Activator;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.DropStrategyManager;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DefaultDropStrategy;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DropStrategy;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizableDropEditPolicy
extends DragDropEditPolicy {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.dnd.dropStrategy";
    protected EditPolicy defaultDropEditPolicy;
    protected EditPolicy defaultCreationEditPolicy;
    protected DropStrategy defaultDropStrategy;
    public static final String EVENT_DETAIL = "EVENT_DETAIL";

    public void activate() {
    }

    public CustomizableDropEditPolicy(EditPolicy defaultDropEditPolicy, EditPolicy defaultCreationEditPolicy) {
        this.defaultDropEditPolicy = defaultDropEditPolicy;
        this.defaultCreationEditPolicy = defaultCreationEditPolicy;
        this.defaultDropStrategy = new DefaultDropStrategy(defaultDropEditPolicy, defaultCreationEditPolicy);
    }

    public Command getCommand(Request request) {
        Object command;
        if (super.understandsRequest(request)) {
            try {
                command = super.getCommand(request);
            }
            catch (Exception ex) {
                command = this.getCustomCommand(request);
            }
        } else {
            EditPart myTargetEditPart;
            EditPart defaultTargetEditPart;
            command = this.understands(request) ? ("org.eclipse.papyrus.CANONICAL_DROP_OBJECTS".equals(request.getType()) ? this.getCanonicalDropObjectsCommand(request) : this.getCreationCommand(request)) : (this.defaultCreationEditPolicy != null ? (this.defaultCreationEditPolicy.understandsRequest(request) ? ((defaultTargetEditPart = this.defaultCreationEditPolicy.getTargetEditPart(request)) != (myTargetEditPart = super.getTargetEditPart(request)) ? defaultTargetEditPart.getCommand(request) : this.defaultCreationEditPolicy.getCommand(request)) : null) : null);
        }
        if (command == null) {
            return null;
        }
        return command;
    }

    public boolean understandsRequest(Request request) {
        return this.understands(request) || this.defaultCreationEditPolicy != null && this.defaultCreationEditPolicy.understandsRequest(request) || this.defaultDropEditPolicy != null && this.defaultDropEditPolicy.understandsRequest(request) || this.isCustomRequest(request);
    }

    protected boolean understands(Request request) {
        return "add children".equals(request.getType()) || "org.eclipse.papyrus.CANONICAL_DROP_OBJECTS".equals(request.getType());
    }

    protected boolean isCustomRequest(Request request) {
        return !this.findStrategies(request).isEmpty();
    }

    protected Command getCreationCommand(Request request) {
        return this.getCustomCommand(request);
    }

    protected Command getCanonicalDropObjectsCommand(Request request) {
        Command result = null;
        if (this.defaultDropEditPolicy != null && request instanceof CanonicalDropObjectsRequest) {
            result = this.defaultDropEditPolicy.getCommand((Request)((CanonicalDropObjectsRequest)request).getDropObjectsRequest());
        }
        return result;
    }

    protected Command getDropObjectsCommand(DropObjectsRequest request) {
        Command dropCommand = this.getCustomCommand((Request)request);
        if (dropCommand != null && dropCommand.canExecute() && request.getObjects().size() > 1) {
            return this.layoutDroppedObjects(dropCommand);
        }
        return dropCommand;
    }

    protected Command layoutDroppedObjects(final Command dropCommand) {
        AbstractTransactionalCommand spacingCommand = new AbstractTransactionalCommand((TransactionalEditingDomain)EMFHelper.resolveEditingDomain((Object)this.getHost()), "Spacing elements", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Object returnValue;
                ICommand gmfCommand;
                CommandResult previousCommandResult;
                if (dropCommand instanceof ICommandProxy && (previousCommandResult = (gmfCommand = ((ICommandProxy)dropCommand).getICommand()).getCommandResult()) != null && (returnValue = previousCommandResult.getReturnValue()) instanceof List) {
                    List returnedElements = (List)returnValue;
                    int i = 0;
                    for (Object returnedElement : returnedElements) {
                        LayoutConstraint constraint;
                        CreateViewRequest.ViewDescriptor newViewDescriptor;
                        Shape newShape;
                        if (!(returnedElement instanceof CreateViewRequest.ViewDescriptor) || (newShape = (Shape)(newViewDescriptor = (CreateViewRequest.ViewDescriptor)returnedElement).getAdapter(Shape.class)) == null || !((constraint = newShape.getLayoutConstraint()) instanceof Bounds)) continue;
                        Bounds bounds = (Bounds)constraint;
                        CustomizableDropEditPolicy.this.updateBounds(bounds, i);
                        ++i;
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
        return dropCommand.chain((Command)new ICommandProxy((ICommand)spacingCommand));
    }

    protected void updateBounds(Bounds bounds, int position) {
        int x = bounds.getX();
        int y = bounds.getY();
        bounds.setX(x + 15 * position);
        bounds.setY(y + 15 * position);
    }

    protected Command getCustomCommand(Request request) {
        final Map<DropStrategy, Command> matchingStrategies = this.findStrategies(request);
        if (matchingStrategies.size() == 1) {
            return matchingStrategies.values().iterator().next();
        }
        if (matchingStrategies.size() > 1) {
            DropStrategy defaultStrategy;
            int eventDetailValue;
            boolean useDefault = true;
            if (request.getExtendedData().containsKey(EVENT_DETAIL) && ((eventDetailValue = ((Integer)request.getExtendedData().get(EVENT_DETAIL)).intValue()) & 1) != 0) {
                useDefault = false;
            }
            if (useDefault && (defaultStrategy = DropStrategyManager.instance.getDefaultDropStrategy(matchingStrategies.keySet())) != null) {
                return matchingStrategies.get(defaultStrategy);
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            DefaultActionHandler handler = new DefaultActionHandler(){

                public void defaultActionSelected(Command defaultCommand) {
                    DropStrategy defaultStrategy = CustomizableDropEditPolicy.findStrategy(matchingStrategies, defaultCommand);
                    if (defaultStrategy != null) {
                        DropStrategyManager.instance.setDefaultDropStrategy(matchingStrategies.keySet(), defaultStrategy);
                    }
                }

                public String getLabel() {
                    return "Change the default strategy";
                }
            };
            SelectAndExecuteCommand command = new SelectAndExecuteCommand("Select drop", shell, new LinkedList<Command>(matchingStrategies.values()), handler);
            return new ICommandProxy((ICommand)command);
        }
        return null;
    }

    private static DropStrategy findStrategy(Map<DropStrategy, Command> matchingStrategies, Command command) {
        for (Map.Entry<DropStrategy, Command> entry : matchingStrategies.entrySet()) {
            if (entry.getValue() != command) continue;
            return entry.getKey();
        }
        return null;
    }

    protected Map<DropStrategy, Command> findStrategies(Request request) {
        LinkedHashMap<DropStrategy, Command> matchingStrategies = new LinkedHashMap<DropStrategy, Command>();
        for (DropStrategy strategy : DropStrategyManager.instance.getActiveStrategies()) {
            try {
                Command command = strategy.getCommand(request, this.getHost());
                if (command == null || !command.canExecute()) continue;
                matchingStrategies.put(strategy, command);
            }
            catch (Throwable t) {
                String message = String.format("An error occurred when trying to execute a custom Drop strategy: %s", strategy.getLabel());
                Activator.log.error(message, t);
            }
        }
        Command command = this.defaultDropStrategy.getCommand(request, this.getHost());
        if (command != null && command.canExecute()) {
            matchingStrategies.put(this.defaultDropStrategy, command);
        }
        return matchingStrategies;
    }

    public void showTargetFeedback(Request request) {
        if (this.defaultCreationEditPolicy != null && this.defaultCreationEditPolicy.understandsRequest(request)) {
            this.defaultCreationEditPolicy.showTargetFeedback(request);
        }
        if (!(this.getHost() instanceof DiagramEditPart)) {
            super.showTargetFeedback(request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this.defaultCreationEditPolicy != null) {
            this.defaultCreationEditPolicy.eraseTargetFeedback(request);
        }
        if (!(this.getHost() instanceof DiagramEditPart)) {
            super.eraseTargetFeedback(request);
        }
    }

    public void showSourceFeedback(Request request) {
        if (this.defaultCreationEditPolicy != null && this.defaultCreationEditPolicy.understandsRequest(request)) {
            this.defaultCreationEditPolicy.showSourceFeedback(request);
        }
        if (!(this.getHost() instanceof DiagramEditPart)) {
            super.showSourceFeedback(request);
        }
    }

    public void eraseSourceFeedback(Request request) {
        if (this.defaultCreationEditPolicy != null) {
            this.defaultCreationEditPolicy.showSourceFeedback(request);
        }
        if (!(this.getHost() instanceof DiagramEditPart)) {
            super.eraseSourceFeedback(request);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        if (!super.understandsRequest(request) && !this.understands(request) && this.defaultCreationEditPolicy != null && this.defaultCreationEditPolicy.understandsRequest(request)) {
            return this.defaultCreationEditPolicy.getTargetEditPart(request);
        }
        return super.getTargetEditPart(request);
    }
}

