/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.views.config.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.emf.adapters.ResourceSetRootsAdapter;
import org.eclipse.papyrus.infra.emf.nattable.manager.axis.AbstractSynchronizedOnEStructuralFeatureAxisManager;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.views.config.Activator;
import org.eclipse.papyrus.infra.nattable.views.config.utils.Utils;

public class EditorContextSynchronizerAxisManager
extends AbstractSynchronizedOnEStructuralFeatureAxisManager {
    private IPageManager pageManager;
    private ModelSet modelSet;

    protected void addContextFeatureValueListener() {
        this.featureListener = new ResourceSetRootsAdapter(){

            protected void doNotify(Notification msg) {
                switch (msg.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        EditorContextSynchronizerAxisManager.this.featureValueHasChanged(msg);
                    }
                }
            }
        };
        try {
            this.modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)this.getTableManager().getTable());
            this.featureListener.setTarget((Notifier)this.modelSet);
        }
        catch (Exception ex) {
            Activator.log.error("An error occurred when trying to install a listener on the available pages", (Throwable)ex);
        }
    }

    protected void removeListeners() {
        if (this.modelSet != null && this.featureListener != null) {
            ((ResourceSetRootsAdapter)this.featureListener).unsetTarget((Notifier)this.modelSet);
        }
    }

    protected List<Object> getFeaturesValue() {
        if (this.pageManager == null) {
            try {
                this.pageManager = ServiceUtilsForEObject.getInstance().getIPageManager((Object)this.getTableManager().getTable());
            }
            catch (Exception ex) {
                Activator.log.error("The page manager is not accessible", (Throwable)ex);
                return Collections.emptyList();
            }
        }
        return new LinkedList<Object>(this.pageManager.allPages());
    }

    protected void verifyValues() {
    }

    public boolean isAllowedContents(Object object) {
        if (object instanceof PageRef) {
            return this.mustBeDisplayedInThisTable(((PageRef)object).getPageIdentifier());
        }
        return this.mustBeDisplayedInThisTable(object);
    }

    private boolean mustBeDisplayedInThisTable(Object page) {
        Object value = Utils.getEditorContext(page);
        if (value instanceof EObject) {
            EObject tableContext = this.getTableContext();
            EObject container = (EObject)value;
            while (container != null) {
                if (container == tableContext) {
                    return true;
                }
                container = container.eContainer();
            }
        }
        return false;
    }

    public void dispose() {
        this.pageManager = null;
        super.dispose();
        this.modelSet = null;
        this.featureListener = null;
    }

    public boolean canEditAxisHeader() {
        return false;
    }

    public boolean canDestroyAxisElement(Integer axisPosition) {
        return false;
    }

    public Command getDestroyAxisElementCommand(TransactionalEditingDomain domain, Integer axisPosition) {
        return UnexecutableCommand.INSTANCE;
    }

    protected void featureValueHasChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        int eventType = notification.getEventType();
        ArrayList<Object> toAdd = new ArrayList<Object>();
        ArrayList<Object> toRemove = new ArrayList<Object>();
        switch (eventType) {
            case 8: {
                break;
            }
            case 3: {
                Object newValue = notification.getNewValue();
                if (newValue instanceof PageRef) {
                    newValue = ((PageRef)newValue).getPageIdentifier();
                }
                if (!this.isAllowedContents(newValue)) break;
                toAdd.add(newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                for (Object current : newValues) {
                    if (current instanceof PageRef) {
                        current = ((PageRef)current).getPageIdentifier();
                    }
                    if (!this.isAllowedContents(current)) continue;
                    toAdd.add(current);
                }
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                break;
            }
            case 4: {
                Object oldValue = notification.getOldValue();
                if (oldValue instanceof PageRef) {
                    oldValue = ((PageRef)oldValue).getPageIdentifier();
                }
                if (!this.managedObject.contains(oldValue)) break;
                toRemove.add(oldValue);
                break;
            }
            case 6: {
                Collection oldValues = (Collection)notification.getOldValue();
                for (Object current : oldValues) {
                    if (current instanceof PageRef) {
                        current = ((PageRef)current).getPageIdentifier();
                    }
                    if (!this.managedObject.contains(current)) continue;
                    toRemove.add(current);
                }
                break;
            }
        }
        if (toAdd.size() > 0 || toRemove.size() > 0) {
            this.updateManagedList(toAdd, toRemove);
        }
    }
}

