/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.libraries.helper;

import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.alf.libraries.helper.ApplyProfileCommand;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class AlfUtil {
    private static AlfUtil singleton;
    protected Profile standardProfile;
    protected Profile actionLanguageProfile;
    protected Stereotype textualRepresentationStereotype;

    private AlfUtil() {
    }

    public static AlfUtil getInstance() {
        if (singleton == null) {
            singleton = new AlfUtil();
        }
        return singleton;
    }

    public String getTextualRepresentation(Element element) {
        String representation = "";
        Comment textualRepresentationComment = this.getTextualRepresentationComment(element);
        if (textualRepresentationComment != null) {
            representation = textualRepresentationComment.getBody();
        }
        return representation;
    }

    public Comment getTextualRepresentationComment(Element element) {
        Comment textualRepresentationComment = null;
        Iterator commentsIterator = element.getOwnedComments().iterator();
        while (commentsIterator.hasNext() && textualRepresentationComment == null) {
            Comment comment = (Comment)commentsIterator.next();
            if (comment.getBody() == null || !this.isATextualRepresentationComment(comment)) continue;
            textualRepresentationComment = comment;
        }
        return textualRepresentationComment;
    }

    public Profile getStandardProfile(Model context) {
        if (this.standardProfile == null) {
            this.standardProfile = this.getProfile(context, "Standard");
        }
        return this.standardProfile;
    }

    public Profile getActionLanguageProfile(Model context) {
        if (this.actionLanguageProfile == null) {
            this.actionLanguageProfile = this.getProfile(context, "ActionLanguage");
            this.textualRepresentationStereotype = this.actionLanguageProfile.getOwnedStereotype("TextualRepresentation");
        }
        return this.actionLanguageProfile;
    }

    protected Profile getProfile(Model context, String name) {
        Resource modelResource;
        Profile profile = null;
        IRegisteredProfile registeredProfile = RegisteredProfile.getRegisteredProfile((String)name);
        if (registeredProfile != null && (modelResource = context.eResource().getResourceSet().getResource(registeredProfile.getUri(), true)).getContents().get(0) instanceof Profile) {
            profile = (Profile)modelResource.getContents().get(0);
        }
        return profile;
    }

    private Stereotype getTextualRepresentationStereotype(Comment comment) {
        if (this.textualRepresentationStereotype == null) {
            for (Stereotype stereotype : comment.getApplicableStereotypes()) {
                if (!stereotype.getName().equals("TextualRepresentation")) continue;
                this.textualRepresentationStereotype = stereotype;
            }
        }
        return this.textualRepresentationStereotype;
    }

    public boolean isATextualRepresentationComment(Comment comment) {
        Stereotype textualRepresentationStereotype = this.getTextualRepresentationStereotype(comment);
        return textualRepresentationStereotype != null && comment.getAppliedStereotypes().contains((Object)textualRepresentationStereotype) && "Alf".equals(comment.getValue(textualRepresentationStereotype, "language"));
    }

    public boolean isActionLanguageProfileApplied(Element context) {
        if (context.getModel() != null) {
            EList appliedProfiles = context.getModel().getAppliedProfiles();
            return appliedProfiles.contains(this.getActionLanguageProfile(context.getModel()));
        }
        return false;
    }

    public boolean isStandardProfileApplied(Element context) {
        if (context.getModel() != null) {
            EList appliedProfiles = context.getModel().getAppliedProfiles();
            return appliedProfiles.contains(this.getStandardProfile(context.getModel()));
        }
        return false;
    }

    public boolean applyActionLanguageProfile(Element context) {
        boolean applied = this.isActionLanguageProfileApplied(context);
        if (!applied) {
            ApplyProfileCommand command = new ApplyProfileCommand(this.actionLanguageProfile, context.getModel());
            TransactionalEditingDomain domain = command.getEditingDomain();
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
            if (command.getCommandResult().getStatus().isOK()) {
                applied = true;
            }
        }
        return applied;
    }

    public boolean applyStandardProfile(Element context) {
        boolean applied = this.isStandardProfileApplied(context);
        if (!applied) {
            ApplyProfileCommand command = new ApplyProfileCommand(this.standardProfile, context.getModel());
            TransactionalEditingDomain domain = command.getEditingDomain();
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
            if (command.getCommandResult().getStatus().isOK()) {
                applied = true;
            }
        }
        return applied;
    }

    public Comment createTextualRepresentationComment(Element element) {
        Comment textualRepresentationComment = element.createOwnedComment();
        this.applyActionLanguageProfile(element);
        Stereotype textualRepresentationStereotype = this.getTextualRepresentationStereotype(textualRepresentationComment);
        textualRepresentationComment.applyStereotype(textualRepresentationStereotype);
        textualRepresentationComment.setValue(textualRepresentationStereotype, "language", (Object)"Alf");
        return textualRepresentationComment;
    }

    public boolean applyTextualRepresentation(Comment comment) {
        boolean applied = this.isActionLanguageProfileApplied((Element)comment);
        if (!applied) {
            applied = this.applyActionLanguageProfile((Element)comment);
        }
        if (applied) {
            comment.applyStereotype(this.textualRepresentationStereotype);
            comment.setValue(this.textualRepresentationStereotype, "language", (Object)"Alf");
        }
        return applied;
    }

    public void clean() {
        this.actionLanguageProfile = null;
        this.textualRepresentationStereotype = null;
    }

    class AlfUtilConstants {
        protected static final String STANDARD_PROFILE_NAME = "Standard";
        protected static final String ACTION_LANGUAGE_PROFILE_NAME = "ActionLanguage";
        protected static final String TEXTUAL_REPRESENTATION_STEREOTYPE_NAME = "TextualRepresentation";
        protected static final String TEXTUALREPRESENTATION_LANGUAGE_ATTR_NAME = "language";

        AlfUtilConstants() {
        }
    }
}

