/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.libraries.helper;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.alf.libraries.helper.AlfUtil;
import org.eclipse.papyrus.uml.alf.libraries.helper.ApplyProfileCommand;
import org.eclipse.papyrus.uml.alf.libraries.helper.BackupState;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class BackupUtil {
    private static BackupUtil singleton;
    protected Profile backupProfile;
    protected Stereotype backupStereotype;
    protected Enumeration backupStateEnumeration;
    private HashMap<BackupState.EditionStatus, EnumerationLiteral> stateMapping = new HashMap();
    private HashMap<EnumerationLiteral, BackupState.EditionStatus> inverseStateMapping = new HashMap();

    private BackupUtil() {
    }

    public static BackupUtil getInstance() {
        if (singleton == null) {
            singleton = new BackupUtil();
        }
        return singleton;
    }

    public Profile getBackupProfile(Element context) {
        if (this.backupProfile == null) {
            this.backupProfile = AlfUtil.getInstance().getProfile(context.getModel(), "TextualRepresentationBackup");
            this.backupStereotype = this.backupProfile.getOwnedStereotype("Backup");
            this.backupStateEnumeration = (Enumeration)this.backupProfile.getOwnedType("BackupState");
            this.initInternalConverter();
        }
        return this.backupProfile;
    }

    private void initInternalConverter() {
        for (EnumerationLiteral literal : this.backupStateEnumeration.getOwnedLiterals()) {
            if (literal.getLabel().equals("NONE")) {
                this.stateMapping.put(BackupState.EditionStatus.NONE, literal);
                this.inverseStateMapping.put(literal, BackupState.EditionStatus.NONE);
                continue;
            }
            if (literal.getLabel().equals("SAVED")) {
                this.stateMapping.put(BackupState.EditionStatus.SAVED, literal);
                this.inverseStateMapping.put(literal, BackupState.EditionStatus.SAVED);
                continue;
            }
            this.stateMapping.put(BackupState.EditionStatus.MERGED, literal);
            this.inverseStateMapping.put(literal, BackupState.EditionStatus.MERGED);
        }
    }

    public boolean isBackup(Element element) {
        boolean found = false;
        Iterator iteratorComments = element.getOwnedComments().iterator();
        while (iteratorComments.hasNext() && !found) {
            Comment current = (Comment)iteratorComments.next();
            if (!current.getAppliedStereotypes().contains((Object)this.backupStereotype)) continue;
            found = true;
        }
        return found;
    }

    public boolean isBackup(Comment comment) {
        return comment.getAppliedStereotypes().contains((Object)this.backupStereotype);
    }

    public Stereotype getBackuStereotype(Element element) {
        if (this.backupStereotype != null) {
            return this.backupStereotype;
        }
        if (this.isBackupProfileApplied(element) && !element.getOwnedComments().isEmpty()) {
            this.backupStereotype = ((Comment)element.getOwnedComments().get(0)).getApplicableStereotype("Backup");
            return this.backupStereotype;
        }
        return null;
    }

    public boolean applyBackup(Comment comment, BackupState state) {
        boolean applied = false;
        boolean profileApplied = true;
        if (!this.isBackupProfileApplied((Element)comment)) {
            if (this.backupProfile == null) {
                this.getBackupProfile((Element)comment);
            }
            profileApplied = PackageUtil.applyProfile((Package)comment.getModel(), (Profile)this.backupProfile, (boolean)true);
        }
        if (profileApplied) {
            if (!this.isBackup(comment)) {
                comment.applyStereotype(this.backupStereotype);
            }
            comment.setValue(this.backupStereotype, "timestamp", (Object)state.timestamp.toString());
            comment.setValue(this.backupStereotype, "state", (Object)this.stateMapping.get((Object)state.status));
        }
        return applied;
    }

    public BackupState getBackupState(Comment comment) {
        BackupState state = null;
        if (this.isBackup(comment)) {
            state = new BackupState();
            String timestamp = (String)comment.getValue(this.backupStereotype, "timestamp");
            if (timestamp != null && !timestamp.isEmpty()) {
                try {
                    state.timestamp = Timestamp.valueOf(timestamp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            EnumerationLiteral literal = (EnumerationLiteral)comment.getValue(this.backupStereotype, "state");
            if (state != null) {
                state.status = this.inverseStateMapping.get(literal);
            }
        }
        return state;
    }

    public boolean applyBackupProfile(Element context) {
        boolean applied = this.isBackupProfileApplied(context);
        if (!applied) {
            this.backupProfile = this.getBackupProfile(context);
            if (this.backupProfile != null) {
                ApplyProfileCommand command = new ApplyProfileCommand(this.backupProfile, context.getModel());
                TransactionalEditingDomain domain = command.getEditingDomain();
                domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
                if (command.getCommandResult().getStatus().isOK()) {
                    applied = true;
                }
            }
        }
        return applied;
    }

    public boolean isBackupProfileApplied(Element context) {
        return context.getModel().getAllAppliedProfiles().contains((Object)this.backupProfile);
    }

    public Comment getBackupComment(Element element) {
        Comment comment = null;
        Iterator iteratorComments = element.getOwnedComments().iterator();
        while (iteratorComments.hasNext() && comment == null) {
            Comment current = (Comment)iteratorComments.next();
            if (!current.getAppliedStereotypes().contains((Object)this.backupStereotype)) continue;
            comment = current;
        }
        return comment;
    }

    public Enumeration getBackupState(Element context) {
        if (this.backupStateEnumeration == null) {
            this.getBackupProfile(context);
        }
        return this.backupStateEnumeration;
    }

    public class BackupUtilConstants {
        public static final String BACKUP_PROFILE_NAME = "TextualRepresentationBackup";
        public static final String BACKUP_STEREOTYPE_NAME = "Backup";
        public static final String BACKUP_BACKUP_STATE_ENUMERATION_NAME = "BackupState";
        public static final String BACKUP_TIMESTAMP_ATTR_NAME = "timestamp";
        public static final String BACKUP_STATE_ATTR_NAME = "state";
    }
}

