/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.commands;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityActivityContentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.uml2.uml.Constraint;

public class CreateActionLocalConditionViewCommand
extends Command {
    private ActivityActivityContentCompartmentEditPart compartment = null;
    private ICommandProxy elementCreationCommand = null;
    private CompoundCommand viewsCreationCommand = null;
    private EditPart linkedActionEditPart;
    private IHintedType type;

    public CreateActionLocalConditionViewCommand(IHintedType conditionType, ActivityActivityContentCompartmentEditPart graphicalParent, EObject containerAction, EditPart actionPart) {
        this.elementCreationCommand = CreateActionLocalConditionViewCommand.getElementCreationCommand(containerAction, conditionType, (EditPart)graphicalParent);
        this.compartment = graphicalParent;
        this.linkedActionEditPart = actionPart;
        this.type = conditionType;
    }

    private static ICommandProxy getElementCreationCommand(EObject containerAction, IHintedType conditionType, EditPart part) {
        CreateElementRequest createElementReq = new CreateElementRequest(containerAction, (IElementType)conditionType);
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((Object)containerAction);
        if (commandService == null) {
            return null;
        }
        ICommand semanticCommand = commandService.getEditCommand((IEditCommandRequest)createElementReq);
        if (semanticCommand != null && semanticCommand.canExecute()) {
            return new ICommandProxy(semanticCommand);
        }
        return null;
    }

    private IHintedType getLinkType() {
        if (UMLElementTypes.Constraint_3011.equals(this.type)) {
            return (IHintedType)UMLElementTypes.ActionLocalPrecondition_4001;
        }
        if (UMLElementTypes.Constraint_3012.equals(this.type)) {
            return (IHintedType)UMLElementTypes.ActionLocalPostcondition_4002;
        }
        if (UMLElementTypes.IntervalConstraint_3032.equals(this.type)) {
            return (IHintedType)UMLElementTypes.ActionLocalPrecondition_4001;
        }
        if (UMLElementTypes.IntervalConstraint_3033.equals(this.type)) {
            return (IHintedType)UMLElementTypes.ActionLocalPostcondition_4002;
        }
        if (UMLElementTypes.DurationConstraint_3034.equals(this.type)) {
            return (IHintedType)UMLElementTypes.ActionLocalPrecondition_4001;
        }
        if (UMLElementTypes.DurationConstraint_3035.equals(this.type)) {
            return (IHintedType)UMLElementTypes.ActionLocalPostcondition_4002;
        }
        if (UMLElementTypes.TimeConstraint_3036.equals(this.type)) {
            return (IHintedType)UMLElementTypes.ActionLocalPrecondition_4001;
        }
        if (UMLElementTypes.TimeConstraint_3037.equals(this.type)) {
            return (IHintedType)UMLElementTypes.ActionLocalPostcondition_4002;
        }
        return null;
    }

    public boolean canExecute() {
        return this.elementCreationCommand != null && this.elementCreationCommand.canExecute();
    }

    public void execute() {
        Object constraint = null;
        if (this.elementCreationCommand != null) {
            this.elementCreationCommand.execute();
            constraint = this.elementCreationCommand.getICommand().getCommandResult().getReturnValue();
        }
        if (constraint instanceof Constraint && this.compartment != null && this.type != null) {
            IAdaptable targetAdapter;
            this.viewsCreationCommand = new CompoundCommand();
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)constraint), Node.class, this.type.getSemanticHint(), this.compartment.getDiagramPreferencesHint());
            CreateViewRequest request = new CreateViewRequest(descriptor);
            Command nodeCreationCommand = this.compartment.getCommand((Request)request);
            this.viewsCreationCommand.add(nodeCreationCommand);
            if (this.linkedActionEditPart != null && this.getLinkType() != null && (targetAdapter = this.extractResult(nodeCreationCommand)) != null) {
                SemanticAdapter sourceAdapter = new SemanticAdapter(null, this.linkedActionEditPart.getModel());
                CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getLinkType(), this.getLinkType().getSemanticHint(), this.compartment.getDiagramPreferencesHint());
                CommonDeferredCreateConnectionViewCommand aLinkCommand = new CommonDeferredCreateConnectionViewCommand(EditorUtils.getTransactionalEditingDomain(), this.getLinkType().getSemanticHint(), (IAdaptable)sourceAdapter, targetAdapter, this.compartment.getViewer(), this.compartment.getDiagramPreferencesHint(), linkdescriptor, null);
                aLinkCommand.setElement((EObject)constraint);
                this.viewsCreationCommand.add((Command)new ICommandProxy((ICommand)aLinkCommand));
            }
            this.viewsCreationCommand.execute();
        }
    }

    private IAdaptable extractResult(Command nodeCreationCommand) {
        if (nodeCreationCommand instanceof ICommandProxy) {
            ICommand createConstraintNodeCommand = ((ICommandProxy)nodeCreationCommand).getICommand();
            IAdaptable targetAdapter = (IAdaptable)createConstraintNodeCommand.getCommandResult().getReturnValue();
            return targetAdapter;
        }
        if (nodeCreationCommand instanceof CompoundCommand) {
            Object[] childrenCmd;
            Object[] objectArray = childrenCmd = ((CompoundCommand)nodeCreationCommand).getChildren();
            int n = childrenCmd.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable result;
                Object command = objectArray[n2];
                if (command instanceof Command && (result = this.extractResult((Command)command)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public void undo() {
        if (this.viewsCreationCommand != null) {
            this.viewsCreationCommand.undo();
        }
        if (this.elementCreationCommand != null) {
            this.elementCreationCommand.undo();
        }
    }
}

