/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ParameterNodeNameEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ActivityParameterNodeLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Type;

public class ActivityParameterMaskEditPolicy
extends AbstractMaskManagedEditPolicy {
    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        ActivityParameterNode node = this.getUMLElement();
        if (node == null) {
            return;
        }
        this.addListener(node.getParameter());
        this.addListener(node.getType());
        for (State state : node.getInStates()) {
            this.addListener(state);
        }
    }

    protected void addListener(Object target) {
        if (target instanceof EObject) {
            this.getDiagramEventBroker().addNotificationListener((EObject)target, (NotificationListener)this);
        }
    }

    public Collection<String> getDefaultDisplayValue() {
        return ICustomAppearance.DEFAULT_UML_ACTIVITYPARAMETERNODE;
    }

    public Map<String, String> getMasks() {
        return ActivityParameterNodeLabelHelper.getInstance().getMasks();
    }

    public ActivityParameterNode getUMLElement() {
        if (this.hostSemanticElement instanceof ActivityParameterNode) {
            return (ActivityParameterNode)this.hostSemanticElement;
        }
        return null;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        ActivityParameterNode activityParameterNode = this.getUMLElement();
        if (object == null || activityParameterNode == null) {
            return;
        }
        if (object.equals(activityParameterNode)) {
            this.notifyActivityParameterNodeChanged(activityParameterNode, notification);
        } else if (this.isParameter(object)) {
            this.notifyParameterChanged(notification);
        } else if (this.isType(object)) {
            this.notifyTypeChanged(notification);
        } else if (this.isState(object)) {
            this.notifyStateChanged(notification);
        }
    }

    protected boolean isType(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        return object.equals(this.getUMLElement().getType());
    }

    protected boolean isParameter(Object object) {
        if (!(object instanceof Parameter)) {
            return false;
        }
        return object.equals(this.getUMLElement().getParameter());
    }

    protected boolean isState(Object object) {
        if (!(object instanceof State)) {
            return false;
        }
        return this.getUMLElement().getInStates().contains(object);
    }

    protected void notifyParameterChanged(Notification notification) {
        if (5 == notification.getFeatureID(Parameter.class)) {
            this.refreshDisplay();
        }
    }

    protected void notifyTypeChanged(Notification notification) {
        if (5 == notification.getFeatureID(notification.getNotifier().getClass())) {
            this.refreshDisplay();
        }
    }

    protected void notifyStateChanged(Notification notification) {
        if (5 == notification.getFeatureID(notification.getNotifier().getClass())) {
            this.refreshDisplay();
        }
    }

    protected void notifyActivityParameterNodeChanged(ActivityParameterNode node, Notification notification) {
        block0 : switch (notification.getFeatureID(ActivityParameterNode.class)) {
            case 5: {
                this.refreshDisplay();
                break;
            }
            case 21: 
            case 22: 
            case 27: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.addListener(notification.getNewValue());
                        this.refreshDisplay();
                        break block0;
                    }
                    case 5: {
                        if (notification.getNewValue() instanceof List) {
                            List addedElements = (List)notification.getNewValue();
                            for (Object addedElement : addedElements) {
                                this.addListener(addedElement);
                            }
                        }
                        this.refreshDisplay();
                        break block0;
                    }
                    case 4: {
                        this.removeListenerFromElement(notification.getOldValue());
                        this.refreshDisplay();
                        break block0;
                    }
                    case 6: {
                        if (notification.getOldValue() instanceof List) {
                            List removedElements = (List)notification.getOldValue();
                            for (Object removedElement : removedElements) {
                                this.removeListenerFromElement(removedElement);
                            }
                        }
                        this.refreshDisplay();
                        break block0;
                    }
                    case 1: {
                        this.addListener(notification.getNewValue());
                        this.removeListenerFromElement(notification.getOldValue());
                        this.refreshDisplay();
                    }
                }
            }
        }
    }

    public void refreshDisplay() {
        ActivityParameterNodeLabelHelper.getInstance().refreshEditPartDisplay((org.eclipse.gef.GraphicalEditPart)((GraphicalEditPart)this.getHost()));
    }

    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        ActivityParameterNode activityParameterNode = this.getUMLElement();
        if (activityParameterNode == null) {
            return;
        }
        this.removeListenerFromElement(activityParameterNode.getParameter());
        this.removeListenerFromElement(activityParameterNode.getType());
        for (State state : activityParameterNode.getInStates()) {
            this.removeListenerFromElement(state);
        }
    }

    protected void removeListenerFromElement(Object target) {
        if (target instanceof EObject) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)target, (NotificationListener)this);
        }
    }

    public EditPart getHost() {
        GraphicalEditPart ep = (GraphicalEditPart)super.getHost();
        if (ep instanceof ParameterNodeNameEditPart) {
            return ep;
        }
        return ep.getChildBySemanticHint(Integer.toString(5071));
    }

    protected View getView() {
        View view = super.getView();
        if (view == null) {
            return null;
        }
        if (view instanceof Shape) {
            return view;
        }
        return (View)view.eContainer();
    }
}

