/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.tools.utils.Activator;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeUtil {
    protected static final String QUOTE = "\"";
    protected static final String SPACE_SEPARATOR = "#";
    protected static final String EQUAL_SEPARATOR = "=";
    protected static final String PROPERTY_VALUE_SEPARATOR = "|";
    protected static final String SETREOTYPE_WITH_VALUE_SEPARATOR = ";";
    protected static final String ST_LEFT = String.valueOf("\u00ab");
    protected static final String ST_RIGHT = String.valueOf("\u00bb");
    public static final String BASE_PREFIX = "base_";

    public static List<Stereotype> getAllSuperStereotypes(Stereotype stereotype) {
        ArrayList<Stereotype> generalStereotypes = new ArrayList<Stereotype>();
        for (Classifier generalClassifier : stereotype.getGenerals()) {
            if (!(generalClassifier instanceof Stereotype)) continue;
            generalStereotypes.add((Stereotype)generalClassifier);
            generalStereotypes.addAll(StereotypeUtil.getAllSuperStereotypes((Stereotype)generalClassifier));
        }
        return generalStereotypes;
    }

    public static EList<Image> getIcons(Stereotype stereotype) {
        BasicEList icons = new BasicEList();
        for (Image image : stereotype.getIcons()) {
            if (!"icon".equals(ImageUtil.getKind(image))) continue;
            icons.add((Object)image);
        }
        return icons;
    }

    private static List<String> getStereoPropertiesToDisplay(Stereotype stereotype, List<String> stPropList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String currentProp : stPropList) {
            if (!currentProp.substring(0, currentProp.lastIndexOf(".")).equals(stereotype.getQualifiedName())) continue;
            result.add(currentProp.substring(currentProp.lastIndexOf(".") + 1, currentProp.length()));
        }
        return result;
    }

    public static String getPropertiesValues(String stereotypesPropertiesToDisplay, Element umlElement) {
        HashSet<Stereotype> stereoSet = new HashSet<Stereotype>();
        ArrayList<String> stPropList = new ArrayList<String>();
        String propValues = "";
        StringTokenizer propStringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
        while (propStringTokenizer.hasMoreElements()) {
            String propertyQN = propStringTokenizer.nextToken();
            String stereotypeQN = propertyQN.substring(0, propertyQN.indexOf("."));
            Stereotype stereotype = umlElement.getAppliedStereotype(stereotypeQN);
            if (stereotype != null) {
                stereoSet.add(stereotype);
            }
            stPropList.add(propertyQN);
        }
        for (Stereotype stereotype : stereoSet) {
            propValues = String.valueOf(propValues) + ST_LEFT + stereotype.getName() + ST_RIGHT + SPACE_SEPARATOR;
            for (String stProp : StereotypeUtil.getStereoPropertiesToDisplay(stereotype, stPropList)) {
                Property currentProp = StereotypeUtil.getPropertyByName(stereotype, stProp);
                if (currentProp == null) {
                    return "No value";
                }
                propValues = String.valueOf(propValues) + StereotypeUtil.displayPropertyValue(stereotype, currentProp, umlElement, PROPERTY_VALUE_SEPARATOR);
            }
            if (propValues.endsWith(PROPERTY_VALUE_SEPARATOR)) {
                propValues = propValues.substring(0, propValues.lastIndexOf(PROPERTY_VALUE_SEPARATOR));
            }
            propValues = String.valueOf(propValues) + SETREOTYPE_WITH_VALUE_SEPARATOR;
        }
        return propValues;
    }

    public static String displayPropertyValue(Stereotype stereotype, Property property, Element umlElement, String separator) {
        Type propType = property.getType();
        if (propType instanceof Enumeration) {
            return StereotypeUtil.getPropertyValueForEnumerationType(property, stereotype, umlElement, separator);
        }
        if (propType instanceof Class && propType.getAppliedStereotypes() != null && propType.getAppliedStereotypes().size() > 0 && ((Stereotype)propType.getAppliedStereotypes().get(0)).getName().equals("Metaclass")) {
            return StereotypeUtil.getPropertyValueForMetaclassType(property, stereotype, umlElement, separator, false);
        }
        if (propType instanceof Stereotype) {
            return StereotypeUtil.getPropertyValueForStereotypeType(property, stereotype, umlElement, separator, false);
        }
        if (propType instanceof Class && !(propType instanceof Stereotype) && property.isComposite()) {
            return String.valueOf(property.getName()) + EQUAL_SEPARATOR + property.getName() + separator;
        }
        return StereotypeUtil.getPropertyValue(property, stereotype, umlElement, separator, false);
    }

    public static String displayPropertyValueOnly(Stereotype stereotype, Property property, Element umlElement, String separator) {
        Type propType = property.getType();
        if (propType instanceof Enumeration) {
            return StereotypeUtil.getPropertyValueOnlyForEnumerationType(property, stereotype, umlElement, separator);
        }
        if (propType instanceof Class && propType.getAppliedStereotypes() != null && propType.getAppliedStereotypes().size() > 0 && ((Stereotype)propType.getAppliedStereotypes().get(0)).getName().equals("Metaclass")) {
            return StereotypeUtil.getPropertyValueOnlyForMetaclassType(property, stereotype, umlElement, separator, false);
        }
        if (propType instanceof Stereotype) {
            return StereotypeUtil.getPropertyValueOnlyForStereotypeType(property, stereotype, umlElement, separator, false);
        }
        if (propType instanceof Class && !(propType instanceof Stereotype) && property.isComposite()) {
            return String.valueOf(property.getName()) + separator;
        }
        return StereotypeUtil.getPropertyValueOnly(property, stereotype, umlElement, separator, false);
    }

    public static String displayPropertyValueToEdit(Stereotype stereotype, Property property, Element umlElement, String separator) {
        Type propType = property.getType();
        if (propType instanceof Enumeration) {
            return StereotypeUtil.getPropertyValueForEnumerationType(property, stereotype, umlElement, separator);
        }
        if (propType instanceof Class && propType.getAppliedStereotypes() != null && propType.getAppliedStereotypes().size() > 0 && ((Stereotype)propType.getAppliedStereotypes().get(0)).getName().equals("Metaclass")) {
            return StereotypeUtil.getPropertyValueForMetaclassType(property, stereotype, umlElement, separator, true);
        }
        if (propType instanceof Stereotype) {
            return StereotypeUtil.getPropertyValueForStereotypeType(property, stereotype, umlElement, separator, true);
        }
        if (propType instanceof Class && !(propType instanceof Stereotype) && property.isComposite()) {
            return String.valueOf(property.getName()) + EQUAL_SEPARATOR + property.getName() + separator;
        }
        return StereotypeUtil.getPropertyValue(property, stereotype, umlElement, separator, true);
    }

    public static Property getPropertyByName(Stereotype stereotype, String propertyName) {
        for (Property tmpProperty : stereotype.getAllAttributes()) {
            String name = "";
            if (tmpProperty != null) {
                String string = name = tmpProperty.getName() != null ? tmpProperty.getName() : "";
            }
            if (!name.equals(propertyName)) continue;
            return tmpProperty;
        }
        return null;
    }

    public static String getPropertiesValuesInBrace(String stereotypesPropertiesToDisplay, Element umlElement) {
        String propertyValues = "";
        HashSet<Stereotype> stereoSet = new HashSet<Stereotype>();
        ArrayList<String> stPropList = new ArrayList<String>();
        StringTokenizer propStringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
        while (propStringTokenizer.hasMoreElements()) {
            String propertyQN = propStringTokenizer.nextToken();
            String stereotypeQN = propertyQN.substring(0, propertyQN.indexOf("."));
            Stereotype stereotype = umlElement.getAppliedStereotype(stereotypeQN);
            if (stereotype != null) {
                stereoSet.add(stereotype);
            }
            stPropList.add(propertyQN);
        }
        for (Stereotype stereotype : stereoSet) {
            if (stereotype == null) continue;
            if (propertyValues != null && propertyValues.trim().length() > 0) {
                propertyValues = String.valueOf(propertyValues) + ",";
            }
            propertyValues = String.valueOf(propertyValues) + StereotypeUtil.displayPropertyValuesForStereotype(stereotype, stPropList, umlElement);
        }
        return propertyValues;
    }

    public static String displayPropertyValuesForStereotype(Stereotype stereotype, List<String> stPropList, Element umlElement) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("");
        for (String stProp : StereotypeUtil.getStereoPropertiesToDisplay(stereotype, stPropList)) {
            Property currentProp = null;
            for (Property tmpProperty : stereotype.getAllAttributes()) {
                if (!stProp.equals(tmpProperty.getName())) continue;
                currentProp = tmpProperty;
            }
            if (currentProp == null) {
                return "No value";
            }
            Type propType = currentProp.getType();
            if (propType instanceof Enumeration) {
                buffer.append(StereotypeUtil.getPropertyValueForEnumerationType(currentProp, stereotype, umlElement, ","));
                continue;
            }
            if (propType instanceof Class && propType.getAppliedStereotypes() != null && propType.getAppliedStereotypes().size() > 0 && ((Stereotype)propType.getAppliedStereotypes().get(0)).getName().equals("Metaclass")) {
                buffer.append(StereotypeUtil.getPropertyValueForMetaclassType(currentProp, stereotype, umlElement, ",", false));
                continue;
            }
            if (propType instanceof Stereotype) {
                buffer.append(StereotypeUtil.getPropertyValueForStereotypeType(currentProp, stereotype, umlElement, ",", false));
                continue;
            }
            if (propType instanceof Class && !(propType instanceof Stereotype) && currentProp.isComposite()) {
                buffer.append(String.valueOf(stProp) + EQUAL_SEPARATOR + currentProp.getName() + ",");
                continue;
            }
            buffer.append(StereotypeUtil.getPropertyValue(currentProp, stereotype, umlElement, ",", false));
        }
        String propValues = buffer.toString();
        if (propValues.endsWith(",")) {
            propValues = propValues.substring(0, propValues.lastIndexOf(","));
        }
        return propValues;
    }

    private static String getPropertyValueForEnumerationType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR) {
        Object val;
        String out = "";
        out = property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null ? (property.getLower() != 0 || umlElement.getValue(stereotype, property.getName()) != null ? (property.getDefaultValue() != null || umlElement.getValue(stereotype, property.getName()) != null ? ((val = umlElement.getValue(stereotype, property.getName())) instanceof EnumerationLiteral ? String.valueOf(property.getName()) + EQUAL_SEPARATOR + ((EnumerationLiteral)val).getLabel() + PROPERTY_VALUE_SEPARATOR : String.valueOf(property.getName()) + EQUAL_SEPARATOR + val + PROPERTY_VALUE_SEPARATOR) : String.valueOf(property.getName()) + PROPERTY_VALUE_SEPARATOR) : String.valueOf(property.getName()) + PROPERTY_VALUE_SEPARATOR) : String.valueOf(property.getName()) + EQUAL_SEPARATOR + umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
        return out;
    }

    private static String getPropertyValueOnlyForEnumerationType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR) {
        Object val;
        String out = "";
        out = property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null ? (property.getLower() != 0 || umlElement.getValue(stereotype, property.getName()) != null ? (property.getDefaultValue() != null || umlElement.getValue(stereotype, property.getName()) != null ? ((val = umlElement.getValue(stereotype, property.getName())) instanceof EnumerationLiteral ? String.valueOf(((EnumerationLiteral)val).getLabel()) + PROPERTY_VALUE_SEPARATOR : val + PROPERTY_VALUE_SEPARATOR) : PROPERTY_VALUE_SEPARATOR) : PROPERTY_VALUE_SEPARATOR) : umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
        return out;
    }

    private static String getPropertyValueForMetaclassType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withQualifiedName) {
        String out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null && umlElement.getValue(stereotype, property.getName()) instanceof NamedElement) {
            out = withQualifiedName ? String.valueOf(property.getName()) + EQUAL_SEPARATOR + ((NamedElement)umlElement.getValue(stereotype, property.getName())).getQualifiedName() + PROPERTY_VALUE_SEPARATOR : String.valueOf(property.getName()) + EQUAL_SEPARATOR + ((NamedElement)umlElement.getValue(stereotype, property.getName())).getName() + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> elementNames = new ArrayList<String>();
            if (values != null) {
                int count = 0;
                while (count < values.size()) {
                    if (values.get(count) instanceof NamedElement) {
                        if (withQualifiedName) {
                            elementNames.add(((NamedElement)values.get(count)).getQualifiedName());
                        } else {
                            elementNames.add(((NamedElement)values.get(count)).getName());
                        }
                    }
                    ++count;
                }
            }
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + elementNames + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    private static String getPropertyValueOnlyForMetaclassType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withQualifiedName) {
        String out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null && umlElement.getValue(stereotype, property.getName()) instanceof NamedElement) {
            out = withQualifiedName ? String.valueOf(((NamedElement)umlElement.getValue(stereotype, property.getName())).getQualifiedName()) + PROPERTY_VALUE_SEPARATOR : String.valueOf(((NamedElement)umlElement.getValue(stereotype, property.getName())).getName()) + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> elementNames = new ArrayList<String>();
            if (values != null) {
                int count = 0;
                while (count < values.size()) {
                    if (values.get(count) instanceof NamedElement) {
                        if (withQualifiedName) {
                            elementNames.add(((NamedElement)values.get(count)).getQualifiedName());
                        } else {
                            elementNames.add(((NamedElement)values.get(count)).getName());
                        }
                    }
                    ++count;
                }
            }
            out = elementNames + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    private static String getPropertyValueForStereotypeType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withQualifiedName) {
        String out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null) {
            Object value = umlElement.getValue(stereotype, property.getName());
            Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
            out = withQualifiedName ? String.valueOf(property.getName()) + EQUAL_SEPARATOR + ((NamedElement)baseElement).getQualifiedName() + PROPERTY_VALUE_SEPARATOR : String.valueOf(property.getName()) + EQUAL_SEPARATOR + ((NamedElement)baseElement).getName() + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> baseElements = new ArrayList<String>();
            if (values != null) {
                int k = 0;
                while (k < values.size()) {
                    if (withQualifiedName) {
                        baseElements.add(((NamedElement)UMLUtil.getBaseElement((EObject)((EObject)values.get(k)))).getQualifiedName());
                    } else {
                        baseElements.add(((NamedElement)UMLUtil.getBaseElement((EObject)((EObject)values.get(k)))).getName());
                    }
                    ++k;
                }
            }
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + baseElements + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    private static String getPropertyValueOnlyForStereotypeType(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withQualifiedName) {
        String out = "";
        if (property.getUpper() == 1 && umlElement.getValue(stereotype, property.getName()) != null) {
            Object value = umlElement.getValue(stereotype, property.getName());
            Element baseElement = UMLUtil.getBaseElement((EObject)((EObject)value));
            out = withQualifiedName ? String.valueOf(((NamedElement)baseElement).getQualifiedName()) + PROPERTY_VALUE_SEPARATOR : String.valueOf(((NamedElement)baseElement).getName()) + PROPERTY_VALUE_SEPARATOR;
        } else if (property.getUpper() != 1) {
            List values = (List)umlElement.getValue(stereotype, property.getName());
            ArrayList<String> baseElements = new ArrayList<String>();
            if (values != null) {
                int k = 0;
                while (k < values.size()) {
                    if (withQualifiedName) {
                        baseElements.add(((NamedElement)UMLUtil.getBaseElement((EObject)((EObject)values.get(k)))).getQualifiedName());
                    } else {
                        baseElements.add(((NamedElement)UMLUtil.getBaseElement((EObject)((EObject)values.get(k)))).getName());
                    }
                    ++k;
                }
            }
            out = baseElements + PROPERTY_VALUE_SEPARATOR;
        } else {
            out = umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    private static String getPropertyValue(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withDelimitator) {
        String out = "";
        if (property.getLower() != 0 || umlElement.getValue(stereotype, property.getName()) != null) {
            if (property.getDefaultValue() != null || umlElement.getValue(stereotype, property.getName()) != null) {
                if (withDelimitator) {
                    String value = "" + umlElement.getValue(stereotype, property.getName());
                    out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + value + PROPERTY_VALUE_SEPARATOR;
                    if (value.contains("[")) {
                        out = out.replace("[", "[\"");
                        out = out.replace("]", "\"]");
                        out = out.replace(", ", "\",\"");
                    } else {
                        out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + QUOTE + value + QUOTE + PROPERTY_VALUE_SEPARATOR;
                    }
                } else {
                    if (umlElement.getValue(stereotype, property.getName()) instanceof EObject) {
                        ILabelProvider labelProvider = StereotypeUtil.getLabelProvider((EObject)property);
                        out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + labelProvider.getText(umlElement.getValue(stereotype, property.getName())) + PROPERTY_VALUE_SEPARATOR;
                        return out;
                    }
                    out = String.valueOf(property.getName()) + EQUAL_SEPARATOR + umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
                }
            } else {
                out = String.valueOf(property.getName()) + PROPERTY_VALUE_SEPARATOR;
            }
        } else {
            out = String.valueOf(property.getName()) + PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    private static String getPropertyValueOnly(Property property, Stereotype stereotype, Element umlElement, String PROPERTY_VALUE_SEPARATOR, boolean withDelimitator) {
        String out = "";
        if (property.getLower() != 0 || umlElement.getValue(stereotype, property.getName()) != null) {
            if (property.getDefaultValue() != null || umlElement.getValue(stereotype, property.getName()) != null) {
                if (withDelimitator) {
                    String value = "" + umlElement.getValue(stereotype, property.getName());
                    out = String.valueOf(value) + PROPERTY_VALUE_SEPARATOR;
                    if (!value.contains("[")) {
                        out = String.valueOf(value) + PROPERTY_VALUE_SEPARATOR;
                    }
                } else {
                    if (umlElement.getValue(stereotype, property.getName()) instanceof EObject) {
                        ILabelProvider labelProvider = StereotypeUtil.getLabelProvider((EObject)property);
                        out = String.valueOf(labelProvider.getText(umlElement.getValue(stereotype, property.getName()))) + PROPERTY_VALUE_SEPARATOR;
                        return out;
                    }
                    out = umlElement.getValue(stereotype, property.getName()) + PROPERTY_VALUE_SEPARATOR;
                }
            } else {
                out = PROPERTY_VALUE_SEPARATOR;
            }
        } else {
            out = PROPERTY_VALUE_SEPARATOR;
        }
        return out;
    }

    public static ILabelProvider getLabelProvider(EObject eObject) {
        try {
            return ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)eObject)).getLabelProvider();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return new LabelProvider();
        }
    }

    public static EList<Image> getShapes(Stereotype stereotype) {
        BasicEList shapes = new BasicEList();
        for (Image image : stereotype.getIcons()) {
            if (!"shape".equals(ImageUtil.getKind(image))) continue;
            shapes.add((Object)image);
        }
        return shapes;
    }

    public static final List<Property> getStereotypePropertiesWithoutBaseProperties(Stereotype stereotype) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property property : stereotype.getOwnedAttributes()) {
            if (!StereotypeUtil.isValidStereotypeProperty(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    public static final List<Property> getAllStereotypePropertiesWithoutBaseProperties(Stereotype stereotype) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property property : stereotype.getAllAttributes()) {
            if (!StereotypeUtil.isValidStereotypeProperty(property)) continue;
            properties.add(property);
        }
        return properties;
    }

    public static final boolean isValidStereotypeProperty(Property property) {
        Association association = property.getAssociation();
        if (association instanceof Extension) {
            Extension ext = (Extension)association;
            Class metaClass = ext.getMetaclass();
            if (property.getName().equals(BASE_PREFIX + metaClass.getName())) {
                return false;
            }
        }
        return true;
    }

    public static boolean isApplied(Element element, String str_name) {
        return element.getAppliedStereotype(str_name) != null;
    }

    public static boolean isApplied(Element element, java.lang.Class<? extends EObject> clazz) {
        for (EObject stereoApplication : element.getStereotypeApplications()) {
            if (!clazz.isAssignableFrom(stereoApplication.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isApplicable(Element element, java.lang.Class<? extends EObject> clazz) {
        return StereotypeUtil.getStereoName(element, clazz) != null;
    }

    public static Stereotype apply(Element element, String stereo_name) {
        Stereotype stereotype = element.getApplicableStereotype(stereo_name);
        if (stereotype != null) {
            boolean alreadyApplied;
            EList subStereos = element.getAppliedSubstereotypes(stereotype);
            boolean bl = alreadyApplied = subStereos.size() > 0;
            if (!alreadyApplied && element.getStereotypeApplication(stereotype) == null) {
                element.applyStereotype(stereotype);
            }
        }
        return stereotype;
    }

    public static void unapply(Element element, String stereo_name) {
        Stereotype stereotype = element.getApplicableStereotype(stereo_name);
        if (stereotype != null && element.getStereotypeApplication(stereotype) != null) {
            element.unapplyStereotype(stereotype);
        }
    }

    public static <T extends EObject> T applyApp(Element element, java.lang.Class<T> clazz) {
        if (StereotypeUtil.apply(element, clazz) != null) {
            return (T)UMLUtil.getStereotypeApplication((Element)element, clazz);
        }
        return null;
    }

    public static Stereotype apply(Element element, java.lang.Class<? extends EObject> clazz) {
        return StereotypeUtil.apply(element, StereotypeUtil.getStereoName(element, clazz));
    }

    public static void unapply(Element element, java.lang.Class<? extends EObject> clazz) {
        StereotypeUtil.unapply(element, StereotypeUtil.getStereoName(element, clazz));
    }

    public static String getStereoName(Element element, java.lang.Class<? extends EObject> clazz) {
        String name = clazz.getName().replace(".", "::");
        while (element.getApplicableStereotype(name) == null) {
            int index = name.indexOf("::");
            if (index == -1) {
                return null;
            }
            name = name.substring(index + 2);
        }
        return name;
    }
}

