/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.papyrus.infra.core.editor.reload.EMFTreeViewerContext;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.additional.AdditionalResourcesModel;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.modelexplorer.matching.LinkItemMatchingItem;
import org.eclipse.papyrus.views.modelexplorer.matching.ModelElementItemMatchingItem;
import org.eclipse.papyrus.views.modelexplorer.matching.ReferencableMatchingItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelExplorerTreeViewerContext
extends EMFTreeViewerContext {
    public ModelExplorerTreeViewerContext(AbstractTreeViewer viewer) {
        super(viewer);
    }

    public Object deresolveSelectableElement(Object selectableElement) {
        return EMFHelper.getEObject((Object)selectableElement);
    }

    public Object resolveSelectableElement(Object object) {
        return new ModelElementItemMatchingItemWithElement((EObject)object);
    }

    protected void setExpandedElements(AbstractTreeViewer viewer, Collection<?> toExpand) {
        if (viewer.getContentProvider() != null) {
            for (ModelElementItemMatchingItemWithElement next : Iterables.filter(toExpand, ModelElementItemMatchingItemWithElement.class)) {
                EObject currentEObject = next.element();
                ArrayList<EObject> parents = new ArrayList<EObject>();
                EObject tmp = currentEObject.eContainer();
                while (tmp != null) {
                    parents.add(tmp);
                    tmp = tmp.eContainer();
                }
                List reverseParents = Lists.reverse(parents);
                Resource r = null;
                r = !parents.isEmpty() ? ((EObject)parents.get(parents.size() - 1)).eResource() : currentEObject.eResource();
                if (r != null) {
                    ResourceSet rs = r.getResourceSet();
                    Resource resource = r;
                    if (rs instanceof ModelSet && AdditionalResourcesModel.isAdditionalResource((ModelSet)((ModelSet)rs), (URI)r.getURI())) {
                        viewer.expandToLevel((Object)new ReferencableMatchingItem(rs), 1);
                        viewer.expandToLevel((Object)new ReferencableMatchingItem(resource), 1);
                    }
                }
                EObject previousParent = null;
                for (EObject parent : reverseParents) {
                    if (parent.eContainingFeature() != null && previousParent != null) {
                        viewer.expandToLevel((Object)new LinkItemMatchingItem(previousParent, parent.eContainmentFeature()), 1);
                    }
                    ModelElementItemMatchingItem itemToExpand = new ModelElementItemMatchingItem(parent);
                    viewer.expandToLevel((Object)itemToExpand, 1);
                    previousParent = parent;
                }
                LinkItemMatchingItem linkItem = new LinkItemMatchingItem(currentEObject.eContainer(), currentEObject.eContainmentFeature());
                viewer.expandToLevel((Object)linkItem, 1);
                viewer.expandToLevel((Object)next, 1);
            }
        }
    }

    static class ModelElementItemMatchingItemWithElement
    extends ModelElementItemMatchingItem {
        private EObject element;

        ModelElementItemMatchingItemWithElement(EObject element) {
            super(element);
            this.element = element;
        }

        EObject element() {
            return this.element;
        }
    }
}

