/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.generator.xtend;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.codegen.base.IPFileSystemAccess;
import org.eclipse.papyrus.dsml.validation.model.profilenames.Utils;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ConstraintGen {
    public static CharSequence generateConstraint(Constraint constraint) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Created by the Papyrus DSML plugin generator");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"package ");
        String _topPkg = Utils.getTopPkg();
        _builder.append((Object)_topPkg, "");
        _builder.append((Object)".constraints;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.core.runtime.IStatus;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.validation.AbstractModelConstraint;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.validation.IValidationContext;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.uml2.uml.Element;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.uml2.uml.Stereotype;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = constraint.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"Constraint extends AbstractModelConstraint {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public IStatus validate(IValidationContext ctx) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (ctx.getTarget() instanceof Element) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Element element = (Element) ctx.getTarget();");
        _builder.newLine();
        _builder.newLine();
        Boolean _isConstraintForStereotype = Utils.isConstraintForStereotype((Constraint)constraint);
        if (_isConstraintForStereotype.booleanValue()) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"Stereotype appliedStereotype = element.getAppliedStereotype(\"");
            String _constraintForStereotype = Utils.getConstraintForStereotype((Constraint)constraint);
            _builder.append((Object)_constraintForStereotype, "\t\t\t");
            _builder.append((Object)"\"); //$NON-NLS-1$");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"if (appliedStereotype != null) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if (evaluateConstraint(element, appliedStereotype)) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return ctx.createSuccessStatus();");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"else {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return ctx.createFailureStatus(\"Constraint not validated\"); //$NON-NLS-1$");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"if (evaluateConstraint(element)) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ctx.createSuccessStatus();");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"else {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ctx.createFailureStatus(\"Constraint not validated\");");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ctx.createSuccessStatus();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        Boolean _isConstraintForStereotype_1 = Utils.isConstraintForStereotype((Constraint)constraint);
        if (_isConstraintForStereotype_1.booleanValue()) {
            boolean _notEquals;
            _builder.append((Object)"\t");
            _builder.append((Object)"private boolean evaluateConstraint(Element self, Stereotype appliedStereotype) {");
            _builder.newLine();
            ValueSpecification _specification = constraint.getSpecification();
            String _javaConstraintBody = Utils.getJavaConstraintBody((ValueSpecification)_specification);
            boolean bl = _notEquals = !Objects.equal((Object)_javaConstraintBody, null);
            if (_notEquals) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                ValueSpecification _specification_1 = constraint.getSpecification();
                String _javaConstraintBody_1 = Utils.getJavaConstraintBody((ValueSpecification)_specification_1);
                _builder.append((Object)_javaConstraintBody_1, "\t\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return true;");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        Boolean _isConstraintForStereotype_2 = Utils.isConstraintForStereotype((Constraint)constraint);
        boolean bl = _not = _isConstraintForStereotype_2 == false;
        if (_not) {
            boolean _notEquals_1;
            _builder.append((Object)"\t");
            _builder.append((Object)"private boolean evaluateConstraint(Element self) {");
            _builder.newLine();
            ValueSpecification _specification_2 = constraint.getSpecification();
            String _javaConstraintBody_2 = Utils.getJavaConstraintBody((ValueSpecification)_specification_2);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_javaConstraintBody_2, null);
            if (_notEquals_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                ValueSpecification _specification_3 = constraint.getSpecification();
                String _javaConstraintBody_3 = Utils.getJavaConstraintBody((ValueSpecification)_specification_3);
                _builder.append((Object)_javaConstraintBody_3, "\t\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return true;");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public static void generate(Resource input, IPFileSystemAccess fsa) {
        TreeIterator _allContents = input.getAllContents();
        UnmodifiableIterator contentIterator = Iterators.filter((Iterator)_allContents, Constraint.class);
        while (contentIterator.hasNext()) {
            Constraint constraint = (Constraint)contentIterator.next();
            Boolean _hasSpecificationForJava = Utils.hasSpecificationForJava((Constraint)constraint);
            if (!_hasSpecificationForJava.booleanValue()) continue;
            String _topPkg = Utils.getTopPkg();
            String _replaceAll = _topPkg.replaceAll("\\.", "/");
            String _plus = String.valueOf(_replaceAll) + "/constraints/";
            String _name = constraint.getName();
            String _plus_1 = String.valueOf(_plus) + _name;
            String fileName = String.valueOf(_plus_1) + "Constraint.java";
            CharSequence _generateConstraint = ConstraintGen.generateConstraint(constraint);
            String _string = _generateConstraint.toString();
            fsa.generateFile(fileName, _string);
        }
    }
}

