/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.model.profilenames;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String JAVA_LANGUAGE = "JAVA";
    private static final String OCL_LANGUAGE = "OCL";
    private static Map<String, String> constraintToItsPackage = new HashMap<String, String>();
    private static String pluginID;

    public static String getJavaConstraintBody(ValueSpecification valueSpecification) {
        if (valueSpecification == null || !(valueSpecification instanceof OpaqueExpression)) {
            return null;
        }
        int index = 0;
        for (String language : ((OpaqueExpression)valueSpecification).getLanguages()) {
            if (language.compareTo(JAVA_LANGUAGE) == 0) {
                return (String)((OpaqueExpression)valueSpecification).getBodies().get(index);
            }
            ++index;
        }
        return null;
    }

    public static Boolean hasSpecificationForJava(Constraint constraint) {
        ValueSpecification valueSpec = constraint.getSpecification();
        if (valueSpec == null || !(valueSpec instanceof OpaqueExpression)) {
            return false;
        }
        for (String language : ((OpaqueExpression)valueSpec).getLanguages()) {
            if (language.compareTo(JAVA_LANGUAGE) != 0) continue;
            return true;
        }
        return false;
    }

    public static String getConstraintForStereotype(Constraint constraint) {
        Namespace nameSpace = constraint.getContext();
        if (nameSpace instanceof Stereotype) {
            return ((Stereotype)constraint.getContext()).getQualifiedName();
        }
        return "";
    }

    public static Boolean isConstraintForStereotype(Constraint constraint) {
        Namespace nameSpace = constraint.getContext();
        if (nameSpace instanceof Stereotype) {
            return true;
        }
        return false;
    }

    public static String getOCLConstraintBody(Constraint constraint) {
        int index = 0;
        ValueSpecification valueSpec = constraint.getSpecification();
        if (valueSpec != null && valueSpec instanceof OpaqueExpression) {
            for (String language : ((OpaqueExpression)valueSpec).getLanguages()) {
                if (language.compareTo(OCL_LANGUAGE) == 0) {
                    return (String)((OpaqueExpression)valueSpec).getBodies().get(index);
                }
                ++index;
            }
        }
        return null;
    }

    public static Boolean hasSpecificationForOCL(Constraint constraint) {
        ValueSpecification valueSpec = constraint.getSpecification();
        if (valueSpec == null || !(valueSpec instanceof OpaqueExpression)) {
            return false;
        }
        for (String language : ((OpaqueExpression)valueSpec).getLanguages()) {
            if (language.compareTo(OCL_LANGUAGE) != 0) continue;
            return true;
        }
        return false;
    }

    public static void putMappnig(Constraint constraint, String pkg) {
        Utils.getConstraintToItsPackage().put(constraint.getQualifiedName(), pkg);
    }

    public static Map<String, String> getConstraintToItsPackage() {
        return constraintToItsPackage;
    }

    public static void setConstraintToItsPackage(Map<String, String> constraintToItsPackage) {
        Utils.constraintToItsPackage = constraintToItsPackage;
    }

    public static String getTopPkg() {
        return pluginID.toLowerCase();
    }

    public static void setPluginID(String ID) {
        pluginID = ID;
    }
}

