/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.runtime.model;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.layers.runtime.model.LayersModel;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStackApplication;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayersModelTest {
    protected static final String PROJECT_MODEL_URI = "org.eclipse.papyrus.infra.core/tmp/model1.di";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayersModel() throws CoreException, IOException {
        ModelSet mngr = new ModelSet();
        LayersModel layersModel = new LayersModel();
        mngr.registerModel((IModel)layersModel);
        URI uri = URI.createPlatformResourceURI((String)PROJECT_MODEL_URI, (boolean)true);
        mngr.createModels(uri);
        Assert.assertNotNull((String)"layer model root created", (Object)layersModel.getLayerStackApplication());
    }

    @Test
    public void testLookupLayerStackApplication() {
        ModelSet mngr = new ModelSet();
        LayersModel layersModel = new LayersModel();
        mngr.registerModel((IModel)layersModel);
        URI uri = URI.createPlatformResourceURI((String)PROJECT_MODEL_URI, (boolean)true);
        mngr.createModels(uri);
        Assert.assertNull((String)"lookup application return null", (Object)layersModel.lookupLayerStackApplication());
        Assert.assertNotNull((String)"layer model root created", (Object)layersModel.getLayerStackApplication());
        Assert.assertNotNull((String)"layer model root created", (Object)layersModel.lookupLayerStackApplication());
    }

    @Test
    public void testGetLayerStackApplication() {
        ModelSet mngr = new ModelSet();
        LayersModel layersModel = new LayersModel();
        mngr.registerModel((IModel)layersModel);
        URI uri = URI.createPlatformResourceURI((String)PROJECT_MODEL_URI, (boolean)true);
        mngr.createModels(uri);
        Assert.assertNotNull((String)"layer model root created", (Object)layersModel.getLayerStackApplication());
        Assert.assertTrue((String)"LayerStackApplication is found", (boolean)(layersModel.getLayerStackApplication() instanceof LayersStackApplication));
    }
}

