/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.async.fuml.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.moka.MokaConstants;
import org.eclipse.papyrus.moka.async.fuml.Semantics.CommonBehaviors.Communications.AsyncObjectActivation;
import org.eclipse.papyrus.moka.async.fuml.debug.TerminateSignalInstance;
import org.eclipse.papyrus.moka.communication.event.EventMessage;
import org.eclipse.papyrus.moka.communication.event.Start_Event;
import org.eclipse.papyrus.moka.communication.event.isuspendresume.Resume_Event;
import org.eclipse.papyrus.moka.communication.event.isuspendresume.Suspend_Event;
import org.eclipse.papyrus.moka.communication.event.iterminate.Terminate_Event;
import org.eclipse.papyrus.moka.communication.request.isuspendresume.Resume_Request;
import org.eclipse.papyrus.moka.communication.request.isuspendresume.Suspend_Request;
import org.eclipse.papyrus.moka.communication.request.iterminate.Terminate_Request;
import org.eclipse.papyrus.moka.debug.MokaStackFrame;
import org.eclipse.papyrus.moka.debug.MokaThread;
import org.eclipse.papyrus.moka.engine.AbstractExecutionEngine;
import org.eclipse.papyrus.moka.fuml.FUMLExecutionEngine;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.CompleteActions.AcceptEventActionEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.ActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.ActivityExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.ActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.ExtensionalValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.Object_;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.EventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.ObjectActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.SignalInstance;
import org.eclipse.papyrus.moka.fuml.debug.ControlDelegate;
import org.eclipse.papyrus.moka.fuml.debug.FUMLThread;
import org.eclipse.papyrus.moka.fuml.presentation.FUMLPresentationUtils;
import org.eclipse.papyrus.moka.ui.presentation.AnimationUtils;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.ActivityNode;

public class AsyncControlDelegate
extends ControlDelegate {
    protected FUMLThread mainThread;
    protected List<ObjectActivation> objectActivations = new ArrayList<ObjectActivation>();
    protected Map<ObjectActivation, FUMLThread> objectActivationsToFUMLThread = new HashMap<ObjectActivation, FUMLThread>();
    protected boolean terminateRequestByClient = false;
    protected Map<FUMLThread, Object> locks = new HashMap<FUMLThread, Object>();
    protected Map<AsyncObjectActivation, List<AcceptEventAction>> objectActivationToWaitingAcceptEventActions;

    public AsyncControlDelegate(AbstractExecutionEngine engine) {
        super(engine);
        this.threads = new ArrayList();
        this.objectActivationToWaitingAcceptEventActions = new HashMap<AsyncObjectActivation, List<AcceptEventAction>>();
    }

    public synchronized MokaThread[] getThreads() {
        return this.threads.toArray(new MokaThread[this.threads.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTermination() {
        while (!this.engine.isTerminated()) {
            AsyncControlDelegate asyncControlDelegate = this;
            synchronized (asyncControlDelegate) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeFUMLThread(FUMLThread thread, int reasonForResuming) {
        Object lock;
        thread.setSuspended(false);
        thread.stepEnded();
        thread.setReasonForResuming(reasonForResuming);
        thread.setReasonForSuspending(-1);
        if (reasonForResuming == 2) {
            thread.setIsStepping(true);
        }
        thread.setStackFrames(new IStackFrame[0]);
        Object object = lock = this.locks.get(thread);
        synchronized (object) {
            this.locks.remove(thread);
            lock.notify();
        }
    }

    public synchronized void resume(Resume_Request request) {
        IDebugElement elementToResume;
        this.reasonForResuming = request.getResumeDetail();
        if (this.reasonForResuming != 32) {
            this.reasonForResuming = 2;
        }
        if ((elementToResume = request.getDebugElement()) instanceof IDebugTarget) {
            for (FUMLThread thread : this.threads) {
                if (!thread.isSuspended() || thread.isWaiting()) continue;
                this.resumeFUMLThread(thread, this.reasonForResuming);
            }
        } else {
            FUMLThread thread = (FUMLThread)request.getDebugElement();
            this.resumeFUMLThread(thread, this.reasonForResuming);
        }
    }

    public synchronized void registerObjectActivation(ObjectActivation activation, String activationName) {
        FUMLThread fUMLThread = new FUMLThread(FUMLExecutionEngine.eInstance.getDebugTarget());
        this.threads.add(0, fUMLThread);
        if (activation == null) {
            fUMLThread.setName("Main Thread");
            fUMLThread.setStackFrames(new IStackFrame[0]);
            this.mainThread = fUMLThread;
            return;
        }
        this.objectActivations.add(activation);
        this.objectActivationsToFUMLThread.put(activation, fUMLThread);
        Start_Event event = new Start_Event((IDebugElement)fUMLThread, this.getThreads());
        fUMLThread.setName(String.valueOf(activationName) + " (" + fUMLThread.hashCode() + ")");
        fUMLThread.setStackFrames(new IStackFrame[0]);
        FUMLExecutionEngine.eInstance.sendEvent((EventMessage)event);
    }

    public void registerObjectActivation(ObjectActivation activation) {
        this.registerObjectActivation(activation, "ObjectActivation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(Terminate_Request request) {
        this.engine.setIsTerminated(true);
        this.terminateRequestByClient = true;
        for (List<AcceptEventAction> waitingOn : this.objectActivationToWaitingAcceptEventActions.values()) {
            for (EObject object : waitingOn) {
                AnimationUtils.getInstance().removeAnimationMarker(object);
            }
        }
        for (ExtensionalValue v : FUMLExecutionEngine.eInstance.getLocus().extensionalValues) {
            if (!(v instanceof Object_)) continue;
            ((Object_)v).send((SignalInstance)new TerminateSignalInstance());
        }
        Iterator<Object> iterator = this.locks.values().iterator();
        while (iterator.hasNext()) {
            Object lock;
            Object object = lock = iterator.next();
            synchronized (object) {
                lock.notify();
            }
        }
        AsyncControlDelegate asyncControlDelegate = this;
        synchronized (asyncControlDelegate) {
            ((Object)((Object)this)).notifyAll();
        }
        AnimationUtils.getInstance().removeAllAnimationMarker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyThreadTermination(ObjectActivation objectActivation) {
        if (this.terminateRequestByClient) {
            return;
        }
        if (!FUMLExecutionEngine.eInstance.isTerminated()) {
            FUMLThread fUMLThread = this.objectActivationsToFUMLThread.get(objectActivation);
            if (fUMLThread != null) {
                fUMLThread.setIsTerminated(true);
                this.threads.remove(fUMLThread);
            }
            Terminate_Event terminateEvent = null;
            if (this.threads.isEmpty()) {
                this.engine.setIsTerminated(true);
                AsyncControlDelegate asyncControlDelegate = this;
                synchronized (asyncControlDelegate) {
                    ((Object)((Object)this)).notifyAll();
                }
                terminateEvent = new Terminate_Event((IDebugElement)this.engine.getDebugTarget(), (IThread[])this.getThreads());
            } else if (fUMLThread != null) {
                terminateEvent = new Terminate_Event((IDebugElement)fUMLThread, (IThread[])this.getThreads());
            }
            if (terminateEvent != null) {
                FUMLExecutionEngine.eInstance.sendEvent(terminateEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyMainThreadLogicallyEnded() {
        Terminate_Event terminateEvent;
        if (this.terminateRequestByClient) {
            return;
        }
        this.mainThread.setIsTerminated(true);
        this.threads.remove(this.mainThread);
        if (this.threads.isEmpty()) {
            this.engine.setIsTerminated(true);
            AsyncControlDelegate asyncControlDelegate = this;
            synchronized (asyncControlDelegate) {
                ((Object)((Object)this)).notifyAll();
            }
            terminateEvent = new Terminate_Event((IDebugElement)this.engine.getDebugTarget(), (IThread[])this.getThreads());
        } else {
            terminateEvent = new Terminate_Event((IDebugElement)this.mainThread, (IThread[])this.getThreads());
        }
        FUMLExecutionEngine.eInstance.sendEvent((EventMessage)terminateEvent);
    }

    public synchronized void suspend(Suspend_Request request) {
        if (request.getDebugElement() instanceof IDebugTarget) {
            for (FUMLThread thread : this.threads) {
                thread.setReasonForSuspending(request.getSuspendDetail());
                thread.setIsStepping(false);
            }
        } else {
            FUMLThread thread = (FUMLThread)request.getDebugElement();
            thread.setReasonForSuspending(request.getSuspendDetail());
            thread.setIsStepping(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean control(Object object) {
        block22: {
            if (this.engine.isTerminated()) {
                return false;
            }
            ActivityNode semanticElement = null;
            Object_ executionContext = null;
            if (object instanceof ActivityNodeActivation) {
                semanticElement = ((ActivityNodeActivation)object).node;
                if (((ActivityNodeActivation)object).group != null) {
                    executionContext = ((ActivityNodeActivation)object).getExecutionContext();
                }
            } else if (object instanceof ActivityEdgeInstance) {
                semanticElement = ((ActivityEdgeInstance)object).edge;
                if (((ActivityEdgeInstance)object).group != null) {
                    executionContext = ((ActivityEdgeInstance)object).group.getActivityExecution().context;
                }
            } else {
                Activator.log.error((Throwable)new Exception("Unexpected element in ControlDelegate::control"));
                this.engine.setIsTerminated(true);
                return false;
            }
            if (executionContext != null) {
                try {
                    FUMLThread thread = null;
                    if (executionContext instanceof ActivityExecution) {
                        thread = this.mainThread;
                    } else {
                        ObjectActivation objectActivation = executionContext.objectActivation;
                        thread = this.objectActivationsToFUMLThread.get(objectActivation);
                        if (thread == null) {
                            thread = this.mainThread;
                        }
                    }
                    if (semanticElement != null && MokaConstants.MOKA_AUTOMATIC_ANIMATION && this.mode.equals("debug") && !thread.isStepping()) {
                        this.animate((EObject)semanticElement);
                    }
                    int reasonForSuspending = -1;
                    if (thread.getReasonForSuspending() != -1) {
                        reasonForSuspending = thread.getReasonForSuspending();
                    } else if (thread.getReasonForResuming() != 32) {
                        reasonForSuspending = 8;
                    } else if (this.elementsWithBreakpoints.contains(semanticElement)) {
                        reasonForSuspending = 16;
                    }
                    if (reasonForSuspending == -1) break block22;
                    thread.setSuspended(true);
                    thread.setReasonForSuspending(reasonForSuspending);
                    MokaStackFrame stackFrame = FUMLPresentationUtils.getMokaStackFrame((Object)object);
                    stackFrame.setThread((MokaThread)thread);
                    thread.setStackFrames(new IStackFrame[]{stackFrame});
                    Suspend_Event suspendEvent = new Suspend_Event((IDebugElement)thread, reasonForSuspending, this.getThreads());
                    this.engine.sendEvent((EventMessage)suspendEvent);
                    String lock = new String();
                    this.locks.put(thread, lock);
                    String string = lock;
                    synchronized (string) {
                        lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        return !this.engine.isTerminated();
    }

    public void notifyWaitingStateEntered(AsyncObjectActivation asyncObjectActivation) {
        FUMLThread thread = this.objectActivationsToFUMLThread.get(asyncObjectActivation);
        if (thread != null) {
            thread.setIsWaiting(true);
            thread.setSuspended(true);
            thread.setStackFrames(new IStackFrame[0]);
            if (MokaConstants.MOKA_AUTOMATIC_ANIMATION && this.mode.equals("debug")) {
                Suspend_Event suspendEvent = new Suspend_Event((IDebugElement)thread, 16, this.getThreads());
                this.engine.sendEvent((EventMessage)suspendEvent);
                ArrayList<AcceptEventAction> waitingAcceptEventActions = new ArrayList<AcceptEventAction>();
                for (EventAccepter eventAccepter : asyncObjectActivation.waitingEventAccepters) {
                    if (!(eventAccepter instanceof AcceptEventActionEventAccepter)) continue;
                    AcceptEventAction action = (AcceptEventAction)((AcceptEventActionEventAccepter)eventAccepter).actionActivation.node;
                    waitingAcceptEventActions.add(action);
                    AnimationUtils.getInstance().addAnimationMarker((EObject)action);
                }
                this.objectActivationToWaitingAcceptEventActions.put(asyncObjectActivation, waitingAcceptEventActions);
            }
        }
    }

    public void notifyWaitingStateExit(AsyncObjectActivation asyncObjectActivation, AcceptEventActionEventAccepter accepter) {
        FUMLThread thread = this.objectActivationsToFUMLThread.get(asyncObjectActivation);
        if (thread != null) {
            thread.setIsWaiting(false);
            thread.setSuspended(false);
            thread.setStackFrames(new IStackFrame[0]);
            if (MokaConstants.MOKA_AUTOMATIC_ANIMATION && this.mode.equals("debug")) {
                Resume_Event resumeEvent = new Resume_Event((IDebugElement)thread, 16, this.getThreads());
                this.engine.sendEvent((EventMessage)resumeEvent);
                List<AcceptEventAction> waitingAcceptEventActions = this.objectActivationToWaitingAcceptEventActions.get(asyncObjectActivation);
                AcceptEventAction action = (AcceptEventAction)accepter.actionActivation.node;
                if (waitingAcceptEventActions != null) {
                    waitingAcceptEventActions.remove(action);
                } else {
                    waitingAcceptEventActions = new ArrayList<AcceptEventAction>();
                }
                this.objectActivationToWaitingAcceptEventActions.put(asyncObjectActivation, waitingAcceptEventActions);
                if (action != null) {
                    AnimationUtils.getInstance().removeAnimationMarker((EObject)action);
                }
            }
        }
    }
}

