/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.assistant;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.Profile;

public class SelectProfilDialog
extends FormDialog {
    protected ArrayList<Profile> appliedLocalProfiles;
    protected Button selectionRadio;
    protected Label profileSelectionLabel;
    protected Combo profileSelectionCombo;
    protected Section lSection;
    protected String resultProfileName;

    public SelectProfilDialog(Shell shell, ArrayList<Profile> appliedLocalProfiles) {
        super(shell);
        this.appliedLocalProfiles = appliedLocalProfiles;
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText("Profile Selection");
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createFormSelectionSection(scrolledForm.getBody(), toolkit);
        this.refreshSectionsEnable(false);
        this.makeSelectionVisible(this.appliedLocalProfiles.size() > 0);
        this.addListeners();
        scrolledForm.reflow(true);
    }

    protected void makeSelectionVisible(boolean visible) {
        this.selectionRadio.setVisible(visible);
        this.profileSelectionLabel.setVisible(visible);
        this.profileSelectionCombo.setVisible(visible);
        this.profileSelectionCombo.setVisible(visible);
        this.lSection.setText("Select a rofile among registered profiles");
    }

    protected void refreshSectionsEnable(boolean selectionEnable) {
        this.selectionRadio.setSelection(selectionEnable);
        this.profileSelectionLabel.setEnabled(selectionEnable);
        this.profileSelectionCombo.setEnabled(selectionEnable);
        if (selectionEnable) {
            this.profileSelectionCombo.setFocus();
        }
    }

    protected void addListeners() {
        SelectionAdapter selectCreateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProfilDialog.this.refreshSectionsEnable(true);
                SelectProfilDialog.this.refreshOkButton();
            }
        };
        this.selectionRadio.addSelectionListener((SelectionListener)selectCreateListener);
        this.profileSelectionCombo.addSelectionListener((SelectionListener)selectCreateListener);
    }

    protected void refreshOkButton() {
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (isSelectionSelected) {
            if (this.profileSelectionCombo.getSelectionIndex() == -1) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        }
    }

    protected void createFormSelectionSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = "Select an existing profile";
        this.lSection = pToolkit.createSection(pParent, 320);
        this.lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            this.lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)this.lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.selectionRadio = pToolkit.createButton(lBody, "Selection profile mode", 16);
        this.selectionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.profileSelectionLabel = pToolkit.createLabel(lBody, "Profile:", 0);
        this.profileSelectionCombo = new Combo(lBody, 8);
        for (Profile profile : this.appliedLocalProfiles) {
            this.profileSelectionCombo.add(profile.getName());
        }
        pToolkit.adapt((Control)this.profileSelectionCombo, true, true);
        lInsideScrolledForm.reflow(true);
        this.lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void okPressed() {
        this.resultProfileName = null;
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (isSelectionSelected && this.profileSelectionCombo.getSelectionIndex() != -1) {
            this.resultProfileName = this.profileSelectionCombo.getItem(this.profileSelectionCombo.getSelectionIndex());
        }
        super.okPressed();
    }

    public String getProfileName() {
        return this.resultProfileName;
    }
}

