/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.integration.assistant;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.req.reqif.assistant.ReqIFSelectionPage;
import org.eclipse.papyrus.req.reqif.integration.assistant.AbstractWizardForPapyrus;
import org.eclipse.papyrus.req.reqif.integration.transformation.ReqIFImporterServiceEdit;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.ui.IImportWizard;
import org.eclipse.uml2.uml.Package;

public class ReqIFReImportWizard
extends AbstractWizardForPapyrus
implements IImportWizard {
    protected ReqIFSelectionPage reqifSelectionPage;

    public ReqIFReImportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.reqifSelectionPage = new ReqIFSelectionPage((Package)this.getSelectionSet().get(0));
        this.addPage((IWizardPage)this.reqifSelectionPage);
    }

    public boolean performFinish() {
        final TransactionalEditingDomain domain = this.modelSet.getTransactionalEditingDomain();
        IFile reqFile = this.reqifSelectionPage.getSelectedReqIFFile();
        this.resourceSet = Util.createTemporaryResourceSet();
        Resource reqIFResource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)reqFile.getFullPath().toOSString(), (boolean)true), true);
        if (reqIFResource.getContents().size() > 0 && reqIFResource.getContents().get(0) instanceof ReqIF) {
            final ReqIF importedReqIFModel = (ReqIF)reqIFResource.getContents().get(0);
            RecordingCommand cmd = new RecordingCommand(domain, "Re-importReqIF"){

                protected void doExecute() {
                    ReqIFImporterServiceEdit sysMLReqIFTransfomation = new ReqIFImporterServiceEdit(domain, importedReqIFModel, (Package)ReqIFReImportWizard.this.getSelectionSet().get(0));
                    sysMLReqIFTransfomation.reImportReqIFModel(true, "id", true);
                }
            };
            domain.getCommandStack().execute((Command)cmd);
        }
        return true;
    }
}

