/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.integration.transformation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.req.reqif.integration.assistant.ChooseReqIFTypeDialog;
import org.eclipse.papyrus.req.reqif.integration.command.DefineProfileCommand;
import org.eclipse.papyrus.req.reqif.transformation.ReqIFImporter;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.tools.profile.definition.Version;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ReqIFImporterServiceEdit
extends ReqIFImporter {
    public ReqIFImporterServiceEdit(TransactionalEditingDomain domain, ReqIF reqIFModel, Package UMLModel) {
        super(domain, reqIFModel, UMLModel);
    }

    @Override
    protected Class createClassWithRequirementName(Element owner) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)owner);
        if (provider == null) {
            return null;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)new CreateElementRequest(this.domain, (EObject)owner, (IElementType)UMLElementTypes.CLASS));
        if (createGMFCommand != null) {
            GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
            this.domain.getCommandStack().execute((Command)emfCommand);
            Class theClass = (Class)createGMFCommand.getCommandResult().getReturnValue();
            theClass.setName(theClass.getName().replaceAll("Class", "Requirement"));
            return theClass;
        }
        return null;
    }

    @Override
    protected Dependency createDependency(Package uMLModel) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)uMLModel);
        if (provider == null) {
            return null;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)new CreateElementRequest(this.domain, (EObject)uMLModel, (IElementType)UMLElementTypes.DEPENDENCY));
        if (createGMFCommand != null) {
            GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
            this.domain.getCommandStack().execute((Command)emfCommand);
            return (Dependency)createGMFCommand.getCommandResult().getReturnValue();
        }
        return null;
    }

    @Override
    protected HashMap<String, SpecType> selectReqIFType(Collection<SpecType> availableReqiFTypes) {
        HashMap<String, SpecType> selectedReqiFType = new HashMap<String, SpecType>();
        ChooseReqIFTypeDialog assistedDialog = new ChooseReqIFTypeDialog(new Shell(), availableReqiFTypes);
        assistedDialog.open();
        ArrayList result = assistedDialog.getSelectedElements();
        for (Object object : result) {
            if (!(object instanceof SpecType)) continue;
            selectedReqiFType.put(((SpecType)object).getLongName(), (SpecType)object);
        }
        return selectedReqiFType;
    }

    @Override
    protected void defineProfile(Profile profile) {
        try {
            DefineProfileCommand defineProfileCmd = new DefineProfileCommand(this.domain, new PapyrusDefinitionAnnotation(new Version(1, 0, 0), "generated by Papyrus Req", "", GregorianCalendar.getInstance().getTime().toString(), "Papyrus Req"), profile, true);
            defineProfileCmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
            profile.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

