/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.reqif.transformation;

import java.io.IOException;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.req.reqif.transformation.ReqIFBaseTransformation;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionBoolean;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionInteger;
import org.eclipse.rmf.reqif10.DatatypeDefinitionReal;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.EmbeddedValue;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.ReqIFHeader;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecRelationType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ProrXhtmlSimplifiedHelper;
import org.eclipse.rmf.reqif10.xhtml.XhtmlDivType;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class ReqIFExporter
extends ReqIFBaseTransformation {
    protected DatatypeDefinitionString datatypeDefinitionString;
    protected DatatypeDefinitionBoolean datatypeDefinitionBoolean;
    protected DatatypeDefinitionReal datatypeDefinitionReal;
    protected DatatypeDefinitionInteger datatypeDefinitionInteger;
    protected DatatypeDefinitionXHTML datatypeDefinitionXHTML;
    protected HashMap<Element, SpecObject> element_SpecObject;

    public ReqIFExporter(TransactionalEditingDomain domain, Package UMLModel) {
        super(domain, UMLModel);
    }

    public void exportReqIFModel(boolean withGUI, String reqIFpath) {
        this.reqIFModel = this.createReqIFResource(reqIFpath);
        this.objectTypeStereotypesMap = this.getAllPossibleRequirementType(this.targetUMLModel);
        this.specRelationTypeSterotypeMap = this.getAllPossibleSpecRelationType(this.targetUMLModel);
        this.objectTypeMap = new HashMap();
        this.specRelationTypeMap = new HashMap();
        this.element_SpecObject = new HashMap();
        this.reqifDatatTypeEnumeration = new HashMap();
        this.profileEnumeration = this.getAllPossibleEnumeration(this.targetUMLModel);
        this.exportEnumeration();
        this.getAllDataTypeDefinitionEnumeration();
        for (Stereotype adependencyStereotype : this.specRelationTypeSterotypeMap.values()) {
            this.exportSpecRelationType(this.reqIFModel, adependencyStereotype);
        }
        for (Stereotype stereotype : this.objectTypeStereotypesMap.values()) {
            this.exportSpecObjectTypes(this.reqIFModel, this.objectTypeMap, stereotype);
        }
        HashSet<Package> packageContainers = this.getRequirementContainers(this.targetUMLModel);
        for (Package aPackage : packageContainers) {
            SpecificationType aSpecificationType = ReqIF10Factory.eINSTANCE.createSpecificationType();
            aSpecificationType.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
            aSpecificationType.setLongName(aPackage.getName());
            this.reqIFModel.getCoreContent().getSpecTypes().add((Object)aSpecificationType);
            Specification aSpecification = ReqIF10Factory.eINSTANCE.createSpecification();
            aSpecification.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
            aSpecification.setLongName(aPackage.getName());
            aSpecification.setType(aSpecificationType);
            this.reqIFModel.getCoreContent().getSpecifications().add((Object)aSpecification);
            for (PackageableElement aPackageableElement : aPackage.getPackagedElements()) {
                this.exportAHierarchy(aSpecification, this.reqIFModel, aPackageableElement);
            }
        }
        this.exportSpecRelation();
        try {
            this.reqIFModel.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void exportSpecRelation() {
        TreeIterator containedElementIterator = this.targetUMLModel.eAllContents();
        while (containedElementIterator.hasNext()) {
            EObject eObject = (EObject)containedElementIterator.next();
            if (!(eObject instanceof Dependency)) continue;
            Dependency aDependency = (Dependency)eObject;
            EList appliedStereotypes = aDependency.getAppliedStereotypes();
            for (Stereotype appliedstereotype : appliedStereotypes) {
                if (!this.specRelationTypeSterotypeMap.values().contains(appliedstereotype) || !this.element_SpecObject.containsKey(aDependency.getClients().get(0)) || !this.element_SpecObject.containsKey(aDependency.getSuppliers().get(0))) continue;
                SpecRelation specRelation = ReqIF10Factory.eINSTANCE.createSpecRelation();
                specRelation.setType((SpecRelationType)this.specRelationTypeMap.get(appliedstereotype.getName()));
                specRelation.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
                specRelation.setLongName(aDependency.getName());
                specRelation.setSource(this.element_SpecObject.get(aDependency.getClients().get(0)));
                specRelation.setTarget(this.element_SpecObject.get(aDependency.getSuppliers().get(0)));
                this.exportAttributeValues(this.specRelationTypeMap, (Element)aDependency, appliedstereotype, (SpecElementWithAttributes)specRelation);
                this.reqIFModel.getCoreContent().getSpecRelations().add((Object)specRelation);
            }
        }
    }

    protected void exportEnumeration() {
        for (Enumeration theEnumeration : this.profileEnumeration.values()) {
            DatatypeDefinitionEnumeration definitionEnumeration = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionEnumeration();
            definitionEnumeration.setLongName(theEnumeration.getName());
            definitionEnumeration.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
            int i = 0;
            for (EnumerationLiteral theEnumerationLiteral : theEnumeration.getOwnedLiterals()) {
                EnumValue theEnumValue = ReqIF10Factory.eINSTANCE.createEnumValue();
                theEnumValue.setLongName(theEnumerationLiteral.getName());
                theEnumValue.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
                EmbeddedValue embeddedValue = ReqIF10Factory.eINSTANCE.createEmbeddedValue();
                embeddedValue.setKey(new BigInteger("" + i));
                embeddedValue.setOtherContent(String.valueOf(theEnumeration.getName()) + "_" + theEnumerationLiteral.getName());
                theEnumValue.setProperties(embeddedValue);
                definitionEnumeration.getSpecifiedValues().add((Object)theEnumValue);
                ++i;
            }
            this.reqIFModel.getCoreContent().getDatatypes().add((Object)definitionEnumeration);
        }
    }

    protected void exportAHierarchy(Specification aSpecification, ReqIF reqIFModel, PackageableElement aPackageableElement) {
        EList appliedStereotypes = aPackageableElement.getAppliedStereotypes();
        for (Stereotype appliedstereotype : appliedStereotypes) {
            if (!this.objectTypeStereotypesMap.values().contains(appliedstereotype)) continue;
            SpecHierarchy hierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
            hierarchy.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
            SpecObject specObject = this.exportSpecObjects(reqIFModel, this.objectTypeStereotypesMap, this.objectTypeMap, (Element)((Class)aPackageableElement));
            hierarchy.setObject(specObject);
            aSpecification.getChildren().add((Object)hierarchy);
            for (Element containedElement : aPackageableElement.getOwnedElements()) {
                this.exportAHierarchy(hierarchy, reqIFModel, containedElement);
            }
        }
    }

    protected void exportAHierarchy(SpecHierarchy hierarchy, ReqIF reqIFModel, Element containedElement) {
        EList appliedStereotypes = containedElement.getAppliedStereotypes();
        for (Stereotype appliedstereotype : appliedStereotypes) {
            if (!this.objectTypeStereotypesMap.values().contains(appliedstereotype)) continue;
            SpecHierarchy childhierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
            childhierarchy.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
            SpecObject specObject = this.exportSpecObjects(reqIFModel, this.objectTypeStereotypesMap, this.objectTypeMap, (Element)((Class)containedElement));
            childhierarchy.setObject(specObject);
            hierarchy.getChildren().add((Object)childhierarchy);
            for (Element childcontainedElement : containedElement.getOwnedElements()) {
                this.exportAHierarchy(childhierarchy, reqIFModel, childcontainedElement);
            }
        }
    }

    public HashSet<Package> getRequirementContainers(Package UMLModel) {
        HashSet<Package> requirementContainers = new HashSet<Package>();
        TreeIterator modelIterator = UMLModel.eAllContents();
        while (modelIterator.hasNext()) {
            EObject eObject = (EObject)modelIterator.next();
            if (!(eObject instanceof Class)) continue;
            Class clazz = (Class)eObject;
            EList appliedStereotypes = clazz.getAppliedStereotypes();
            for (Stereotype appliedstereotype : appliedStereotypes) {
                if (!this.objectTypeStereotypesMap.values().contains(appliedstereotype) || !(clazz.eContainer() instanceof Package)) continue;
                requirementContainers.add((Package)clazz.eContainer());
            }
        }
        return requirementContainers;
    }

    protected ReqIF createReqIFResource(String reqIFpath) {
        URI reqIFURI = URI.createPlatformResourceURI((String)reqIFpath, (boolean)true);
        ResourceSet resourceSet = Util.createTemporaryResourceSet();
        Resource reqIFResource = resourceSet.createResource(reqIFURI);
        this.reqIFModel = ReqIF10Factory.eINSTANCE.createReqIF();
        ReqIFHeader header = ReqIF10Factory.eINSTANCE.createReqIFHeader();
        header.setSourceToolId("Papyrus Req");
        header.setReqIFVersion("1.0.1");
        header.setCreationTime((GregorianCalendar)GregorianCalendar.getInstance());
        header.setComment("generated by Papyrus Requirement from " + this.targetUMLModel.eResource().getURI().lastSegment());
        header.setTitle(this.targetUMLModel.getName());
        header.setReqIFToolId("Papyrus Req");
        this.reqIFModel.setTheHeader(header);
        ReqIFContent reqIFContent = ReqIF10Factory.eINSTANCE.createReqIFContent();
        this.reqIFModel.setCoreContent(reqIFContent);
        reqIFResource.getContents().add((Object)this.reqIFModel);
        this.createBasicDataType(this.reqIFModel);
        try {
            reqIFResource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.reqIFModel;
    }

    protected void createBasicDataType(ReqIF reqIFModel) {
        this.datatypeDefinitionString = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionString();
        this.datatypeDefinitionString.setLongName("String");
        this.datatypeDefinitionString.setDesc("String that been written by Papyrus Req");
        this.datatypeDefinitionString.setMaxLength(new BigInteger("2147483647"));
        this.datatypeDefinitionString.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
        reqIFModel.getCoreContent().getDatatypes().add((Object)this.datatypeDefinitionString);
        this.datatypeDefinitionBoolean = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionBoolean();
        this.datatypeDefinitionBoolean.setLongName("Boolean");
        this.datatypeDefinitionBoolean.setDesc("Boolean that been written by Papyrus Req");
        this.datatypeDefinitionBoolean.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
        reqIFModel.getCoreContent().getDatatypes().add((Object)this.datatypeDefinitionBoolean);
        this.datatypeDefinitionReal = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionReal();
        this.datatypeDefinitionReal.setLongName("Real");
        this.datatypeDefinitionReal.setDesc("Real that been written by Papyrus Req");
        this.datatypeDefinitionReal.setAccuracy(new BigInteger("64"));
        this.datatypeDefinitionReal.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
        this.datatypeDefinitionReal.setMax(Double.MAX_VALUE);
        this.datatypeDefinitionReal.setMin(Double.MIN_VALUE);
        reqIFModel.getCoreContent().getDatatypes().add((Object)this.datatypeDefinitionReal);
        this.datatypeDefinitionInteger = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionInteger();
        this.datatypeDefinitionInteger.setLongName("Integer");
        this.datatypeDefinitionInteger.setDesc("Integer that been written by Papyrus Req");
        this.datatypeDefinitionInteger.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
        this.datatypeDefinitionInteger.setMax(new BigInteger("2147483647"));
        this.datatypeDefinitionInteger.setMin(new BigInteger("-2147483648"));
        reqIFModel.getCoreContent().getDatatypes().add((Object)this.datatypeDefinitionInteger);
        this.datatypeDefinitionXHTML = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionXHTML();
        this.datatypeDefinitionXHTML.setLongName("XHTML");
        this.datatypeDefinitionXHTML.setDesc("XHTML that been written by Papyrus Req");
        this.datatypeDefinitionXHTML.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
        reqIFModel.getCoreContent().getDatatypes().add((Object)this.datatypeDefinitionXHTML);
    }

    protected SpecObject exportSpecObjects(ReqIF reqIFModel, HashMap<String, Stereotype> reqStereotypes, HashMap<String, SpecType> createdReqiFType, Element clazz) {
        EList appliedStereotypes = clazz.getAppliedStereotypes();
        for (Stereotype appliedstereotype : appliedStereotypes) {
            if (!reqStereotypes.values().contains(appliedstereotype)) continue;
            SpecObject reqinReqIF = ReqIF10Factory.eINSTANCE.createSpecObject();
            reqinReqIF.setType((SpecObjectType)createdReqiFType.get(appliedstereotype.getName()));
            reqinReqIF.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
            this.element_SpecObject.put(clazz, reqinReqIF);
            if (clazz instanceof NamedElement) {
                reqinReqIF.setLongName(((NamedElement)clazz).getName());
            }
            reqIFModel.getCoreContent().getSpecObjects().add((Object)reqinReqIF);
            this.exportAttributeValues(createdReqiFType, clazz, appliedstereotype, (SpecElementWithAttributes)reqinReqIF);
            return reqinReqIF;
        }
        return null;
    }

    protected void exportAttributeValues(HashMap<String, SpecType> createdReqiFType, Element clazz, Stereotype appliedstereotype, SpecElementWithAttributes reqinReqIF) {
        for (Property property : appliedstereotype.getAllAttributes()) {
            AttributeValueInteger attribute;
            if (clazz.getValue(appliedstereotype, property.getName()) == null || property.getType() == null) continue;
            AttributeDefinition currentAttributeDefinition = null;
            currentAttributeDefinition = this.getAttributeDefinition(createdReqiFType, appliedstereotype, property.getName());
            if (currentAttributeDefinition == null) continue;
            if (property.getType().getName().equals("String")) {
                String value = (String)clazz.getValue(appliedstereotype, property.getName());
                value = this.filterHtml(value);
                AttributeValueString attributeString = ReqIF10Factory.eINSTANCE.createAttributeValueString();
                attributeString.setDefinition((AttributeDefinitionString)currentAttributeDefinition);
                attributeString.setTheValue(value);
                reqinReqIF.getValues().add((Object)attributeString);
            }
            if (property.getType().getName().equals("Integer")) {
                attribute = ReqIF10Factory.eINSTANCE.createAttributeValueInteger();
                attribute.setDefinition((AttributeDefinitionInteger)currentAttributeDefinition);
                attribute.setTheValue(new BigInteger("" + clazz.getValue(appliedstereotype, property.getName())));
                reqinReqIF.getValues().add((Object)attribute);
            }
            if (property.getType().getName().equals("Boolean")) {
                attribute = ReqIF10Factory.eINSTANCE.createAttributeValueBoolean();
                attribute.setDefinition((AttributeDefinitionBoolean)currentAttributeDefinition);
                attribute.setTheValue(((Boolean)clazz.getValue(appliedstereotype, property.getName())).booleanValue());
                reqinReqIF.getValues().add((Object)attribute);
            }
            if (property.getType().getName().equals("Real")) {
                attribute = ReqIF10Factory.eINSTANCE.createAttributeValueReal();
                attribute.setDefinition((AttributeDefinitionReal)currentAttributeDefinition);
                attribute.setTheValue(((Double)clazz.getValue(appliedstereotype, property.getName())).doubleValue());
                reqinReqIF.getValues().add((Object)attribute);
            }
            if (property.getType().getName().equals("XHTML")) {
                attribute = ReqIF10Factory.eINSTANCE.createAttributeValueXHTML();
                attribute.setDefinition((AttributeDefinitionXHTML)currentAttributeDefinition);
                String value = (String)clazz.getValue(appliedstereotype, property.getName());
                value = this.filterHtml(value);
                XhtmlDivType xmlDivType = ProrXhtmlSimplifiedHelper.stringToSimplifiedXhtml((String)value);
                XhtmlContent xhtmlContent = ReqIF10Factory.eINSTANCE.createXhtmlContent();
                xhtmlContent.setXhtml((EObject)xmlDivType);
                attribute.setTheValue(xhtmlContent);
                reqinReqIF.getValues().add((Object)attribute);
            }
            if (!(property.getType() instanceof Enumeration)) continue;
            attribute = ReqIF10Factory.eINSTANCE.createAttributeValueEnumeration();
            DatatypeDefinitionEnumeration datatypeDefinitionEnumeration = (DatatypeDefinitionEnumeration)this.reqifDatatTypeEnumeration.get(property.getType().getName());
            EnumValue currentEnumValue = null;
            for (EnumValue enumValue : datatypeDefinitionEnumeration.getSpecifiedValues()) {
                if (!enumValue.getLongName().equals(((EnumerationLiteral)clazz.getValue(appliedstereotype, property.getName())).getName())) continue;
                currentEnumValue = enumValue;
            }
            attribute.setDefinition((AttributeDefinitionEnumeration)currentAttributeDefinition);
            attribute.getValues().add(currentEnumValue);
            reqinReqIF.getValues().add((Object)attribute);
        }
    }

    protected String filterHtml(String value) {
        if (value.toLowerCase().contains("<html") || value.toLowerCase().contains("<xhtml")) {
            value = value.replaceAll("</xhtml:XhtmlDivType>", "");
            value = value.replaceAll("<xhtml:XhtmlDivType xmlns:xhtml=\"http://www.w3.org/1999/xhtml\">", "");
            value = value.replaceAll("<xhtml:XhtmlDivType>", "");
        }
        return value;
    }

    protected AttributeDefinition getAttributeDefinition(HashMap<String, SpecType> createdReqiFType, Stereotype appliedstereotype, String propertyName) {
        AttributeDefinition currentAttributeDefinition = null;
        EList specAttribtutes = createdReqiFType.get(appliedstereotype.getName()).getSpecAttributes();
        for (AttributeDefinition attributeDefinition : specAttribtutes) {
            if (!attributeDefinition.getLongName().equals(propertyName)) continue;
            currentAttributeDefinition = attributeDefinition;
        }
        return currentAttributeDefinition;
    }

    protected void exportSpecRelationType(ReqIF reqIFModel, Stereotype adependencyStereotype) {
        SpecRelationType aSpecRealtionType = ReqIF10Factory.eINSTANCE.createSpecRelationType();
        aSpecRealtionType.setLongName(adependencyStereotype.getName());
        if (adependencyStereotype.getOwnedComments().size() > 0) {
            aSpecRealtionType.setDesc(((Comment)adependencyStereotype.getOwnedComments().get(0)).getBody());
        } else {
            aSpecRealtionType.setDesc("no Description");
        }
        aSpecRealtionType.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
        aSpecRealtionType.setIdentifier(EcoreUtil.getID((EObject)adependencyStereotype));
        reqIFModel.getCoreContent().getSpecTypes().add((Object)aSpecRealtionType);
        this.exporttoAttributeType(adependencyStereotype, (SpecType)aSpecRealtionType);
        this.specRelationTypeMap.put(aSpecRealtionType.getLongName(), aSpecRealtionType);
    }

    protected void exportSpecObjectTypes(ReqIF reqIFModel, HashMap<String, SpecType> createdReqiFType, Stereotype stereotype) {
        SpecObjectType specObjectType = ReqIF10Factory.eINSTANCE.createSpecObjectType();
        specObjectType.setLongName(stereotype.getName());
        if (stereotype.getOwnedComments().size() > 0) {
            specObjectType.setDesc(((Comment)stereotype.getOwnedComments().get(0)).getBody());
        } else {
            specObjectType.setDesc("no Description");
        }
        specObjectType.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
        specObjectType.setIdentifier(EcoreUtil.getID((EObject)stereotype));
        reqIFModel.getCoreContent().getSpecTypes().add((Object)specObjectType);
        this.exporttoAttributeType(stereotype, (SpecType)specObjectType);
        createdReqiFType.put(specObjectType.getLongName(), (SpecType)specObjectType);
    }

    protected void exporttoAttributeType(Stereotype stereotype, SpecType specType) {
        for (Property property : stereotype.getAllAttributes()) {
            AttributeDefinitionString attribute;
            if (property.getType() == null) continue;
            if (property.getType().getName().equals("String")) {
                attribute = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
                attribute.setLongName(property.getName());
                attribute.setEditable(true);
                attribute.setIdentifier(EcoreUtil.getID((EObject)property));
                attribute.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
                attribute.setType(this.datatypeDefinitionString);
                specType.getSpecAttributes().add((Object)attribute);
            }
            if (property.getType().getName().equals("Integer")) {
                attribute = ReqIF10Factory.eINSTANCE.createAttributeDefinitionInteger();
                attribute.setLongName(property.getName());
                attribute.setEditable(true);
                attribute.setIdentifier(EcoreUtil.getID((EObject)property));
                attribute.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
                attribute.setType(this.datatypeDefinitionInteger);
                specType.getSpecAttributes().add((Object)attribute);
            }
            if (property.getType().getName().equals("Boolean")) {
                attribute = ReqIF10Factory.eINSTANCE.createAttributeDefinitionBoolean();
                attribute.setLongName(property.getName());
                attribute.setEditable(true);
                attribute.setIdentifier(EcoreUtil.getID((EObject)property));
                attribute.setType(this.datatypeDefinitionBoolean);
                attribute.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
                specType.getSpecAttributes().add((Object)attribute);
            }
            if (property.getType().getName().equals("Real")) {
                attribute = ReqIF10Factory.eINSTANCE.createAttributeDefinitionReal();
                attribute.setLongName(property.getName());
                attribute.setEditable(true);
                attribute.setIdentifier(EcoreUtil.getID((EObject)property));
                attribute.setType(this.datatypeDefinitionReal);
                attribute.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
                specType.getSpecAttributes().add((Object)attribute);
            }
            if (property.getType().getName().equals("XHTML")) {
                attribute = ReqIF10Factory.eINSTANCE.createAttributeDefinitionXHTML();
                attribute.setLongName(property.getName());
                attribute.setEditable(true);
                attribute.setType(this.datatypeDefinitionXHTML);
                attribute.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
                specType.getSpecAttributes().add((Object)attribute);
            }
            if (!(property.getType() instanceof Enumeration)) continue;
            attribute = ReqIF10Factory.eINSTANCE.createAttributeDefinitionEnumeration();
            attribute.setLongName(property.getName());
            attribute.setEditable(true);
            attribute.setIdentifier(EcoreUtil.getID((EObject)property));
            if (property.getUpper() == -1) {
                attribute.setMultiValued(true);
            } else {
                attribute.setMultiValued(false);
            }
            attribute.setLastChange((GregorianCalendar)GregorianCalendar.getInstance());
            attribute.setType((DatatypeDefinitionEnumeration)this.reqifDatatTypeEnumeration.get(property.getType().getName()));
            specType.getSpecAttributes().add((Object)attribute);
        }
    }
}

